/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.bestpractices;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexUnitTestRule;

public class ApexUnitTestMethodShouldHaveIsTestAnnotationRule
extends AbstractApexUnitTestRule {
    private static final Set<String> ASSERT_METHODS = new HashSet<String>();

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (this.isTestMethodOrClass(node)) {
            return data;
        }
        return this.checkForAssertStatements(node, data);
    }

    private Object checkForAssertStatements(ASTMethod testMethod, Object data) {
        List methodCallList = testMethod.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression assertMethodCall : methodCallList) {
            String assertMethodName = assertMethodCall.getFullMethodName().toLowerCase(Locale.ROOT);
            if (!ASSERT_METHODS.contains(assertMethodName)) continue;
            this.addViolationWithMessage(data, testMethod, "''{0}'' method should have @IsTest annotation.", new Object[]{testMethod.getImage()});
            return data;
        }
        return data;
    }

    static {
        ASSERT_METHODS.add("system.assert");
        ASSERT_METHODS.add("system.assertequals");
        ASSERT_METHODS.add("system.assertnotequals");
    }
}

