/*
 * Decompiled with CFR 0.152.
 */
package apex.common.base;

import apex.common.base.ToUpperCaseProvider;
import com.google.common.annotations.VisibleForTesting;

public class ToUpperCaseFast
implements ToUpperCaseProvider {
    private static final ToUpperCaseFast INSTANCE = new ToUpperCaseFast();
    private static final char[] UPPER_CASE = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};
    private static final int UPPER_CASE_MAP_SIZE = UPPER_CASE.length;
    private final ToUpperCaseProvider systemToUpperCase;

    private ToUpperCaseFast() {
        this(Character::toUpperCase);
    }

    @VisibleForTesting
    ToUpperCaseFast(ToUpperCaseProvider systemToUpperCase) {
        this.systemToUpperCase = systemToUpperCase;
    }

    public static ToUpperCaseFast get() {
        return INSTANCE;
    }

    public boolean canBeFastUpperCased(char character) {
        return character < UPPER_CASE_MAP_SIZE;
    }

    @Override
    public char toUpperCase(char character) {
        return this.canBeFastUpperCased(character) ? UPPER_CASE[character] : this.systemToUpperCase.toUpperCase(character);
    }
}

