/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.index.converter.ConverterFactory;
import apex.jorje.lsp.api.references.ReferenceLocationProvider;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.symbols.CachingSymbolProvider;
import apex.jorje.lsp.api.telemetry.TelemetryHandler;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.api.workspace.DependentCompilationTracker;
import apex.jorje.lsp.api.workspace.WorkspaceChangeListener;
import apex.jorje.lsp.impl.clients.VSCode;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.SfdxProject;
import apex.jorje.lsp.impl.index.converter.TypeInfoConverter;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import apex.jorje.lsp.impl.references.ReferenceInfo;
import apex.jorje.lsp.impl.telemetry.TelemetryData;
import apex.jorje.lsp.impl.typings.Typings;
import apex.jorje.lsp.impl.utils.ParentTableUtil;
import apex.jorje.lsp.impl.utils.ParentTableVisitor;
import apex.jorje.lsp.impl.utils.SfdxProjects;
import apex.jorje.lsp.impl.utils.TypeUsageSiteProcessor;
import apex.jorje.lsp.impl.utils.TypeUsageSiteUtil;
import apex.jorje.lsp.impl.workspace.ServerSetup;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.statement.WhenCases;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.internal.core.nd.IProgressMonitor;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.NullProgressMonitor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.FileEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexIndexer
extends AbstractScheduledService
implements WorkspaceChangeListener,
DocumentLifecycleHandler {
    public static final PathMatcher CLS_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.cls");
    public static final PathMatcher TRG_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.trigger");
    public static final int LATCH_TIMEOUT = 10;
    private static final Logger logger = LoggerFactory.getLogger(ApexIndexer.class);
    public static final String SOURCE_BASED_TYPES_SCHEME = "file:///";
    private final Provider<ServerSetup> serverSetupProvider;
    private final Provider<ApexIndex> apexIndexProvider;
    private final ApexDocumentService documentService;
    private final ApexCompilerService compilerService;
    private final CachingSymbolProvider symbolProvider;
    private final ConverterFactory converterFactory;
    private final SfdxProjects sfdxProjectUtil;
    private Map<String, Set<URI>> apexUris = Maps.newHashMap();
    private Map<String, Set<URI>> customObjectUris = Maps.newHashMap();
    private Map<String, Set<URI>> standardObjectUris = Maps.newHashMap();
    private final Map<String, Integer> currentDocVersion = Maps.newHashMap();
    private final Queue<FileEvent> fileEvents = Queues.newConcurrentLinkedQueue();
    private boolean isInitializing = true;
    private Optional<SfdxProject> sfdxProject;
    private CountDownLatch startupLatch = new CountDownLatch(1);
    private final Typings typings;
    private boolean exceptionThrownInInsertCodeUnit = false;
    private final ReferenceLocationProvider referenceLocationProvider;
    private final DependentCompilationTracker dependentCompilationTracker;
    private final TelemetryHandler telemetryHandler;

    @Inject
    public ApexIndexer(Provider<ServerSetup> serverSetupProvider, Provider<ApexIndex> apexIndexProvider, ApexDocumentService documentService, ApexCompilerService compilerService, CachingSymbolProvider symbolProvider, ConverterFactory converterFactory, SfdxProjects sfdxProjectUtil, Typings typings, ReferenceLocationProvider referenceLocationProvider, DependentCompilationTracker dependentCompilationTracker, TelemetryHandler telemetryHandler) {
        this.serverSetupProvider = serverSetupProvider;
        this.apexIndexProvider = apexIndexProvider;
        this.documentService = documentService;
        this.compilerService = compilerService;
        this.symbolProvider = symbolProvider;
        this.converterFactory = converterFactory;
        this.sfdxProjectUtil = sfdxProjectUtil;
        this.typings = typings;
        this.referenceLocationProvider = referenceLocationProvider;
        this.dependentCompilationTracker = dependentCompilationTracker;
        this.telemetryHandler = telemetryHandler;
        this.sfdxProject = Optional.empty();
    }

    private synchronized void reinitialize() {
        this.startUp();
    }

    @VisibleForTesting
    public synchronized void clearOldCache() {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        Nd nd = apexIndex.getNd();
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            apexIndex.fuzzyFindResourceFiles(SOURCE_BASED_TYPES_SCHEME).forEach(NdNode::delete);
        }
        finally {
            nd.releaseWriteLock();
            this.symbolProvider.invalidateAll();
        }
        this.typings.removeTypeDefinitionFiles();
    }

    private void buildCacheInternal(Map<String, Set<URI>> classesToProcess, boolean isFileBased) {
        ArrayList<SourceFile> sourceFiles = Lists.newArrayList();
        try {
            for (Map.Entry<String, Set<URI>> entry : classesToProcess.entrySet()) {
                for (URI uri : entry.getValue()) {
                    SourceFile sourceFile = SourceFile.builder().setBody(new String(Files.readAllBytes(Paths.get(uri)))).setNamespace(Namespaces.create(entry.getKey())).setKnownName(uri.toString()).setFileBased(isFileBased).setTrusted(isFileBased).build();
                    sourceFiles.add(sourceFile);
                    if (!isFileBased) continue;
                    this.documentService.addFauxClass(uri);
                }
            }
        }
        catch (IOException ioe) {
            logger.error("Unable to analyze user-defined types from filesystem", (Throwable)ioe);
        }
        List<CodeUnit> codeUnits = this.compilerService.compile(sourceFiles);
        for (CodeUnit codeUnit : codeUnits) {
            this.insertCodeUnit(codeUnit);
        }
    }

    private synchronized void buildCache() {
        this.buildCacheInternal(this.standardObjectUris, true);
        this.buildCacheInternal(this.customObjectUris, true);
        this.buildCacheInternal(this.apexUris, false);
        this.typings.generateTypeDefinitions(this.apexUris);
        this.typings.generateTypeDefinitions(this.customObjectUris);
        this.typings.generateTypeDefinitions(this.standardObjectUris);
    }

    synchronized long getUriCount(Map<String, Set<URI>> uriMap) {
        return uriMap.values().stream().flatMap(Collection::stream).count();
    }

    @VisibleForTesting
    public synchronized void insertCodeUnit(final CodeUnit codeUnit) {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        final Nd nd = apexIndex.getNd();
        TypeInfo type = codeUnit.getType();
        ApexResourceFile resourceFile = this.insertTypeInfo(codeUnit, nd, type);
        final ArrayList<ReferenceInfo> referenceInfos = new ArrayList<ReferenceInfo>();
        try {
            codeUnit.getNode().traverse(new AstVisitor<NoopScope>(){

                @Override
                protected boolean defaultVisit() {
                    return true;
                }

                @Override
                public boolean visit(UserClass node, NoopScope scope) {
                    return true;
                }

                @Override
                public void visitEnd(UserClass node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                        ApexIndexer.this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                    }
                    ParentTableUtil.walkUserClassParentTable(node, new AddReferenceParentTableVisitor(referenceInfos));
                }

                @Override
                public boolean visit(UserEnum node, NoopScope scope) {
                    return true;
                }

                @Override
                public void visitEnd(UserEnum node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                        ApexIndexer.this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                    }
                    if (node.getDefiningType() != null) {
                        referenceInfos.add(new ReferenceInfo(node.getDefiningType(), node.getLoc()));
                    }
                    for (FieldInfo enumField : node.getDefiningType().fields().all()) {
                        referenceInfos.add(new ReferenceInfo(enumField, enumField.getLoc()));
                    }
                }

                @Override
                public void visitEnd(UserTrigger node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                        ApexIndexer.this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                    }
                    if (node.getDefiningType() != null) {
                        referenceInfos.add(new ReferenceInfo(node.getDefiningType(), node.getLoc()));
                    }
                    if (node.getTargetType() != null) {
                        List<Identifier> names = node.getTargetName();
                        referenceInfos.add(new ReferenceInfo(node.getTargetType(), Iterables.getLast(names).getLoc()));
                    }
                }

                @Override
                public boolean visit(UserInterface node, NoopScope scope) {
                    return true;
                }

                @Override
                public void visitEnd(UserInterface node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                        ApexIndexer.this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                    }
                    ParentTableUtil.walkInterfaceParentTable(node, new AddReferenceParentTableVisitor(referenceInfos));
                }

                @Override
                public void visitEnd(VariableExpression node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    Variable variable = node.getVariable();
                    if (variable != null && (variable.getMemberType() == Member.Type.FIELD || variable.getMemberType() == Member.Type.PROPERTY)) {
                        referenceInfos.add(new ReferenceInfo(node.getVariable(), node.getLoc()));
                    }
                }

                @Override
                public void visitEnd(Property property, NoopScope scope) {
                    super.visitEnd(property, scope);
                    if (property.getFieldInfo() != null) {
                        referenceInfos.add(new ReferenceInfo(property.getFieldInfo(), property.getLoc()));
                    }
                }

                @Override
                public void visitEnd(FieldDeclaration field, NoopScope scope) {
                    super.visitEnd(field, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(field.getTypeNameUsed(), field.getTypeInfoUsed(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(VariableDeclaration variable, NoopScope scope) {
                    super.visitEnd(variable, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(variable.getTypeNameUsed(), variable.getTypeInfoUsed(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(ReferenceExpression node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    List<Identifier> names = node.getNames();
                    List<Variable> variables = node.getVariables();
                    List<Identifier> nonVariableNames = names.subList(0, names.size() - variables.size());
                    List<Identifier> variableNames = names.subList(nonVariableNames.size(), names.size());
                    if (!nonVariableNames.isEmpty()) {
                        TypeUsageSiteUtil.processTypeUsageSite(nonVariableNames, node.getType(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                    }
                    block0: for (Identifier name : variableNames) {
                        for (Variable variable : variables) {
                            if (!name.getValue().equalsIgnoreCase(variable.getName())) continue;
                            referenceInfos.add(new ReferenceInfo(variable, name.getLoc()));
                            continue block0;
                        }
                    }
                }

                @Override
                public void visitEnd(Method method, NoopScope scope) {
                    super.visitEnd(method, scope);
                    if (!method.getMethodInfo().getGenerated().isUserDefined()) {
                        return;
                    }
                    if (method.getMethodInfo() != null) {
                        referenceInfos.add(new ReferenceInfo(method.getMethodInfo(), method.getLoc()));
                    }
                    MethodInfo methodInfo = method.getMethodInfo();
                    for (Parameter param : methodInfo.getParameters()) {
                        TypeUsageSiteUtil.processTypeUsageSite(param.getTypeRef(), param.getType(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                    }
                    TypeRef returnTypeRef = method.getReturnTypeRef();
                    if (!returnTypeRef.getNames().isEmpty()) {
                        TypeUsageSiteUtil.processTypeUsageSite(returnTypeRef, methodInfo.getReturnType(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                    }
                }

                @Override
                public void visitEnd(MethodCallExpression method, NoopScope scope) {
                    super.visitEnd(method, scope);
                    if (method.getMethod().isPresent()) {
                        Optional<MethodInfo> methodInfo = method.getMethod();
                        referenceInfos.add(new ReferenceInfo(methodInfo.get(), method.getLoc()));
                    }
                }

                @Override
                public void visitEnd(NewObjectExpression method, NoopScope scope) {
                    super.visitEnd(method, scope);
                    if (method.getConstructor().isPresent()) {
                        List<Identifier> newObjectNames = method.getTypeRef().getNames();
                        Optional<MethodInfo> constructorInfo = method.getConstructor();
                        referenceInfos.add(new ReferenceInfo(constructorInfo.get(), Iterables.getLast(newObjectNames).getLoc()));
                    }
                }

                @Override
                public void visitEnd(SuperMethodCallExpression method, NoopScope scope) {
                    super.visitEnd(method, scope);
                    if (method.getMethod().isPresent()) {
                        Optional<MethodInfo> methodInfo = method.getMethod();
                        referenceInfos.add(new ReferenceInfo(methodInfo.get(), method.getLoc()));
                    }
                }

                @Override
                public void visitEnd(ThisMethodCallExpression method, NoopScope scope) {
                    super.visitEnd(method, scope);
                    if (method.getMethod().isPresent()) {
                        Optional<MethodInfo> methodInfo = method.getMethod();
                        referenceInfos.add(new ReferenceInfo(methodInfo.get(), method.getLoc()));
                    }
                }

                @Override
                public void visitEnd(CatchBlockStatement catchStatement, NoopScope scope) {
                    super.visitEnd(catchStatement, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(catchStatement.getTypeRef(), catchStatement.getVariable().getType(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(CastExpression castExpression, NoopScope scope) {
                    super.visitEnd(castExpression, scope);
                    if (castExpression.getCastType() != null) {
                        TypeUsageSiteUtil.processTypeUsageSite(castExpression.getTypeRef(), castExpression.getCastType(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                    }
                }

                @Override
                public void visitEnd(NewListInitExpression listInit, NoopScope scope) {
                    super.visitEnd(listInit, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(listInit.getTypeRef(), listInit.getTypeInfo(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(NewSetInitExpression setInit, NoopScope scope) {
                    super.visitEnd(setInit, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(setInit.getTypeRef(), setInit.getTypeInfo(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(NewMapInitExpression mapInit, NoopScope scope) {
                    super.visitEnd(mapInit, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(mapInit.getTypeRef(), mapInit.getTypeInfo(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(NewListLiteralExpression listInit, NoopScope scope) {
                    super.visitEnd(listInit, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(listInit.getTypeRef(), listInit.getTypeInfo(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(NewSetLiteralExpression setInit, NoopScope scope) {
                    super.visitEnd(setInit, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(setInit.getTypeRef(), setInit.getTypeInfo(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(NewMapLiteralExpression mapInit, NoopScope scope) {
                    super.visitEnd(mapInit, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(mapInit.getTypeRef(), mapInit.getTypeInfo(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(InstanceOfExpression instanceExpression, NoopScope scope) {
                    super.visitEnd(instanceExpression, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(instanceExpression.getTypeRef(), instanceExpression.getInstanceOfType(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(TypeWhenBlock node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    TypeUsageSiteUtil.processTypeUsageSite(node.getTypeRef(), node.getType(), (TypeUsageSiteProcessor)new AddReferenceTypeUsage(referenceInfos));
                }

                @Override
                public void visitEnd(WhenCases.IdentifierCase node, NoopScope scope) {
                    super.visitEnd(node, scope);
                    if (node.getFieldInfo() != null) {
                        referenceInfos.add(new ReferenceInfo(node.getFieldInfo(), node.getLoc()));
                    }
                }
            }, NoopScope.get());
        }
        catch (Exception exc) {
            logger.error("exception thrown in traversing codeunit for references", (Throwable)exc);
            this.exceptionThrownInInsertCodeUnit = true;
        }
        this.referenceLocationProvider.createNdReferences(resourceFile, referenceInfos, nd);
    }

    private boolean isSObject(CodeUnit codeUnit) {
        String unitPathString = codeUnit.getSourceFile().getKnownName();
        return this.sfdxProjectUtil.isSObject(unitPathString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApexResourceFile insertTypeInfo(CodeUnit codeUnit, Nd nd, TypeInfo type) {
        ApexResourceFile retResourceFile;
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            ApexResourceFile resourceFile = new ApexResourceFile(nd);
            resourceFile.setFilename(codeUnit.getSourceFile().getKnownName());
            resourceFile.setTimeLastScanned(System.currentTimeMillis());
            resourceFile.setError(!codeUnit.getErrors().isEmpty());
            resourceFile.setFileBased(codeUnit.getSourceFile().isFileBased());
            TypeInfoConverter converter = this.converterFactory.createTypeInfoConverter(resourceFile);
            converter.addType(type, this.isSObject(codeUnit));
            retResourceFile = resourceFile;
        }
        finally {
            nd.releaseWriteLock();
        }
        return retResourceFile;
    }

    private synchronized Optional<SfdxProject> constructSfdxProject() {
        this.apexUris.clear();
        Optional<SfdxProject> sfdxProject = this.sfdxProjectUtil.constructSfdxProject();
        sfdxProject.ifPresent(project -> {
            this.apexUris = this.sfdxProjectUtil.getSfdxFiles((SfdxProject)project);
        });
        return sfdxProject;
    }

    private void addApexUri(String namespace, URI docUri) {
        Set<URI> uris = this.apexUris.get(namespace);
        if (uris != null) {
            uris.add(docUri);
        } else {
            this.apexUris.put(namespace, Sets.newHashSet(docUri));
        }
    }

    private synchronized boolean isSObjectFauxClass(Path file) {
        return file.startsWith(this.sfdxProjectUtil.getStandardObjectsDir()) || file.startsWith(this.sfdxProjectUtil.getCustomObjectsDir());
    }

    private synchronized boolean isUnderPackageDirectory(Path file) {
        return this.sfdxProject.isPresent() && this.sfdxProject.get().isUnderPackageDirectory(file);
    }

    private synchronized boolean isValidClass(Path file) {
        return this.isUnderPackageDirectory(file) || this.isSObjectFauxClass(file);
    }

    @Override
    public synchronized void didChangeConfiguration(DidChangeConfigurationParams didChangeConfigurationParams) {
    }

    @Override
    public synchronized void didChangeWatchedFiles(DidChangeWatchedFilesParams didChangeWatchedFilesParams) {
        this.fileEvents.addAll(VSCode.standardizeFileEvents(didChangeWatchedFilesParams.getChanges()));
        logger.debug("didChangeWatchedFiles " + this.fileEvents.size());
    }

    @VisibleForTesting
    synchronized void runOne() {
        boolean priorIsInitializing = this.isInitializing;
        try {
            this.isInitializing = false;
            this.runOneIteration();
        }
        finally {
            this.isInitializing = priorIsInitializing;
        }
    }

    @Override
    protected synchronized void runOneIteration() {
        boolean processingChangesToSObjects = false;
        if (this.isInitializing) {
            return;
        }
        Path sfdxProjectFilePath = Paths.get(((ServerSetup)this.serverSetupProvider.get()).getRootPath(), "sfdx-project.json");
        while (!this.fileEvents.isEmpty()) {
            FileEvent change = this.fileEvents.remove();
            String uri = change.getUri();
            Path path = Paths.get(URI.create(uri));
            if (this.isSObjectFauxClass(path)) {
                if (processingChangesToSObjects) continue;
                processingChangesToSObjects = true;
                logger.info("Processing changes to SObjects " + change.getType());
                continue;
            }
            if (CLS_MATCHER.matches(path)) {
                switch (change.getType()) {
                    case Created: {
                        if (!this.isValidClass(path)) break;
                        URI docUri = URI.create(uri);
                        String namespace = this.documentService.retrieveNamespace(docUri);
                        this.addApexUri(namespace, docUri);
                        this.insertTypeInfo(uri);
                        break;
                    }
                    case Changed: {
                        if (!this.isValidClass(path)) break;
                        this.updateTypeInfo(uri);
                        break;
                    }
                    case Deleted: {
                        if (!this.isValidClass(path)) break;
                        URI docUri = URI.create(uri);
                        String namespace = this.documentService.retrieveNamespace(docUri);
                        Set<URI> uris = this.apexUris.get(namespace);
                        if (uris != null) {
                            uris.remove(docUri);
                        }
                        this.deleteTypeInfo(uri);
                    }
                }
                continue;
            }
            if (!Objects.equals(path, sfdxProjectFilePath)) continue;
            this.reinitialize();
        }
        if (processingChangesToSObjects) {
            this.reinitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startUp() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        TelemetryData telemetryData = new TelemetryData("ApexIndexer-Startup");
        logger.info("ApexIndexer: Scanning user-defined types.");
        this.isInitializing = true;
        if (this.startupLatch.getCount() == 0L) {
            this.startupLatch = new CountDownLatch(1);
        }
        try {
            this.standardObjectUris = this.sfdxProjectUtil.getSObjects(this.sfdxProjectUtil.getStandardObjectsDir());
            this.customObjectUris = this.sfdxProjectUtil.getSObjects(this.sfdxProjectUtil.getCustomObjectsDir());
            this.sfdxProject = this.constructSfdxProject();
            this.sfdxProject.ifPresent(workspace -> {
                this.clearOldCache();
                this.buildCache();
            });
        }
        catch (Exception e) {
            telemetryData.add(e);
        }
        finally {
            this.isInitializing = false;
            this.startupLatch.countDown();
            if (((ServerSetup)this.serverSetupProvider.get()).getLanguageClient() != null) {
                ((ServerSetup)this.serverSetupProvider.get()).getLanguageClient().doneIndexing();
            }
        }
        stopwatch.stop();
        telemetryData.add("StandardObjects", this.getUriCount(this.standardObjectUris));
        telemetryData.add("CustomObjects", this.getUriCount(this.customObjectUris));
        telemetryData.add("ApexFiles", this.getUriCount(this.apexUris));
        telemetryData.add("ErrorFiles", this.getFilesWithErrorsFromDB().stream().filter(filename -> this.isUnderPackageDirectory(Paths.get(URI.create(filename)))).count());
        telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.telemetryHandler.send(telemetryData);
        logger.info("ApexIndexer: Scanning user-defined types took {} ms.", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    public CountDownLatch getStartupLatch() {
        return this.startupLatch;
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedRateSchedule(10L, 5L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    public synchronized void insertTypeInfo(String uri) {
        this.insertTypeInfoReturnCodeUnit(uri);
    }

    @VisibleForTesting
    synchronized CodeUnit insertTypeInfoReturnCodeUnit(String uri) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(uri));
        CodeUnit[] resultCodeUnit = new CodeUnit[]{null};
        optDoc.ifPresent(doc -> {
            CodeUnit codeUnit = this.compilerService.compile((Document)doc);
            this.insertCodeUnit(codeUnit);
            resultCodeUnit[0] = codeUnit;
        });
        return resultCodeUnit[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public synchronized void deleteTypeInfo(String uri) {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        Nd nd = apexIndex.getNd();
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            apexIndex.fuzzyFindResourceFiles(uri).forEach(apexResourceFile -> {
                apexResourceFile.getTypes().forEach(type -> this.symbolProvider.invalidate(type.getTypeId().getApexName().getString().toLowerCase()));
                apexResourceFile.delete();
            });
        }
        finally {
            nd.releaseWriteLock();
        }
    }

    @VisibleForTesting
    synchronized void updateTypeInfo(String uri) {
        this.deleteTypeInfo(uri);
        this.insertTypeInfo(uri);
    }

    @Override
    public synchronized void handleDidOpen(DidOpenTextDocumentParams params) {
    }

    @Override
    public synchronized void handleDidChange(DidChangeTextDocumentParams params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String docUri = params.getTextDocument().getUri();
        TelemetryData telemetryData = new TelemetryData("ApexIndexer-handleDidChange");
        Integer documentVersion = params.getTextDocument().getVersion();
        try {
            if (documentVersion != null) {
                int latestVersion = this.currentDocVersion.getOrDefault(params.getTextDocument().getUri(), 0);
                if (documentVersion < latestVersion) {
                    return;
                }
                this.currentDocVersion.put(params.getTextDocument().getUri(), documentVersion);
            }
            if (this.isValidClass(Paths.get(URI.create(docUri)))) {
                this.updateTypeInfo(docUri);
                List<String> dependentCompilations = this.dependentCompilationTracker.removeForIndexing(docUri);
                dependentCompilations.forEach(this::updateTypeInfo);
                telemetryData.add("DependentCompilations", dependentCompilations.size());
            }
        }
        catch (Exception e) {
            telemetryData.add(e);
        }
        stopwatch.stop();
        telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.telemetryHandler.send(telemetryData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFilesWithErrorsFromDB() {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        Nd nd = apexIndex.getNd();
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            List<String> list = apexIndex.getFilesWithErrors();
            return list;
        }
        finally {
            nd.releaseWriteLock();
        }
    }

    @Override
    public synchronized void handleDidClose(DidCloseTextDocumentParams params) {
    }

    @Override
    public synchronized void handleDidSave(DidSaveTextDocumentParams params) {
    }

    @VisibleForTesting
    public boolean hasExceptionInProcessingCodeUnits() {
        return this.exceptionThrownInInsertCodeUnit;
    }

    private class AddReferenceTypeUsage
    implements TypeUsageSiteProcessor {
        private final List<ReferenceInfo> referenceInfos;

        AddReferenceTypeUsage(List<ReferenceInfo> referenceInfos) {
            this.referenceInfos = referenceInfos;
        }

        @Override
        public void processSite(String refName, TypeInfo apexType, Location location) {
            this.referenceInfos.add(new ReferenceInfo(apexType, location));
        }
    }

    private class AddReferenceParentTableVisitor
    implements ParentTableVisitor {
        private final List<ReferenceInfo> referenceInfos;

        AddReferenceParentTableVisitor(List<ReferenceInfo> referenceInfos) {
            this.referenceInfos = referenceInfos;
        }

        @Override
        public boolean visit(Compilation node) {
            if (node.getDefiningType() != null) {
                this.referenceInfos.add(new ReferenceInfo(node.getDefiningType(), node.getLoc()));
            }
            return true;
        }

        @Override
        public boolean visit(TypeRef typeRef, TypeInfo typeInfo) {
            TypeUsageSiteUtil.processTypeUsageSite(typeRef, typeInfo, (TypeUsageSiteProcessor)new AddReferenceTypeUsage(this.referenceInfos));
            return true;
        }
    }
}

