/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.ast.LiteralType;
import apex.jorje.data.ast.PrefixOp;
import apex.jorje.parser.impl.ApexLexer;
import apex.jorje.parser.impl.ApexParser;
import apex.jorje.parser.impl.CaseInsensitiveReaderStream;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class ExtractUtil {
    public static Boolean canExtract(Expression node) {
        return BooleanScope.evaluate(node, new AstVisitor<BooleanScope>(){

            @Override
            protected boolean defaultVisit() {
                return false;
            }

            @Override
            public void visitEnd(ArrayStoreExpression node, BooleanScope scope) {
                scope.setValue(false);
            }

            @Override
            public void visitEnd(LiteralExpression node, BooleanScope scope) {
                scope.setValue(node.getLiteralType() != LiteralType.NULL);
            }

            @Override
            public void visitEnd(PrefixExpression node, BooleanScope scope) {
                scope.setValue(node.getOp() != PrefixOp.INC && node.getOp() != PrefixOp.DEC);
            }

            @Override
            public void visitEnd(VariableExpression node, BooleanScope scope) {
                scope.setValue(BooleanScope.evaluate(node.getDefiningNode(), new AstVisitor<BooleanScope>(){

                    @Override
                    public void visitEnd(ArrayLoadExpression expression, BooleanScope scope) {
                        scope.setValue(false);
                    }

                    @Override
                    public void visitEnd(ArrayStoreExpression expression, BooleanScope scope) {
                        scope.setValue(false);
                    }

                    @Override
                    public void visitEnd(PrefixExpression expression, BooleanScope scope) {
                        scope.setValue(false);
                    }

                    @Override
                    public void visitEnd(PostfixExpression expression, BooleanScope scope) {
                        scope.setValue(false);
                    }

                    @Override
                    public void visitEnd(VariableDeclaration expression, BooleanScope scope) {
                        scope.setValue(false);
                    }
                }, true));
            }
        }, true) && ExtractUtil.isValid(node.getType()) != false;
    }

    public static Boolean canExtractConstant(Expression node) {
        return BooleanScope.evaluate(node, new AstVisitor<BooleanScope>(){

            @Override
            protected boolean defaultVisit() {
                return false;
            }

            @Override
            public void visitEnd(LiteralExpression node, BooleanScope scope) {
                scope.setValue(true);
            }

            @Override
            public void visitEnd(PrefixExpression node, BooleanScope scope) {
                scope.setValue(ExpressionUtil.isLiteralExpression(node.getExpression()));
            }
        }, false);
    }

    private static Boolean isValid(TypeInfo type) {
        return type != null && type.isResolved() && !TypeInfoEquivalence.isEquivalent(type, TypeInfos.VOID);
    }

    public static int getLineNumber(AstNode node) {
        if (node instanceof Expression) {
            return ExtractUtil.getLineNumber(((Expression)node).getDefiningNode());
        }
        return node.getLoc().getLine();
    }

    public static ApexParser parse(String source) {
        CaseInsensitiveReaderStream stream = CaseInsensitiveReaderStream.create(source);
        ApexLexer lexer = new ApexLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        return new ApexParser((TokenStream)tokenStream);
    }
}

