/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.MoreSets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class TriggerUsageCalculator {
    private static final TriggerUsageCalculator INSTANCE = new TriggerUsageCalculator();

    private TriggerUsageCalculator() {
    }

    public static TriggerUsageCalculator get() {
        return INSTANCE;
    }

    public Set<TriggerUsage> resolve(Errors errors, UserTrigger trigger, List<TriggerUsage> parsedUsages) {
        HashSet<TriggerUsage> usages = new HashSet<TriggerUsage>(parsedUsages.size());
        for (TriggerUsage usage : AstNodes.filterNotNull(parsedUsages)) {
            if (usage == TriggerUsage.BEFORE_UNDELETE) {
                errors.markInvalid((AstNode)trigger, I18nSupport.getLabel("invalid.trigger.before.undelete"));
            }
            if (usages.contains((Object)usage)) {
                errors.markInvalid((AstNode)trigger, I18nSupport.getLabel("invalid.duplicate.trigger.usage", new Object[]{usage}));
                continue;
            }
            usages.add(usage);
        }
        return MoreSets.toImmutableSet(usages);
    }
}

