/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

public enum BooleanOp {
    DOUBLE_EQUAL("=="),
    TRIPLE_EQUAL("==="),
    NOT_TRIPLE_EQUAL("!=="),
    NOT_EQUAL("!="),
    ALT_NOT_EQUAL("<>"),
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LESS_THAN_EQUAL("<="),
    GREATER_THAN_EQUAL(">="),
    AND("&&"),
    OR("||");

    private final String code;

    private BooleanOp(String code) {
        this.code = code;
    }

    public static boolean isComparison(BooleanOp booleanOp) {
        return booleanOp != null && booleanOp.isComparison();
    }

    public boolean isComparison() {
        return this != AND && this != OR;
    }

    public boolean isEquality() {
        return this == DOUBLE_EQUAL || this == NOT_EQUAL || this == ALT_NOT_EQUAL;
    }

    public boolean isEqual() {
        return this == DOUBLE_EQUAL || this == TRIPLE_EQUAL;
    }

    public boolean isNotEqual() {
        return this == NOT_EQUAL || this == ALT_NOT_EQUAL || this == NOT_TRIPLE_EQUAL;
    }

    public BooleanOp negate() {
        switch (this) {
            case DOUBLE_EQUAL: {
                return NOT_EQUAL;
            }
            case TRIPLE_EQUAL: {
                return NOT_TRIPLE_EQUAL;
            }
            case NOT_TRIPLE_EQUAL: {
                return TRIPLE_EQUAL;
            }
            case NOT_EQUAL: {
                return DOUBLE_EQUAL;
            }
            case ALT_NOT_EQUAL: {
                return DOUBLE_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN_EQUAL;
            }
            case GREATER_THAN: {
                return LESS_THAN_EQUAL;
            }
            case LESS_THAN_EQUAL: {
                return GREATER_THAN;
            }
            case GREATER_THAN_EQUAL: {
                return LESS_THAN;
            }
        }
        throw new UnsupportedOperationException("negate does not exist for op: " + (Object)((Object)this));
    }

    public String toString() {
        return this.code;
    }
}

