/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.search;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.search.MemberDefinitionLocator;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.SignatureEquivalence;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Optional;
import org.eclipse.lsp4j.Location;

@Singleton
public class StandardMemberDefinitionLocator
implements MemberDefinitionLocator {
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;

    @Inject
    public StandardMemberDefinitionLocator(ApexCompilerService compilerService, ApexDocumentService documentService) {
        this.compilerService = compilerService;
        this.documentService = documentService;
    }

    @Override
    public Optional<Location> locate(Member member, URI uri) {
        Optional<Document> optDoc = this.documentService.retrieve(uri);
        return optDoc.flatMap(doc -> {
            AstVisitor visitor;
            switch (member.getMemberType()) {
                case FIELD: {
                    visitor = new FieldDefinitionLocator((FieldInfo)member, uri);
                    break;
                }
                case METHOD: {
                    visitor = new MethodDefinitionLocator((MethodInfo)member, uri);
                    break;
                }
                default: {
                    visitor = new NullDefinitionLocator();
                }
            }
            this.compilerService.compile((Document)doc, visitor);
            return ((Locator)((Object)visitor)).getLocations();
        });
    }

    @Override
    public Optional<Location> locate(TypeInfo info, URI uri) {
        Optional<Document> optDoc = this.documentService.retrieve(uri);
        if (optDoc.isPresent()) {
            Document doc = optDoc.get();
            CompliationUnitLocator visitor = new CompliationUnitLocator(info, uri);
            this.compilerService.compile(doc, visitor);
            return ((Locator)visitor).getLocations();
        }
        return Optional.empty();
    }

    static class NullDefinitionLocator
    extends AstVisitor<AdditionalPassScope>
    implements Locator {
        NullDefinitionLocator() {
        }

        @Override
        public Optional<Location> getLocations() {
            return Optional.empty();
        }
    }

    static class MethodDefinitionLocator
    extends AstVisitor<AdditionalPassScope>
    implements Locator {
        private final MethodInfo member;
        private final URI uri;
        private Optional<Location> location = Optional.empty();

        MethodDefinitionLocator(MethodInfo member, URI uri) {
            this.member = member;
            this.uri = uri;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(Method node, AdditionalPassScope scope) {
            super.visit(node, scope);
            MethodInfo methodInfo = node.getMethodInfo();
            if (methodInfo != null && SignatureEquivalence.isEquivalent(methodInfo.getSignature(), this.member.getSignature()) && methodInfo.getDefiningType().getBytecodeName().equalsIgnoreCase(this.member.getDefiningType().getBytecodeName())) {
                this.location = Optional.of(Locations.from(this.uri, node.getLoc()));
            }
        }

        @Override
        public Optional<Location> getLocations() {
            return this.location;
        }
    }

    static class FieldDefinitionLocator
    extends AstVisitor<AdditionalPassScope>
    implements Locator {
        private final FieldInfo member;
        private final URI uri;
        private Optional<Location> location = Optional.empty();

        FieldDefinitionLocator(FieldInfo member, URI uri) {
            this.member = member;
            this.uri = uri;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public Optional<Location> getLocations() {
            return this.location;
        }

        @Override
        public void visitEnd(Field node, AdditionalPassScope scope) {
            super.visit(node, scope);
            FieldInfo fieldInfo = node.getFieldInfo();
            if (fieldInfo != null && fieldInfo.getBytecodeName().equalsIgnoreCase(this.member.getBytecodeName()) && fieldInfo.getDefiningType().getBytecodeName().equalsIgnoreCase(this.member.getDefiningType().getBytecodeName())) {
                this.location = Optional.of(Locations.from(this.uri, node.getLoc()));
            }
        }
    }

    static class CompliationUnitLocator
    extends AstVisitor<AdditionalPassScope>
    implements Locator {
        private final TypeInfo info;
        private final URI uri;
        private Optional<Location> location = Optional.empty();

        CompliationUnitLocator(TypeInfo info, URI uri) {
            this.info = info;
            this.uri = uri;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public Optional<Location> getLocations() {
            return this.location;
        }

        @Override
        public void visitEnd(UserClass node, AdditionalPassScope scope) {
            super.visit(node, scope);
            TypeInfo parentInfo = node.getDefiningType();
            if (parentInfo != null && parentInfo.getApexName().equals(this.info.getApexName())) {
                this.location = Optional.of(Locations.from(this.uri, node.getLoc()));
            }
        }

        @Override
        public void visitEnd(UserInterface node, AdditionalPassScope scope) {
            super.visit(node, scope);
            TypeInfo parentInfo = node.getDefiningType();
            if (parentInfo != null && parentInfo.getApexName().equals(this.info.getApexName())) {
                this.location = Optional.of(Locations.from(this.uri, node.getLoc()));
            }
        }

        @Override
        public void visitEnd(UserEnum node, AdditionalPassScope scope) {
            super.visit(node, scope);
            TypeInfo parentInfo = node.getDefiningType();
            if (parentInfo != null && parentInfo.getApexName().equals(this.info.getApexName())) {
                this.location = Optional.of(Locations.from(this.uri, node.getLoc()));
            }
        }
    }

    static interface Locator {
        public Optional<Location> getLocations();
    }
}

