/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.LazyLabel;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.ShortCircuitable;
import apex.jorje.semantic.ast.expression.VariableErrorMessageOverride;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableEmitLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableEmitStoreVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableValidateLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableValidateStoreVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreLists;

public class VariableExpression
extends Expression
implements ShortCircuitable {
    private final ReferenceContext reference;
    private final Identifier name;
    private final Type type;
    private final boolean initialStore;
    private VariableVisitor.Context context;
    private Variable variable;
    private final LazyLabel shortCircuitLabel;

    private VariableExpression(AstNode definingNode, Expr.VariableExpr expr, Type type, boolean initialStore) {
        super(definingNode);
        this.type = type;
        this.initialStore = initialStore;
        this.name = Iterables.getLast(expr.names);
        this.reference = ReferenceExpression.create(this, type.getReferenceType(), expr.dottedExpr, expr.isSafeNav, MoreLists.removeLast(expr.names), this.name);
        this.shortCircuitLabel = new LazyLabel();
    }

    public static VariableExpression createStore(AstNode definingNode, Expr.VariableExpr expr) {
        return new VariableExpression(definingNode, expr, Store.INSTANCE, ExpressionUtil.isInitialStore(definingNode));
    }

    public static VariableExpression createLoad(AstNode definingNode, Expr.VariableExpr expr) {
        return new VariableExpression(definingNode, expr, Load.INSTANCE, false);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.reference.getExpression().traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.reference.getExpression().validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.reference.getExpression())) {
            scope.getErrors().markInvalid(this);
            return;
        }
        Variable variable = this.variable = this.reference.getSpecialStatic() != null ? this.reference.getSpecialStatic() : symbols.lookupVariableInfo(this.getDefiningType(), this.type.getReferenceType(), this.reference.getContext(), this.reference.getType(this), this.name);
        if (this.variable == null) {
            scope.getErrors().markInvalid((AstNode)this, VariableErrorMessageOverride.get(symbols, this.getDefiningType(), this.reference.getType(this), this.name.getValue()));
            return;
        }
        if (this.variable.getType().isResolved()) {
            scope.getErrors().addIfError((AstNode)this, this.getLoc(), VisibleApiVersionUtil.checkApiVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.variable.getName(), this.variable.getModifiers(), this.variable.getMemberType()));
        }
        this.setType(this.variable.getType());
        this.context = new VariableVisitor.Context(this.name.getLoc());
        this.context.previous = this.reference.getContext();
        this.context.firstSObjectTypeInfo = this.reference.getFirstSObjectTypeInfo();
        this.context.isLast = true;
        this.context.shouldPeelSObject = this.reference.shouldPeelSObject();
        this.type.additionalContextSetup(this, this.context);
        VariableVisitor<?, VariableVisitor.Context> visitor = this.type.createValidateVisitor(symbols, scope, this);
        this.variable.accept(visitor, this.context);
        if (this.type.getReferenceType() == ReferenceType.STORE && (ExpressionUtil.isSoqlOrSosl(this.reference.getDottedExpression()) || !ExpressionUtil.isAssignableExpression(this.reference.getDottedExpression()))) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.expression.assignment"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        boolean shouldPopVisitor = false;
        try {
            if (!this.reference.getVariables().isEmpty() || this.type.getReferenceType() == ReferenceType.LOAD) {
                emitter.getVariableVisitors().push(new VariableEmitLoadVisitor(this, emitter));
                shouldPopVisitor = true;
            }
            this.reference.getExpression().emit(emitter);
            VariableVisitor<?, VariableVisitor.Context> visitor = this.type.createEmitVisitor(emitter, this);
            this.variable.accept(visitor, this.context);
            this.shortCircuitLabel.emit(emitter);
        }
        finally {
            if (shouldPopVisitor) {
                emitter.getVariableVisitors().pop();
            }
        }
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    public Variable getVariable() {
        return this.variable;
    }

    public VariableVisitor.Context getContext() {
        return this.context;
    }

    public ReferenceContext getReferenceContext() {
        return this.reference;
    }

    public Identifier getIdentifier() {
        return this.name;
    }

    public ReferenceType getReferenceType() {
        return this.type.getReferenceType();
    }

    @Override
    public LazyLabel getShortCircuitLabel() {
        return this.shortCircuitLabel;
    }

    private static class Store
    implements Type {
        private static final Store INSTANCE = new Store();

        private Store() {
        }

        public VariableVisitor<Boolean, VariableVisitor.Context> createValidateVisitor(SymbolResolver symbols, ValidationScope scope, VariableExpression node) {
            return VariableValidateStoreVisitor.create(symbols, scope, node);
        }

        @Override
        public VariableVisitor<?, VariableVisitor.Context> createEmitVisitor(Emitter emitter, VariableExpression expression) {
            return new VariableEmitStoreVisitor(expression, emitter);
        }

        @Override
        public void additionalContextSetup(VariableExpression expression, VariableVisitor.Context context) {
            context.isInitialStore = expression.initialStore;
            context.referenceType = this.getReferenceType();
        }

        @Override
        public ReferenceType getReferenceType() {
            return ReferenceType.STORE;
        }
    }

    private static class Load
    implements Type {
        private static final Load INSTANCE = new Load();

        private Load() {
        }

        public VariableVisitor<Boolean, VariableVisitor.Context> createValidateVisitor(SymbolResolver symbols, ValidationScope scope, VariableExpression node) {
            return VariableValidateLoadVisitor.create(symbols, scope, node);
        }

        @Override
        public VariableVisitor<?, VariableVisitor.Context> createEmitVisitor(Emitter emitter, VariableExpression expression) {
            return emitter.getVariableVisitors().peek();
        }

        @Override
        public void additionalContextSetup(VariableExpression expression, VariableVisitor.Context context) {
            context.emitLast = true;
            context.referenceType = this.getReferenceType();
        }

        @Override
        public ReferenceType getReferenceType() {
            return ReferenceType.LOAD;
        }
    }

    private static interface Type {
        public VariableVisitor<?, VariableVisitor.Context> createValidateVisitor(SymbolResolver var1, ValidationScope var2, VariableExpression var3);

        public VariableVisitor<?, VariableVisitor.Context> createEmitVisitor(Emitter var1, VariableExpression var2);

        public void additionalContextSetup(VariableExpression var1, VariableVisitor.Context var2);

        public ReferenceType getReferenceType();
    }
}

