/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Set;

public class GenericCalledMethodInfo
implements MethodInfo {
    private final MethodInfo method;
    private final String name;
    private final TypeInfo returnType;
    private final List<Parameter> parameters;
    private final Signature signature;

    public GenericCalledMethodInfo(MethodInfo method) {
        this.method = method;
        this.name = MethodNameMangler.getGenericInterfaceMangled(method.getDefiningType(), method.getDefiningType().getNamespace(), method.getName());
        this.returnType = MethodUtil.returnsNonVoid(method) ? TypeInfos.OBJECT : TypeInfos.VOID;
        this.parameters = MoreLists.prependList(Parameter.builder().setDefiningType(method.getDefiningType()).setType(GenericTypeInfoUtil.getRootType(method.getDefiningType())).build(), MethodUtil.getUnreifiedMethod(method).getParameters());
        this.signature = SignatureFactory.create(this.name, this.returnType, Parameter.toType(this.parameters));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.method.getDefiningType();
    }

    @Override
    public Member.Type getMemberType() {
        return this.method.getMemberType();
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public Location getLoc() {
        return this.method.getLoc();
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.signature.getParameterTypes();
    }

    @Override
    public TypeInfo getReturnType() {
        return this.returnType;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Signature getEmitSignature() {
        return this.signature;
    }

    @Override
    public InvocationType getInvocationType() {
        return InvocationType.BOOTSTRAP;
    }

    @Override
    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.method.getJavaSfdcOnlyAnnotation();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isConstructor() {
        return this.method.isConstructor();
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.method.isPropertyAccessor();
    }

    @Override
    public boolean isStaticInitialization() {
        return this.method.isStaticInitialization();
    }

    @Override
    public String getCanonicalName() {
        return this.name;
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        this.method.setCanonicalName(canonicalName);
    }

    @Override
    public Set<MethodInfo> getMethodInterfaces() {
        return this.method.getMethodInterfaces();
    }

    @Override
    public void setMethodInterfaces(Set<MethodInfo> methodInterfaces) {
        this.method.setMethodInterfaces(methodInterfaces);
    }

    @Override
    public Generated getGenerated() {
        return this.method.getGenerated();
    }

    @Override
    public AsmMethod.Builder getAsmMethodBuilder() {
        return AsmMethod.builder().invokeBootstrap().setDefiningTypeAsBytecodeName(this.getDefiningType()).setFunction(this.name).setSignature(this.signature);
    }

    @Override
    public AsmMethod getAsmMethod() {
        return this.getAsmMethodBuilder().build();
    }

    @Override
    public ProfilingType getProfilingType() {
        return this.method.getProfilingType();
    }

    @Override
    public boolean isDuckTyped() {
        return this.method.isDuckTyped();
    }

    @Override
    public List<BuiltInMethodValidator> getValidators() {
        return this.method.getValidators();
    }

    @Override
    public boolean needsReturnTypeConversion() {
        return this.method.needsReturnTypeConversion();
    }

    @Override
    public DmlOperation getDmlOperation() {
        return this.method.getDmlOperation();
    }
}

