/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRule;
import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRuleGroup;
import apex.jorje.services.Version;
import com.google.common.base.Strings;

public class AnnotationProperty {
    private final String name;
    private final boolean required;
    private final Initializer<Object, Version> defaultValue;
    private final Type type;
    private final AnnotationPropertyRuleGroup rules;
    private final boolean shouldEmit;

    private AnnotationProperty(Builder builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.defaultValue = builder.defaultValue;
        this.type = builder.type;
        this.rules = builder.rules;
        this.shouldEmit = builder.shouldEmit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Type getType() {
        return this.type;
    }

    public Initializer<Object, Version> getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public AnnotationPropertyRuleGroup getRules() {
        return this.rules;
    }

    public boolean shouldEmit() {
        return this.shouldEmit;
    }

    static class Builder {
        private String name;
        private boolean required;
        private Type type = Type.STRING;
        private Initializer<Object, Version> defaultValue;
        private AnnotationPropertyRuleGroup rules = AnnotationPropertyRuleGroup.NONE;
        private boolean shouldEmit = true;

        Builder() {
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        Builder setRequired() {
            this.required = true;
            return this;
        }

        Builder setType(Type type) {
            this.type = type;
            return this;
        }

        Builder defaultValue(Object defaultValue) {
            this.defaultValue = Initializers.ofInstance(defaultValue);
            return this;
        }

        Builder setRules(AnnotationPropertyRuleGroup rules) {
            this.rules = rules;
            return this;
        }

        Builder doNotEmit() {
            this.shouldEmit = false;
            return this;
        }

        private boolean assertRules() {
            boolean validRules = true;
            for (AnnotationPropertyRule rule : this.rules.getRules()) {
                validRules &= rule.getAllowedTypes().contains((Object)this.type);
            }
            return validRules;
        }

        AnnotationProperty build() {
            assert (this.assertRules()) : "Invalid rule type";
            assert (!Strings.isNullOrEmpty(this.name)) : "Null or empty annotation property name";
            return new AnnotationProperty(this);
        }
    }

    public static enum Type {
        BOOLEAN,
        INTEGER,
        STRING;

    }
}

