/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.common.base.MoreStrings;
import apex.common.collect.MoreIterables;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.bcl.TriggerEmitMethods;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.Version;
import java.util.Optional;

public class AccessorFactory {
    private static final TypeRef.Visitor<Boolean> IS_VOID_REF = new TypeRef.Visitor<Boolean>(){

        @Override
        public Boolean visit(TypeRefs.JavaTypeRef typeRef) {
            return false;
        }

        @Override
        public Boolean visit(TypeRefs.ClassTypeRef typeRef) {
            return typeRef.getNames().size() == 1 && MoreStrings.equalsIgnoreCase(MoreIterables.getOnlyElement(typeRef.getNames()).getValue(), "void") && typeRef.getTypeArguments().isEmpty();
        }

        @Override
        public Boolean visit(TypeRefs.ArrayTypeRef typeRef) {
            return false;
        }
    };
    private static final String PROPERTY_PREFIX = "__sfdc_";
    private static final String PARAM_NAME = "value";

    public static String name(String name) {
        return PROPERTY_PREFIX + name;
    }

    static Method createSetter(Property definingNode, PropertyDecl body, boolean isVoid, ModifierGroup modifiers) {
        Optional<Statement> stmnt = body.setter.flatMap(value -> value.stmnt);
        Parameter parameter = Parameter.builder().setDefiningType(definingNode.getDefiningType()).setType(body.type).setEmitType(isVoid ? TypeInfos.OBJECT : null).setName(PARAM_NAME).setModifiers(ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).build()).build();
        Statement setter = stmnt.map(value -> AccessorFactory.explicitAccessor(definingNode, value)).orElse(AccessorFactory.implicitAccessor(definingNode, definingNode.getDefiningType().getUnitType() == UnitType.TRIGGER ? new DefaultTriggerSetter() : new DefaultSetter()));
        return MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(definingNode.getDefiningType()).setName(Identifiers.newIdentifier(body.name.getLoc(), AccessorFactory.name(body.name.getValue()))).setParameters(parameter).setReturnType(TypeInfos.VOID).setEmitSignature(isVoid ? SignatureFactory.create(AccessorFactory.name(body.name.getValue()), (TypeInfo)TypeInfos.VOID, TypeInfos.OBJECT) : null).setModifiers(modifiers).setGenerated(Generated.INTERNAL_PROXIED).setPropertyAccessor(), setter);
    }

    static Method createGetter(Property definingNode, PropertyDecl body, boolean isVoid, ModifierGroup modifiers) {
        Optional<Statement> stmnt = body.getter.flatMap(value -> value.stmnt);
        Statement getter = stmnt.map(value -> AccessorFactory.explicitAccessor(definingNode, value)).orElse(AccessorFactory.implicitAccessor(definingNode, definingNode.getDefiningType().getUnitType() == UnitType.TRIGGER ? new DefaultTriggerGetter() : new DefaultGetter()));
        Signature emitSignature = isVoid && !stmnt.isPresent() ? SignatureFactory.create(AccessorFactory.name(body.name.getValue()), TypeInfos.OBJECT) : null;
        return MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(definingNode.getDefiningType()).setName(Identifiers.newIdentifier(body.name.getLoc(), AccessorFactory.name(body.name.getValue()))).setReturnType(Optional.of(body.type)).setEmitSignature(emitSignature).setModifiers(modifiers).setGenerated(Generated.INTERNAL_PROXIED).setPropertyAccessor(), getter);
    }

    static boolean isVoidRef(TypeRef typeRef) {
        return typeRef.accept(IS_VOID_REF);
    }

    private static Statement implicitAccessor(final Property definingNode, final AccessorEmitter accessor) {
        return new Statement(definingNode){

            @Override
            public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
            }

            @Override
            public Location getLoc() {
                return definingNode.getLoc();
            }

            @Override
            public void validate(SymbolResolver symbols, ValidationScope scope) {
                this.setReturnable();
            }

            @Override
            public void emit(Emitter emitter) {
                accessor.emit(emitter, definingNode.getFieldInfo(), definingNode.getLoc());
            }
        };
    }

    private static Statement explicitAccessor(Property definingNode, Stmnt stmnt) {
        final Statement statement = AstNodes.get().create((AstNode)definingNode, stmnt);
        return new Statement(definingNode){

            @Override
            public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
                statement.traverse(visitor, scope);
            }

            @Override
            public void validate(SymbolResolver symbols, ValidationScope scope) {
                this.setReturnable(statement);
                statement.validate(symbols, scope);
            }

            @Override
            public void emit(Emitter emitter) {
                SystemModeEmit.emitter().withBody(statement).withType(emitter.getType()).emit(emitter);
            }

            @Override
            public Location getLoc() {
                return statement.getLoc();
            }
        };
    }

    private static class DefaultGetter
    implements AccessorEmitter {
        private DefaultGetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Location loc) {
            TypeInfo emitType;
            TypeInfo typeInfo = emitType = TypeInfoEquivalence.isEquivalent(fieldInfo.getEmitType(), TypeInfos.VOID) ? TypeInfos.OBJECT : fieldInfo.getEmitType();
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                emitter.emitField(loc, 178, fieldInfo, emitType);
            } else {
                emitter.emitVar(loc, 25, 0);
                emitter.emitField(loc, 180, fieldInfo, emitType);
            }
            emitter.emit(loc, 176);
        }
    }

    private static class DefaultTriggerGetter
    implements AccessorEmitter {
        private DefaultTriggerGetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Location loc) {
            TypeInfo emitType = TypeInfoEquivalence.isEquivalent(fieldInfo.getEmitType(), TypeInfos.VOID) ? TypeInfos.OBJECT : fieldInfo.getEmitType();
            emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
            emitter.emitField(loc, 180, fieldInfo, emitType);
            emitter.emit(loc, 176);
        }
    }

    private static class DefaultTriggerSetter
    implements AccessorEmitter {
        private DefaultTriggerSetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Location loc) {
            TypeInfo emitType;
            TypeInfo typeInfo = emitType = TypeInfoEquivalence.isEquivalent(fieldInfo.getEmitType(), TypeInfos.VOID) ? TypeInfos.OBJECT : fieldInfo.getEmitType();
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.FINAL) && VersionUtil.get(emitter).isGreaterThanOrEqual(Version.V160)) {
                emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
                emitter.emitField(Locations.NONE, 180, fieldInfo, emitType);
                emitter.emit(Locations.NONE, SystemEmitMethods.CHECK_FINAL);
            }
            emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
            emitter.emitVar(loc, 25, 1);
            emitter.emitField(loc, 181, fieldInfo, emitType);
            emitter.emit(loc, 177);
        }
    }

    private static class DefaultSetter
    implements AccessorEmitter {
        private DefaultSetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Location loc) {
            TypeInfo emitType;
            TypeInfo typeInfo = emitType = TypeInfoEquivalence.isEquivalent(fieldInfo.getEmitType(), TypeInfos.VOID) ? TypeInfos.OBJECT : fieldInfo.getEmitType();
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.FINAL) && VersionUtil.get(emitter).isGreaterThanOrEqual(Version.V160)) {
                if (fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                    emitter.emitField(Locations.NONE, 178, fieldInfo, emitType);
                } else {
                    emitter.emitVar(Locations.NONE, 25, 0);
                    emitter.emitField(Locations.NONE, 180, fieldInfo, emitType);
                }
                emitter.emit(Locations.NONE, SystemEmitMethods.CHECK_FINAL);
            }
            emitter.emitVar(loc, 25, 0);
            if (!fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                emitter.emitVar(loc, 25, 1);
                emitter.emitField(loc, 181, fieldInfo, emitType);
            } else {
                emitter.emitField(loc, 179, fieldInfo, emitType);
            }
            emitter.emit(loc, 177);
        }
    }

    private static interface AccessorEmitter {
        public void emit(Emitter var1, FieldInfo var2, Location var3);
    }
}

