/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.sfdc.StaticAccessEvaluatorConfig;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoType;
import apex.jorje.semantic.symbol.type.WrapperTypeInfo;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.Version;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import com.google.common.collect.MoreSets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class TypeInfoEquivalence
extends Equivalence<TypeInfo> {
    public static boolean isEquivalent(List<TypeInfo> left, List<TypeInfo> right) {
        if (left.size() != right.size()) {
            return false;
        }
        int size = left.size();
        for (int i = 0; i < size; ++i) {
            if (TypeInfoEquivalence.isEquivalent(left.get(i), right.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int doHash(List<TypeInfo> types) {
        int hash = 1;
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            hash += 31 * hash + types.get(i).getEquivalenceWrapper().hashCode();
        }
        return hash;
    }

    private static boolean equivalentSObjectBytecodeNames(SObjectTypeInfo left, SObjectTypeInfo right) {
        return Objects.equals(left.getSubEntityBytecodeNameForCreation(), right.getSubEntityBytecodeNameForCreation());
    }

    private static boolean equivalentBytecodeName(TypeInfo left, TypeInfo right) {
        if (TypeInfoUtil.isInnerTypeOfTrigger(left) || TypeInfoUtil.isInnerTypeOfTrigger(right)) {
            return Objects.equals(left.getApexName(), right.getApexName());
        }
        return Objects.equals(left.getBytecodeName(), right.getBytecodeName());
    }

    private static boolean equivalentApexName(TypeInfo left, TypeInfo right) {
        return Objects.equals(left.getApexName(), right.getApexName());
    }

    private static Boolean isStandardTypeEquivalentToJavaType(TypeInfo standardType, JavaTypeInfo javaType) {
        Class<?> otherClass;
        if (standardType instanceof WrapperTypeInfo && (otherClass = ((WrapperTypeInfo)standardType).getJavaType()) != null) {
            Class<?> thisClass = javaType.getJavaType();
            return otherClass.isAssignableFrom(thisClass);
        }
        return TypeInfoEquivalence.equivalentBytecodeName(standardType, javaType);
    }

    @SfdcCalled
    public static Set<Equivalence.Wrapper<TypeInfo>> wrapAll(Set<TypeInfo> types) {
        return types.stream().map(TypeInfo::getEquivalenceWrapper).collect(MoreSets.toImmutableSet());
    }

    public static <T extends TypeInfo> List<T> unwrapAll(Collection<Equivalence.Wrapper<TypeInfo>> wrappers) {
        if (wrappers.isEmpty()) {
            return ImmutableList.of();
        }
        return wrappers.stream().map(wrapper -> (TypeInfo)wrapper.get()).collect(MoreLists.toImmutableList(wrappers.size()));
    }

    public static boolean isEquivalent(Version version, TypeInfo left, TypeInfo right) {
        if (TypeInfoEquivalence.isEquivalent(left, right)) {
            return true;
        }
        if (version.isLessThan(Version.V160) && left.getTypeArguments().size() == right.getTypeArguments().size()) {
            int size = left.getTypeArguments().size();
            for (int i = 0; i < size; ++i) {
                boolean isTypeArgumentEquivalent = TypeInfoEquivalence.isEquivalent(version, left.getTypeArguments().get(i), right.getTypeArguments().get(i));
                if (isTypeArgumentEquivalent) continue;
                return false;
            }
            if (TypeInfoUtil.isInnerType(left) && TypeInfoUtil.isInnerType(right)) {
                return left.getCodeUnitDetails().getName().equalsIgnoreCase(right.getCodeUnitDetails().getName());
            }
            TypeInfo leftRoot = GenericTypeInfoUtil.getRootType(left);
            TypeInfo rightRoot = GenericTypeInfoUtil.getRootType(right);
            return TypeInfoEquivalence.isEquivalent(leftRoot, rightRoot);
        }
        return version.isLessThan(Version.V210) && left.getBasicType() == BasicType.FLOW_INTERVIEW && right.getBasicType() == BasicType.FLOW_INTERVIEW && StaticAccessEvaluatorConfig.getEvaluator().ignoreFlowAssignabilityCheck();
    }

    public static boolean isEquivalent(TypeInfo left, TypeInfo right) {
        if (left == right) {
            return true;
        }
        if (left.isResolved() != right.isResolved()) {
            return false;
        }
        TypeInfoType leftType = TypeInfoType.fromTypeInfo(left);
        TypeInfoType rightType = TypeInfoType.fromTypeInfo(right);
        switch (leftType) {
            case STANDARD: {
                switch (rightType) {
                    case STANDARD: 
                    case INTERNAL: {
                        return TypeInfoEquivalence.equivalentBytecodeName(left, right);
                    }
                    case JAVA: {
                        return TypeInfoEquivalence.isStandardTypeEquivalentToJavaType(left, (JavaTypeInfo)right);
                    }
                }
                return false;
            }
            case SCALAR: {
                switch (rightType) {
                    case JAVA: 
                    case SCALAR: {
                        return TypeInfoEquivalence.equivalentBytecodeName(left, right);
                    }
                }
                return false;
            }
            case MODIFIER: {
                switch (rightType) {
                    case MODIFIER: {
                        return TypeInfoEquivalence.equivalentApexName(left, right);
                    }
                }
                return false;
            }
            case GENERIC: {
                switch (rightType) {
                    case INTERNAL: 
                    case GENERIC: {
                        return TypeInfoEquivalence.equivalentBytecodeName(GenericTypeInfoUtil.getRootType(left), GenericTypeInfoUtil.getRootType(right)) && TypeInfoEquivalence.isEquivalent(left.getTypeArguments(), right.getTypeArguments());
                    }
                }
                return false;
            }
            case INTERNAL: {
                switch (rightType) {
                    case STANDARD: 
                    case GENERIC: {
                        return TypeInfoEquivalence.equivalentBytecodeName(GenericTypeInfoUtil.getRootType(left), GenericTypeInfoUtil.getRootType(right)) && TypeInfoEquivalence.isEquivalent(left.getTypeArguments(), right.getTypeArguments());
                    }
                    case INTERNAL: 
                    case JAVA: 
                    case SOBJECT: {
                        return TypeInfoEquivalence.equivalentBytecodeName(left, right);
                    }
                }
                return false;
            }
            case ARGUMENT: {
                switch (rightType) {
                    case ARGUMENT: {
                        return TypeInfoEquivalence.equivalentApexName(left, right);
                    }
                }
                return false;
            }
            case JAVA: {
                switch (rightType) {
                    case STANDARD: {
                        return TypeInfoEquivalence.isStandardTypeEquivalentToJavaType(right, (JavaTypeInfo)left);
                    }
                    case INTERNAL: 
                    case JAVA: 
                    case SCALAR: 
                    case SOBJECT: {
                        return TypeInfoEquivalence.equivalentBytecodeName(left, right);
                    }
                }
                return false;
            }
            case SOBJECT: {
                switch (rightType) {
                    case SOBJECT: {
                        return TypeInfoEquivalence.equivalentSObjectBytecodeNames(SObjectTypeInfoUtil.getSObjectTypeInfoFromType(left), SObjectTypeInfoUtil.getSObjectTypeInfoFromType(right));
                    }
                    case INTERNAL: {
                        return TypeInfoEquivalence.equivalentBytecodeName(left, right);
                    }
                }
                return false;
            }
            case VF: {
                switch (rightType) {
                    case VF: {
                        return TypeInfoEquivalence.equivalentBytecodeName(left, right);
                    }
                }
                return false;
            }
            case FLOW: {
                switch (rightType) {
                    case FLOW: {
                        return TypeInfoEquivalence.equivalentBytecodeName(left, right);
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    protected boolean doEquivalent(@Nonnull TypeInfo left, @Nonnull TypeInfo right) {
        return TypeInfoEquivalence.isEquivalent(right, left);
    }

    @Override
    protected int doHash(@Nonnull TypeInfo type) {
        return type.getBytecodeName().hashCode();
    }

    public String toString() {
        return "eq";
    }
}

