/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.bcl.TriggerEmitMethods;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerFieldInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.services.Version;
import com.google.common.base.MoreObjects;

public class VariableEmitStoreVisitor
implements VariableVisitor<Void, VariableVisitor.Context> {
    private final VariableExpression expression;
    private final Emitter emitter;

    public VariableEmitStoreVisitor(VariableExpression expression, Emitter emitter) {
        this.expression = expression;
        this.emitter = emitter;
    }

    @Override
    public Void visit(LocalInfo info, VariableVisitor.Context context) {
        if (!context.isInitialStore && info.getModifiers().has(ModifierTypeInfos.FINAL)) {
            this.emitter.emitVar(Locations.NONE, 25, info.getPosition(this.emitter));
            this.emitter.emit(Locations.NONE, SystemEmitMethods.CHECK_FINAL);
        }
        this.emitter.emitVar(context.loc, 58, info.getPosition(this.emitter));
        return null;
    }

    @Override
    public Void visit(StandardFieldInfo info, VariableVisitor.Context context) {
        if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            if (!context.isInitialStore && info.getModifiers().has(ModifierTypeInfos.FINAL)) {
                this.emitter.emitField(Locations.NONE, 178, info);
                this.emitter.emit(Locations.NONE, SystemEmitMethods.CHECK_FINAL);
            }
            this.emitter.emitField(context.loc, 179, info);
        } else {
            if (!context.isInitialStore) {
                if (context.previous == IdentifierContext.NONE) {
                    this.emitter.emitVar(context.loc, 25, 0);
                }
                this.emitter.emit(context.loc, 95);
            }
            if (!context.isInitialStore && info.getModifiers().has(ModifierTypeInfos.FINAL) && VersionUtil.get(this.emitter).isGreaterThanOrEqual(Version.V160)) {
                this.emitter.emit(Locations.NONE, 95);
                this.emitter.emit(Locations.NONE, 89);
                this.emitter.emitField(Locations.NONE, 180, info);
                this.emitter.emit(Locations.NONE, SystemEmitMethods.CHECK_FINAL);
                this.emitter.emit(Locations.NONE, 95);
            }
            this.emitter.emitField(context.loc, 181, info);
        }
        return null;
    }

    @Override
    public Void visit(StandardPropertyInfo info, VariableVisitor.Context context) {
        if (!info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            if (context.previous == IdentifierContext.NONE) {
                this.emitter.emitVar(context.loc, 25, 0);
            }
            if (!context.isInitialStore) {
                this.emitter.emit(context.loc, 95);
            }
        }
        if (info == this.emitter.emitRawProperty()) {
            FieldInfo fieldInfo = info.getUnderlyingField();
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.emitter.emitField(context.loc, 179, fieldInfo);
            } else {
                this.emitter.emitField(context.loc, 181, fieldInfo);
            }
        } else {
            MethodInfo setter = info.getProperty().getSetter();
            MethodInfo proxy = this.emitter.getProxyMethodTable().get(context.loc, this.expression.getDefiningType(), info.getDefiningType(), setter);
            AsmMethod asmMethod = proxy != null ? proxy.getAsmMethod() : setter.getAsmMethod();
            this.emitter.emit(context.loc, asmMethod);
        }
        return null;
    }

    @Override
    public Void visit(TriggerFieldInfo info, VariableVisitor.Context context) {
        this.emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
        if (!context.isInitialStore && info.getModifiers().has(ModifierTypeInfos.FINAL) && VersionUtil.get(this.emitter).isGreaterThanOrEqual(Version.V160)) {
            this.emitter.emit(Locations.NONE, 89);
            this.emitter.emitField(Locations.NONE, 180, info);
            this.emitter.emit(Locations.NONE, SystemEmitMethods.CHECK_FINAL);
        }
        this.emitter.emit(Locations.NONE, 95);
        this.emitter.emitField(context.loc, 181, info);
        return null;
    }

    @Override
    public Void visit(TriggerPropertyInfo info, VariableVisitor.Context context) {
        if (info == this.emitter.emitRawProperty()) {
            if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.emitter.emitField(context.loc, 179, info);
            } else {
                if (context.previous == IdentifierContext.NONE) {
                    this.emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
                    this.emitter.emit(Locations.NONE, 95);
                }
                this.emitter.emitField(context.loc, 181, info);
            }
        } else {
            this.emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
            this.emitter.emit(Locations.NONE, 95);
            AsmMethod asmMethod = info.getProperty().getSetter().getAsmMethod();
            this.emitter.emit(context.loc, asmMethod);
        }
        return null;
    }

    @Override
    public Void visit(SObjectFieldInfo info, VariableVisitor.Context context) {
        TypeInfo variableType = MoreObjects.firstNonNull(context.firstSObjectTypeInfo, info.getDefiningType());
        if (context.shouldPeelSObject) {
            this.emitter.push(context.loc, variableType.getBytecodeName());
            this.emitter.emit(context.loc, ListEmitMethods.GET_FIRST_SOBJECT_BYTECODE);
        }
        SObjectTypeInfo.MethodsForEmit methodsForEmit = SObjectTypeInfoUtil.getMethodsForEmit(variableType);
        this.emitter.emit(context.loc, 95);
        this.emitter.push(context.loc, info.getBytecodeName());
        this.emitter.emit(context.loc, methodsForEmit.setValueMethod());
        return null;
    }

    @Override
    public Void visit(DynamicFieldInfo info, VariableVisitor.Context context) {
        if (info.getStoreEmitter() != null) {
            info.getStoreEmitter().emit(this.emitter, info, context);
        }
        return null;
    }
}

