/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import java.util.List;

public class MultiStatement
extends Statement {
    private final Location loc;
    private final List<AstNode> statements;
    private final Emit emit;

    public MultiStatement(AstNode definingNode, Location loc, List<AstNode> statements, Emit emit) {
        super(definingNode);
        this.loc = loc;
        this.statements = statements;
        this.emit = emit;
    }

    @Override
    public final <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        for (AstNode node : this.statements) {
            node.traverse(visitor, scope);
        }
    }

    @Override
    public final void validate(SymbolResolver symbols, ValidationScope scope) {
        for (AstNode node : this.statements) {
            node.validate(symbols, scope);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.emit.emit(emitter);
    }

    @Override
    public final Location getLoc() {
        return this.loc;
    }
}

