/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.SObjectMetadata;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public final class CustomEntityValidators {
    public static final BuiltInMethodValidator CUSTOM_ENTITY_VALIDATOR = new StandardCustomEntityValidator(true);
    public static final BuiltInMethodValidator CUSTOM_SETTINGS_VALIDATOR = new StandardCustomEntityValidator(false);
    public static final BuiltInMethodValidator GET_ALL_CUSTOM_ENTITY_VALIDATOR = new GetAllCustomEntityValidator();
    public static final BuiltInMethodValidator VISIBILITY_CUSTOM_ENTITY_VALIDATOR = new VisibilityCustomEntityValidator();

    private CustomEntityValidators() {
    }

    public static class VisibilityCustomEntityValidator
    implements BuiltInMethodValidator {
        @Override
        public void validate(final SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
            expression.getMethod().get().getDefiningType().accept(new TypeInfoVisitor.Default<Void>(){

                @Override
                protected Void _default(TypeInfo type) {
                    return null;
                }

                @Override
                public Void visit(SObjectTypeInfo type) {
                    AccessEvaluator accessEvaluator = symbols.getAccessEvaluator();
                    if (!accessEvaluator.isSetupEntityVisibleToType(type, expression.getDefiningType())) {
                        scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel(type.getMetadata().isCustomMetadata() ? "custom.metadata.type.namespace.not.visible" : "custom.settings.namespace.not.visible"));
                    }
                    return null;
                }
            });
        }
    }

    private static class GetAllCustomEntityValidator
    implements BuiltInMethodValidator {
        private GetAllCustomEntityValidator() {
        }

        @Override
        public void validate(final SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
            expression.getMethod().get().getDefiningType().accept(new TypeInfoVisitor.Default<Void>(){

                @Override
                protected Void _default(TypeInfo type) {
                    CUSTOM_ENTITY_VALIDATOR.validate(symbols, scope, expression);
                    return null;
                }

                @Override
                public Void visit(SObjectTypeInfo type) {
                    if (type.getMetadata().getCustomEntitySObjectType() == SObjectMetadata.CustomEntitySObjectType.HIERARCHY_CUSTOM_SETTING) {
                        scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("method.only.list.custom.settings", type));
                        return null;
                    }
                    return this._default(type);
                }
            });
        }
    }

    private static class StandardCustomEntityValidator
    implements BuiltInMethodValidator {
        private final boolean allowCustomMetadata;

        private StandardCustomEntityValidator(boolean allowCustomMetadata) {
            this.allowCustomMetadata = allowCustomMetadata;
        }

        @Override
        public void validate(final SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
            expression.getMethod().get().getDefiningType().accept(new TypeInfoVisitor.Default<Void>(){

                @Override
                protected Void _default(TypeInfo type) {
                    VISIBILITY_CUSTOM_ENTITY_VALIDATOR.validate(symbols, scope, expression);
                    return null;
                }

                @Override
                public Void visit(SObjectTypeInfo type) {
                    if (!this.isValidCustomEntityType(type)) {
                        scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("invalid.method.not.found", expression.getMethod().get().getName(), type.getApexName()));
                        return null;
                    }
                    return this._default(type);
                }
            });
        }

        private boolean isValidCustomEntityType(SObjectTypeInfo type) {
            return type.getMetadata().isCustomSetting() || this.allowCustomMetadata && type.getMetadata().isCustomMetadata();
        }
    }
}

