/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.common.base.Result;
import apex.common.base.VoidResult;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.MoreMaps;
import java.util.Collection;
import java.util.Map;

public class StandardFieldTable
implements FieldTable {
    private final Map<String, FieldInfo> fields = MoreMaps.newCaseInsensitiveMap();
    private boolean resolved = false;

    @Override
    public Result<Void> add(FieldInfo field) {
        assert (!this.resolved) : "can't add fields after field table is resolved";
        if (this.fields.containsKey(field.getName())) {
            return VoidResult.error(I18nSupport.getLabel("duplicate.field", field.getName()));
        }
        this.fields.put(field.getName(), field);
        return VoidResult.of();
    }

    @Override
    public FieldInfo get(SymbolResolver symbols, TypeInfo referencingType, String name, FieldTable.LookupMode mode) {
        assert (this.resolved) : "can't get fields until field table is resolved";
        return this.fields.get(name);
    }

    @Override
    public FieldTable resolve() {
        this.resolved = true;
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public Collection<FieldInfo> all() {
        return this.fields.values();
    }
}

