<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/blobstore/blobstore_service.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/api/api_base_pb.php';
}
namespace google\appengine\BlobstoreServiceError {
  class ErrorCode {
    const OK = 0;
    const INTERNAL_ERROR = 1;
    const URL_TOO_LONG = 2;
    const PERMISSION_DENIED = 3;
    const BLOB_NOT_FOUND = 4;
    const DATA_INDEX_OUT_OF_RANGE = 5;
    const BLOB_FETCH_SIZE_TOO_LARGE = 6;
    const ARGUMENT_OUT_OF_RANGE = 8;
    const INVALID_BLOB_KEY = 9;
  }
}
namespace google\appengine {
  class BlobstoreServiceError extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class CreateUploadURLRequest extends \google\net\ProtocolMessage {
    public function getSuccessPath() {
      if (!isset($this->success_path)) {
        return '';
      }
      return $this->success_path;
    }
    public function setSuccessPath($val) {
      $this->success_path = $val;
      return $this;
    }
    public function clearSuccessPath() {
      unset($this->success_path);
      return $this;
    }
    public function hasSuccessPath() {
      return isset($this->success_path);
    }
    public function getMaxUploadSizeBytes() {
      if (!isset($this->max_upload_size_bytes)) {
        return "0";
      }
      return $this->max_upload_size_bytes;
    }
    public function setMaxUploadSizeBytes($val) {
      if (is_double($val)) {
        $this->max_upload_size_bytes = sprintf('%0.0F', $val);
      } else {
        $this->max_upload_size_bytes = $val;
      }
      return $this;
    }
    public function clearMaxUploadSizeBytes() {
      unset($this->max_upload_size_bytes);
      return $this;
    }
    public function hasMaxUploadSizeBytes() {
      return isset($this->max_upload_size_bytes);
    }
    public function getMaxUploadSizePerBlobBytes() {
      if (!isset($this->max_upload_size_per_blob_bytes)) {
        return "0";
      }
      return $this->max_upload_size_per_blob_bytes;
    }
    public function setMaxUploadSizePerBlobBytes($val) {
      if (is_double($val)) {
        $this->max_upload_size_per_blob_bytes = sprintf('%0.0F', $val);
      } else {
        $this->max_upload_size_per_blob_bytes = $val;
      }
      return $this;
    }
    public function clearMaxUploadSizePerBlobBytes() {
      unset($this->max_upload_size_per_blob_bytes);
      return $this;
    }
    public function hasMaxUploadSizePerBlobBytes() {
      return isset($this->max_upload_size_per_blob_bytes);
    }
    public function getGsBucketName() {
      if (!isset($this->gs_bucket_name)) {
        return '';
      }
      return $this->gs_bucket_name;
    }
    public function setGsBucketName($val) {
      $this->gs_bucket_name = $val;
      return $this;
    }
    public function clearGsBucketName() {
      unset($this->gs_bucket_name);
      return $this;
    }
    public function hasGsBucketName() {
      return isset($this->gs_bucket_name);
    }
    public function clear() {
      $this->clearSuccessPath();
      $this->clearMaxUploadSizeBytes();
      $this->clearMaxUploadSizePerBlobBytes();
      $this->clearGsBucketName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->success_path)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->success_path));
      }
      if (isset($this->max_upload_size_bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_upload_size_bytes);
      }
      if (isset($this->max_upload_size_per_blob_bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_upload_size_per_blob_bytes);
      }
      if (isset($this->gs_bucket_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->gs_bucket_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->success_path)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->success_path);
      }
      if (isset($this->max_upload_size_bytes)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->max_upload_size_bytes);
      }
      if (isset($this->max_upload_size_per_blob_bytes)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->max_upload_size_per_blob_bytes);
      }
      if (isset($this->gs_bucket_name)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->gs_bucket_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setSuccessPath(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setMaxUploadSizeBytes($d->getVarInt64());
            break;
          case 24:
            $this->setMaxUploadSizePerBlobBytes($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setGsBucketName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->success_path)) return 'success_path';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasSuccessPath()) {
        $this->setSuccessPath($x->getSuccessPath());
      }
      if ($x->hasMaxUploadSizeBytes()) {
        $this->setMaxUploadSizeBytes($x->getMaxUploadSizeBytes());
      }
      if ($x->hasMaxUploadSizePerBlobBytes()) {
        $this->setMaxUploadSizePerBlobBytes($x->getMaxUploadSizePerBlobBytes());
      }
      if ($x->hasGsBucketName()) {
        $this->setGsBucketName($x->getGsBucketName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->success_path) !== isset($x->success_path)) return false;
      if (isset($this->success_path) && $this->success_path !== $x->success_path) return false;
      if (isset($this->max_upload_size_bytes) !== isset($x->max_upload_size_bytes)) return false;
      if (isset($this->max_upload_size_bytes) && !$this->integerEquals($this->max_upload_size_bytes, $x->max_upload_size_bytes)) return false;
      if (isset($this->max_upload_size_per_blob_bytes) !== isset($x->max_upload_size_per_blob_bytes)) return false;
      if (isset($this->max_upload_size_per_blob_bytes) && !$this->integerEquals($this->max_upload_size_per_blob_bytes, $x->max_upload_size_per_blob_bytes)) return false;
      if (isset($this->gs_bucket_name) !== isset($x->gs_bucket_name)) return false;
      if (isset($this->gs_bucket_name) && $this->gs_bucket_name !== $x->gs_bucket_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->success_path)) {
        $res .= $prefix . "success_path: " . $this->debugFormatString($this->success_path) . "\n";
      }
      if (isset($this->max_upload_size_bytes)) {
        $res .= $prefix . "max_upload_size_bytes: " . $this->debugFormatInt64($this->max_upload_size_bytes) . "\n";
      }
      if (isset($this->max_upload_size_per_blob_bytes)) {
        $res .= $prefix . "max_upload_size_per_blob_bytes: " . $this->debugFormatInt64($this->max_upload_size_per_blob_bytes) . "\n";
      }
      if (isset($this->gs_bucket_name)) {
        $res .= $prefix . "gs_bucket_name: " . $this->debugFormatString($this->gs_bucket_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class CreateUploadURLResponse extends \google\net\ProtocolMessage {
    public function getUrl() {
      if (!isset($this->url)) {
        return '';
      }
      return $this->url;
    }
    public function setUrl($val) {
      $this->url = $val;
      return $this;
    }
    public function clearUrl() {
      unset($this->url);
      return $this;
    }
    public function hasUrl() {
      return isset($this->url);
    }
    public function clear() {
      $this->clearUrl();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->url)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->url));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->url)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->url);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setUrl(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->url)) return 'url';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasUrl()) {
        $this->setUrl($x->getUrl());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->url) !== isset($x->url)) return false;
      if (isset($this->url) && $this->url !== $x->url) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->url)) {
        $res .= $prefix . "url: " . $this->debugFormatString($this->url) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class DeleteBlobRequest extends \google\net\ProtocolMessage {
    private $blob_key = array();
    public function getBlobKeySize() {
      return sizeof($this->blob_key);
    }
    public function getBlobKeyList() {
      return $this->blob_key;
    }
    public function getBlobKey($idx) {
      return $this->blob_key[$idx];
    }
    public function setBlobKey($idx, $val) {
      $this->blob_key[$idx] = $val;
      return $this;
    }
    public function addBlobKey($val) {
      $this->blob_key[] = $val;
      return $this;
    }
    public function clearBlobKey() {
      $this->blob_key = array();
    }
    public function clear() {
      $this->clearBlobKey();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->blob_key);
      $res += 1 * sizeof($this->blob_key);
      foreach ($this->blob_key as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->blob_key);
      foreach ($this->blob_key as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getBlobKeyList() as $v) {
        $this->addBlobKey($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->blob_key) !== sizeof($x->blob_key)) return false;
      foreach (array_map(null, $this->blob_key, $x->blob_key) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->blob_key as $value) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class FetchDataRequest extends \google\net\ProtocolMessage {
    public function getBlobKey() {
      if (!isset($this->blob_key)) {
        return '';
      }
      return $this->blob_key;
    }
    public function setBlobKey($val) {
      $this->blob_key = $val;
      return $this;
    }
    public function clearBlobKey() {
      unset($this->blob_key);
      return $this;
    }
    public function hasBlobKey() {
      return isset($this->blob_key);
    }
    public function getStartIndex() {
      if (!isset($this->start_index)) {
        return "0";
      }
      return $this->start_index;
    }
    public function setStartIndex($val) {
      if (is_double($val)) {
        $this->start_index = sprintf('%0.0F', $val);
      } else {
        $this->start_index = $val;
      }
      return $this;
    }
    public function clearStartIndex() {
      unset($this->start_index);
      return $this;
    }
    public function hasStartIndex() {
      return isset($this->start_index);
    }
    public function getEndIndex() {
      if (!isset($this->end_index)) {
        return "0";
      }
      return $this->end_index;
    }
    public function setEndIndex($val) {
      if (is_double($val)) {
        $this->end_index = sprintf('%0.0F', $val);
      } else {
        $this->end_index = $val;
      }
      return $this;
    }
    public function clearEndIndex() {
      unset($this->end_index);
      return $this;
    }
    public function hasEndIndex() {
      return isset($this->end_index);
    }
    public function clear() {
      $this->clearBlobKey();
      $this->clearStartIndex();
      $this->clearEndIndex();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->blob_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->blob_key));
      }
      if (isset($this->start_index)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->start_index);
      }
      if (isset($this->end_index)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->end_index);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->blob_key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->blob_key);
      }
      if (isset($this->start_index)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->start_index);
      }
      if (isset($this->end_index)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->end_index);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setStartIndex($d->getVarInt64());
            break;
          case 24:
            $this->setEndIndex($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->blob_key)) return 'blob_key';
      if (!isset($this->start_index)) return 'start_index';
      if (!isset($this->end_index)) return 'end_index';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBlobKey()) {
        $this->setBlobKey($x->getBlobKey());
      }
      if ($x->hasStartIndex()) {
        $this->setStartIndex($x->getStartIndex());
      }
      if ($x->hasEndIndex()) {
        $this->setEndIndex($x->getEndIndex());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->blob_key) !== isset($x->blob_key)) return false;
      if (isset($this->blob_key) && $this->blob_key !== $x->blob_key) return false;
      if (isset($this->start_index) !== isset($x->start_index)) return false;
      if (isset($this->start_index) && !$this->integerEquals($this->start_index, $x->start_index)) return false;
      if (isset($this->end_index) !== isset($x->end_index)) return false;
      if (isset($this->end_index) && !$this->integerEquals($this->end_index, $x->end_index)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->blob_key)) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($this->blob_key) . "\n";
      }
      if (isset($this->start_index)) {
        $res .= $prefix . "start_index: " . $this->debugFormatInt64($this->start_index) . "\n";
      }
      if (isset($this->end_index)) {
        $res .= $prefix . "end_index: " . $this->debugFormatInt64($this->end_index) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class FetchDataResponse extends \google\net\ProtocolMessage {
    public function getData() {
      if (!isset($this->data)) {
        return '';
      }
      return $this->data;
    }
    public function setData($val) {
      $this->data = $val;
      return $this;
    }
    public function clearData() {
      unset($this->data);
      return $this;
    }
    public function hasData() {
      return isset($this->data);
    }
    public function clear() {
      $this->clearData();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->data)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->data));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->data)) {
        $out->putVarInt32(8002);
        $out->putPrefixedString($this->data);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8002:
            $length = $d->getVarInt32();
            $this->setData(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->data)) return 'data';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasData()) {
        $this->setData($x->getData());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->data) !== isset($x->data)) return false;
      if (isset($this->data) && $this->data !== $x->data) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->data)) {
        $res .= $prefix . "data: " . $this->debugFormatString($this->data) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class CloneBlobRequest extends \google\net\ProtocolMessage {
    public function getBlobKey() {
      if (!isset($this->blob_key)) {
        return '';
      }
      return $this->blob_key;
    }
    public function setBlobKey($val) {
      $this->blob_key = $val;
      return $this;
    }
    public function clearBlobKey() {
      unset($this->blob_key);
      return $this;
    }
    public function hasBlobKey() {
      return isset($this->blob_key);
    }
    public function getMimeType() {
      if (!isset($this->mime_type)) {
        return '';
      }
      return $this->mime_type;
    }
    public function setMimeType($val) {
      $this->mime_type = $val;
      return $this;
    }
    public function clearMimeType() {
      unset($this->mime_type);
      return $this;
    }
    public function hasMimeType() {
      return isset($this->mime_type);
    }
    public function getTargetAppId() {
      if (!isset($this->target_app_id)) {
        return '';
      }
      return $this->target_app_id;
    }
    public function setTargetAppId($val) {
      $this->target_app_id = $val;
      return $this;
    }
    public function clearTargetAppId() {
      unset($this->target_app_id);
      return $this;
    }
    public function hasTargetAppId() {
      return isset($this->target_app_id);
    }
    public function clear() {
      $this->clearBlobKey();
      $this->clearMimeType();
      $this->clearTargetAppId();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->blob_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->blob_key));
      }
      if (isset($this->mime_type)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->mime_type));
      }
      if (isset($this->target_app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->target_app_id));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->blob_key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->blob_key);
      }
      if (isset($this->mime_type)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->mime_type);
      }
      if (isset($this->target_app_id)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->target_app_id);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setMimeType(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setTargetAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->blob_key)) return 'blob_key';
      if (!isset($this->mime_type)) return 'mime_type';
      if (!isset($this->target_app_id)) return 'target_app_id';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBlobKey()) {
        $this->setBlobKey($x->getBlobKey());
      }
      if ($x->hasMimeType()) {
        $this->setMimeType($x->getMimeType());
      }
      if ($x->hasTargetAppId()) {
        $this->setTargetAppId($x->getTargetAppId());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->blob_key) !== isset($x->blob_key)) return false;
      if (isset($this->blob_key) && $this->blob_key !== $x->blob_key) return false;
      if (isset($this->mime_type) !== isset($x->mime_type)) return false;
      if (isset($this->mime_type) && $this->mime_type !== $x->mime_type) return false;
      if (isset($this->target_app_id) !== isset($x->target_app_id)) return false;
      if (isset($this->target_app_id) && $this->target_app_id !== $x->target_app_id) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->blob_key)) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($this->blob_key) . "\n";
      }
      if (isset($this->mime_type)) {
        $res .= $prefix . "mime_type: " . $this->debugFormatString($this->mime_type) . "\n";
      }
      if (isset($this->target_app_id)) {
        $res .= $prefix . "target_app_id: " . $this->debugFormatString($this->target_app_id) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class CloneBlobResponse extends \google\net\ProtocolMessage {
    public function getBlobKey() {
      if (!isset($this->blob_key)) {
        return '';
      }
      return $this->blob_key;
    }
    public function setBlobKey($val) {
      $this->blob_key = $val;
      return $this;
    }
    public function clearBlobKey() {
      unset($this->blob_key);
      return $this;
    }
    public function hasBlobKey() {
      return isset($this->blob_key);
    }
    public function clear() {
      $this->clearBlobKey();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->blob_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->blob_key));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->blob_key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->blob_key);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->blob_key)) return 'blob_key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBlobKey()) {
        $this->setBlobKey($x->getBlobKey());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->blob_key) !== isset($x->blob_key)) return false;
      if (isset($this->blob_key) && $this->blob_key !== $x->blob_key) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->blob_key)) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($this->blob_key) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class DecodeBlobKeyRequest extends \google\net\ProtocolMessage {
    private $blob_key = array();
    public function getBlobKeySize() {
      return sizeof($this->blob_key);
    }
    public function getBlobKeyList() {
      return $this->blob_key;
    }
    public function getBlobKey($idx) {
      return $this->blob_key[$idx];
    }
    public function setBlobKey($idx, $val) {
      $this->blob_key[$idx] = $val;
      return $this;
    }
    public function addBlobKey($val) {
      $this->blob_key[] = $val;
      return $this;
    }
    public function clearBlobKey() {
      $this->blob_key = array();
    }
    public function clear() {
      $this->clearBlobKey();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->blob_key);
      $res += 1 * sizeof($this->blob_key);
      foreach ($this->blob_key as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->blob_key);
      foreach ($this->blob_key as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getBlobKeyList() as $v) {
        $this->addBlobKey($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->blob_key) !== sizeof($x->blob_key)) return false;
      foreach (array_map(null, $this->blob_key, $x->blob_key) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->blob_key as $value) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class DecodeBlobKeyResponse extends \google\net\ProtocolMessage {
    private $decoded = array();
    public function getDecodedSize() {
      return sizeof($this->decoded);
    }
    public function getDecodedList() {
      return $this->decoded;
    }
    public function getDecoded($idx) {
      return $this->decoded[$idx];
    }
    public function setDecoded($idx, $val) {
      $this->decoded[$idx] = $val;
      return $this;
    }
    public function addDecoded($val) {
      $this->decoded[] = $val;
      return $this;
    }
    public function clearDecoded() {
      $this->decoded = array();
    }
    public function clear() {
      $this->clearDecoded();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->decoded);
      $res += 1 * sizeof($this->decoded);
      foreach ($this->decoded as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->decoded);
      foreach ($this->decoded as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addDecoded(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getDecodedList() as $v) {
        $this->addDecoded($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->decoded) !== sizeof($x->decoded)) return false;
      foreach (array_map(null, $this->decoded, $x->decoded) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->decoded as $value) {
        $res .= $prefix . "decoded: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class CreateEncodedGoogleStorageKeyRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function clear() {
      $this->clearFilename();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class CreateEncodedGoogleStorageKeyResponse extends \google\net\ProtocolMessage {
    public function getBlobKey() {
      if (!isset($this->blob_key)) {
        return '';
      }
      return $this->blob_key;
    }
    public function setBlobKey($val) {
      $this->blob_key = $val;
      return $this;
    }
    public function clearBlobKey() {
      unset($this->blob_key);
      return $this;
    }
    public function hasBlobKey() {
      return isset($this->blob_key);
    }
    public function clear() {
      $this->clearBlobKey();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->blob_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->blob_key));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->blob_key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->blob_key);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->blob_key)) return 'blob_key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBlobKey()) {
        $this->setBlobKey($x->getBlobKey());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->blob_key) !== isset($x->blob_key)) return false;
      if (isset($this->blob_key) && $this->blob_key !== $x->blob_key) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->blob_key)) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($this->blob_key) . "\n";
      }
      return $res;
    }
  }
}
