<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ixsl="http://saxonica.com/ns/interactiveXSLT"
    xmlns:prop="http://saxonica.com/ns/html-property"
    xmlns:style="http://saxonica.com/ns/html-style-property"
    xmlns:js="http://saxonica.com/ns/globalJS" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="2.0" exclude-result-prefixes="xs prop" extension-element-prefixes="ixsl prop style"
    xmlns:ch="http://www.saxonica.com/ns/doc/changes"
    xmlns:f="urn:internal.function">


    <xsl:variable name="all-changes" select="doc('../doc/changes.xml')"/>

    <xsl:variable name="categories" select="$all-changes/ch:changes/ch:categories/ch:cat"
        as="element(ch:cat)*"/>

    <xsl:variable name="releases" select="$all-changes/ch:changes/ch:release" as="node()*"/>

    <xsl:variable name="saxonVersions" select="$all-changes/ch:changes/ch:release/@number"
        as="xs:string*"/>

    <xsl:variable name="fromList" select="ixsl:page()/id('fromList')"/>
    <xsl:variable name="toList" select="ixsl:page()/id('toList')"/>
    <xsl:variable name="catList" select="ixsl:page()/id('catList')"/>


    <xsl:template match="/" mode="changes" xpath-default-namespace="">
        <xsl:param name="selectedCategory" select="()" as="xs:string?"/>
        <xsl:param name="selectedVersionRange" select="()" as="xs:string?"/>
        <xsl:variable name="title" select="(h1|h2|h3)[1]"/>
        <xsl:if test="exists($title)">
            <ixsl:set-property name="document.title" select="concat('Saxon ', $title)"/>
        </xsl:if>
        <h1>Saxon Change History</h1>
        
        <xsl:variable name="fromVersion" as="xs:string" 
            select="if (exists($selectedVersionRange)) then substring-before($selectedVersionRange, '-') else $saxonVersions[2]"/>
        <xsl:variable name="toVersion" as="xs:string" 
            select="if (exists($selectedVersionRange)) then substring-after($selectedVersionRange, '-') else $saxonVersions[1]"/>
        
        <xsl:variable name="selectedCategory" select="($selectedCategory, $categories[1]/@name)[1]" as="xs:string"/>

        <p>Details of changes in all Saxon releases since 7.0 are available here.</p>

        <p>Show changes between version <select id="fromList">
                <xsl:for-each select="subsequence($saxonVersions, 2)">
                    <option>
                        <xsl:if test=". eq $fromVersion">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="."/>
                    </option>
                </xsl:for-each>
            </select> and <select id="toList">
                <xsl:for-each select="$saxonVersions[. gt $fromVersion]">
                    <option>
                        <xsl:if test=". eq $toVersion">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="."/>
                    </option>
                </xsl:for-each>
            </select></p>
        <p>Selected category:
            <select id="catList">
                <xsl:for-each select="ch:changes/ch:categories/ch:cat">
                    <option name="{@name}">
                        <xsl:if test="@name = $selectedCategory">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="@title"/>
                    </option>
                </xsl:for-each>
            </select>
        </p>


        <div id="changes-content" style="max-width:1300px">
            <xsl:call-template name="showTable">
                <xsl:with-param name="from" select="$fromVersion"/>
                <xsl:with-param name="to" select="$toVersion"/>
                <xsl:with-param name="category" select="$selectedCategory"/>
            </xsl:call-template>
        </div>


    </xsl:template>


<!--
    <xsl:template match="a[matches(@href,'#!changes')]" mode="ixsl:onclick"
        xpath-default-namespace="">
        <xsl:variable name="elementObj" select="id(@data-value, ixsl:page())"/>
        <xsl:value-of select="ixsl:call($elementObj, 'scrollIntoView')"/>
    </xsl:template>-->

    <xsl:template name="reshowTable">
        <xsl:param name="from" as="xs:string"/>
        <xsl:param name="to" as="xs:string"/>
        <xsl:param name="category" as="xs:string"/>
        <xsl:sequence select="f:set-hash(concat('changes/', $category, '/', $from, '-', $to))"/>
    </xsl:template>

    <xsl:template name="showTable">
        <xsl:param name="from" as="xs:string"/>
        <xsl:param name="to" as="xs:string"/>
        <xsl:param name="category" as="xs:string"/>
        <xsl:variable name="orderedReleases"
            select="reverse($releases[@number gt $from and @number le $to])"/>
        
        <xsl:message>Show table from <xsl:value-of select="$from"/> to <xsl:value-of select="$to"/></xsl:message>
        
        <!--<xsl:variable name="categories" select="ixsl:page()/id('selectedCategory')/@data-category[. != '']"/>-->

        <xsl:choose>
            <xsl:when test="$orderedReleases/ch:category[@name= $category]">
                <xsl:for-each select="$orderedReleases">
                    <h3>Changes <xsl:if test="following-sibling::*">from <xsl:value-of
                        select="following-sibling::*[1]/@number"/></xsl:if> to <xsl:value-of
                            select="@number"/></h3>
                    <xsl:choose>
                        <xsl:when test="./ch:category[@name= $category]/*">
                            <xsl:apply-templates select="./ch:category[@name= $category]/*"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <p>(None.)</p>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each> 
            </xsl:when>
            <xsl:otherwise>
                <h3><emph>No changes in <xsl:value-of select="$category"/> for this range of versions.</emph></h3>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>


    <xsl:template match="select[@id eq 'fromList']" mode="ixsl:onchange" xpath-default-namespace="">
        <xsl:message>dropdown menu for fromList changed</xsl:message>
        <xsl:variable name="from" select="$fromList/option[$fromList/@prop:selectedIndex + 1]"
            as="xs:string"/>
        <xsl:variable name="to" select="$toList/option[$toList/@prop:selectedIndex + 1]"
            as="xs:string"/>
        <xsl:variable name="keepTo"
            select="$from lt $to"/>
        <xsl:variable name="newto"
            select="if ($keepTo) then $to else $releases[@number=$from]/preceding-sibling::*[1]/@number"
            as="xs:string"/>

        <xsl:result-document href="#toList" method="ixsl:replace-content">
            <xsl:for-each select="$releases[@number gt $from]">
                <option>
                    <xsl:if test="@number = $newto">
                        <xsl:attribute name="selected">selected</xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="@number"/>
                </option>
            </xsl:for-each>
        </xsl:result-document>

        <ixsl:schedule-action wait="200">
            <xsl:call-template name="reshowTable">
                <xsl:with-param name="from" select="$from"/>
                <xsl:with-param name="to" select="$newto"/>
                <xsl:with-param name="category" select="$catList/option[$catList/@prop:selectedIndex + 1]/@name"/>
            </xsl:call-template>
        </ixsl:schedule-action>
    </xsl:template>

    <xsl:template match="select[@id eq 'toList']" mode="ixsl:onchange" xpath-default-namespace="">
        <xsl:message>dropdown menu for toList changed</xsl:message>
        <xsl:variable name="from" select="$fromList/option[$fromList/@prop:selectedIndex + 1]"
            as="xs:string"/>
        <xsl:variable name="to" select="$toList/option[$toList/@prop:selectedIndex + 1]"
            as="xs:string"/>

        <ixsl:schedule-action wait="1">
            <xsl:call-template name="reshowTable">
                <xsl:with-param name="from" select="$from"/>
                <xsl:with-param name="to" select="$to"/>
                <xsl:with-param name="category" select="$catList/option[$catList/@prop:selectedIndex + 1]/@name"/>
            </xsl:call-template>
        </ixsl:schedule-action>
    </xsl:template>
    
    <xsl:template match="select[@id eq 'catList']" mode="ixsl:onchange" xpath-default-namespace="">
        <xsl:message>dropdown menu for categoryList changed</xsl:message>
        <xsl:variable name="from" select="$fromList/option[$fromList/@prop:selectedIndex + 1]"
            as="xs:string"/>
        <xsl:variable name="to" select="$toList/option[$toList/@prop:selectedIndex + 1]"
            as="xs:string"/>
        
        <ixsl:schedule-action wait="1">
            <xsl:call-template name="reshowTable">
                <xsl:with-param name="from" select="$from"/>
                <xsl:with-param name="to" select="$to"/>
                <xsl:with-param name="category" select="$catList/option[$catList/@prop:selectedIndex + 1]/@name"/>
            </xsl:call-template>
        </ixsl:schedule-action>
    </xsl:template>



    <xsl:template match="ch:category">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="ch:category//*" priority="3">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="ch:category//ch:*" priority="4">
        <xsl:element name="{local-name()}">
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>


</xsl:stylesheet>
