/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader {
    private HashMap properties = new HashMap();
    private final Element projectElement;
    private final Element parentElement;
    static /* synthetic */ Class class$org$apache$ivy$plugins$parser$m2$PomReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomReader(URL descriptorURL, Resource res) throws IOException, SAXException {
        AddDTDFilterInputStream stream = new AddDTDFilterInputStream(URLHandlerRegistry.getDefault().openStream(descriptorURL));
        try {
            Document pomDomDoc = XMLHelper.parseToDom(stream, res, new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.endsWith("m2-entities.ent")) {
                        return new InputSource((class$org$apache$ivy$plugins$parser$m2$PomReader == null ? (class$org$apache$ivy$plugins$parser$m2$PomReader = PomReader.class$("org.apache.ivy.plugins.parser.m2.PomReader")) : class$org$apache$ivy$plugins$parser$m2$PomReader).getResourceAsStream("m2-entities.ent"));
                    }
                    return null;
                }
            });
            this.projectElement = pomDomDoc.getDocumentElement();
            if (!"project".equals(this.projectElement.getNodeName()) && !"model".equals(this.projectElement.getNodeName())) {
                throw new SAXParseException("project must be the root tag", res.getName(), res.getName(), 0, 0);
            }
            this.parentElement = PomReader.getFirstChildElement(this.projectElement, "parent");
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String prop, String val) {
        if (!this.properties.containsKey(prop) && val != null) {
            this.properties.put(prop, val);
        }
    }

    public String getGroupId() {
        String groupId = PomReader.getFirstChildText(this.projectElement, "groupId");
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.parentElement, "groupId");
        }
        return this.replaceProps(groupId);
    }

    public String getParentGroupId() {
        String groupId = PomReader.getFirstChildText(this.parentElement, "groupId");
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.projectElement, "groupId");
        }
        return this.replaceProps(groupId);
    }

    public String getArtifactId() {
        String val = PomReader.getFirstChildText(this.projectElement, "artifactId");
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, "artifactId");
        }
        return this.replaceProps(val);
    }

    public String getParentArtifactId() {
        String val = PomReader.getFirstChildText(this.parentElement, "artifactId");
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, "artifactId");
        }
        return this.replaceProps(val);
    }

    public String getVersion() {
        String val = PomReader.getFirstChildText(this.projectElement, "version");
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, "version");
        }
        return this.replaceProps(val);
    }

    public String getParentVersion() {
        String val = PomReader.getFirstChildText(this.parentElement, "version");
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, "version");
        }
        return this.replaceProps(val);
    }

    public String getPackaging() {
        String val = PomReader.getFirstChildText(this.projectElement, "packaging");
        if (val == null) {
            val = "jar";
        }
        return val;
    }

    public String getHomePage() {
        String val = PomReader.getFirstChildText(this.projectElement, "url");
        if (val == null) {
            val = "";
        }
        return val;
    }

    public String getDescription() {
        String val = PomReader.getFirstChildText(this.projectElement, "description");
        if (val == null) {
            val = "";
        }
        return val.trim();
    }

    public License[] getLicenses() {
        Element licenses = PomReader.getFirstChildElement(this.projectElement, "licenses");
        if (licenses == null) {
            return new License[0];
        }
        licenses.normalize();
        ArrayList<License> lics = new ArrayList<License>();
        Iterator it = PomReader.getAllChilds(licenses).iterator();
        while (it.hasNext()) {
            Element license = (Element)it.next();
            if (!"license".equals(license.getNodeName())) continue;
            String name = PomReader.getFirstChildText(license, "name");
            String url = PomReader.getFirstChildText(license, "url");
            if (name == null && url == null) continue;
            if (name == null) {
                name = "Unknown License";
            }
            lics.add(new License(name, url));
        }
        return lics.toArray(new License[lics.size()]);
    }

    public ModuleRevisionId getRelocation() {
        Element distrMgt = PomReader.getFirstChildElement(this.projectElement, "distributionManagement");
        Element relocation = PomReader.getFirstChildElement(distrMgt, "relocation");
        if (relocation == null) {
            return null;
        }
        String relocGroupId = PomReader.getFirstChildText(relocation, "groupId");
        String relocArtId = PomReader.getFirstChildText(relocation, "artifactId");
        String relocVersion = PomReader.getFirstChildText(relocation, "version");
        relocGroupId = relocGroupId == null ? this.getGroupId() : relocGroupId;
        relocArtId = relocArtId == null ? this.getArtifactId() : relocArtId;
        relocVersion = relocVersion == null ? this.getVersion() : relocVersion;
        return ModuleRevisionId.newInstance(relocGroupId, relocArtId, relocVersion);
    }

    public List getDependencies() {
        Element dependenciesElement = PomReader.getFirstChildElement(this.projectElement, "dependencies");
        LinkedList<PomDependencyData> dependencies = new LinkedList<PomDependencyData>();
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
                dependencies.add(new PomDependencyData((Element)node));
            }
        }
        return dependencies;
    }

    public List getDependencyMgt() {
        Element dependenciesElement = PomReader.getFirstChildElement(this.projectElement, "dependencyManagement");
        dependenciesElement = PomReader.getFirstChildElement(dependenciesElement, "dependencies");
        LinkedList<PomDependencyMgtElement> dependencies = new LinkedList<PomDependencyMgtElement>();
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
                dependencies.add(new PomDependencyMgtElement((Element)node));
            }
        }
        return dependencies;
    }

    public List getPlugins() {
        LinkedList<PomPluginElement> plugins = new LinkedList<PomPluginElement>();
        Element buildElement = PomReader.getFirstChildElement(this.projectElement, "build");
        if (buildElement == null) {
            return plugins;
        }
        Element pluginsElement = PomReader.getFirstChildElement(buildElement, "plugins");
        if (pluginsElement != null) {
            NodeList childs = pluginsElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !"plugin".equals(node.getNodeName())) continue;
                plugins.add(new PomPluginElement((Element)node));
            }
        }
        return plugins;
    }

    public Map getPomProperties() {
        HashMap<String, String> pomProperties = new HashMap<String, String>();
        Element propsEl = PomReader.getFirstChildElement(this.projectElement, "properties");
        if (propsEl != null) {
            propsEl.normalize();
        }
        Iterator it = PomReader.getAllChilds(propsEl).iterator();
        while (it.hasNext()) {
            Element prop = (Element)it.next();
            pomProperties.put(prop.getNodeName(), PomReader.getTextContent(prop));
        }
        return pomProperties;
    }

    private String replaceProps(String val) {
        if (val == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(val, this.properties).trim();
    }

    private static String getTextContent(Element element) {
        StringBuffer result = new StringBuffer();
        NodeList childNodes = element.getChildNodes();
        block3: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    result.append(child.getNodeValue());
                    continue block3;
                }
            }
        }
        return result.toString();
    }

    private static String getFirstChildText(Element parentElem, String name) {
        Element node = PomReader.getFirstChildElement(parentElem, name);
        if (node != null) {
            return PomReader.getTextContent(node);
        }
        return null;
    }

    private static Element getFirstChildElement(Element parentElem, String name) {
        if (parentElem == null) {
            return null;
        }
        NodeList childs = parentElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element) || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List getAllChilds(Element parent) {
        LinkedList<Node> r = new LinkedList<Node>();
        if (parent != null) {
            NodeList childs = parent.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element)) continue;
                r.add(node);
            }
        }
        return r;
    }

    private static final class AddDTDFilterInputStream
    extends FilterInputStream {
        private int count;
        private byte[] prefix = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n".getBytes();

        private AddDTDFilterInputStream(InputStream in) throws IOException {
            super(new BufferedInputStream(in));
            String trimmed;
            this.in.mark(10000);
            int byte1 = this.in.read();
            int byte2 = this.in.read();
            int byte3 = this.in.read();
            if (byte1 == 239 && byte2 == 187 && byte3 == 191) {
                this.in.mark(10000);
            } else {
                this.in.reset();
            }
            int bytesToSkip = 0;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.in, "UTF-8"), 100);
            String firstLine = reader.readLine();
            if (firstLine != null && (trimmed = firstLine.trim()).startsWith("<?xml ")) {
                int endIndex = trimmed.indexOf("?>");
                String xmlDecl = trimmed.substring(0, endIndex + 2);
                this.prefix = (xmlDecl + "\n" + "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n").getBytes();
                bytesToSkip = xmlDecl.getBytes().length;
            }
            this.in.reset();
            for (int i = 0; i < bytesToSkip; ++i) {
                this.in.read();
            }
        }

        public int read() throws IOException {
            if (this.count < this.prefix.length) {
                return this.prefix[this.count++];
            }
            int result = super.read();
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int nbrBytesCopied = 0;
            if (this.count < this.prefix.length) {
                int nbrBytesFromPrefix = Math.min(this.prefix.length - this.count, len);
                System.arraycopy(this.prefix, this.count, b, off, nbrBytesFromPrefix);
                nbrBytesCopied = nbrBytesFromPrefix;
            }
            if (nbrBytesCopied < len) {
                nbrBytesCopied += this.in.read(b, off + nbrBytesCopied, len - nbrBytesCopied);
            }
            this.count += nbrBytesCopied;
            return nbrBytesCopied;
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        PomDependencyData(Element depElement) {
            super(depElement);
            this.depElement = depElement;
        }

        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, "scope");
            return PomReader.this.replaceProps(val);
        }

        public String getClassifier() {
            String val = PomReader.getFirstChildText(this.depElement, "classifier");
            return PomReader.this.replaceProps(val);
        }

        public String getType() {
            String val = PomReader.getFirstChildText(this.depElement, "type");
            return PomReader.this.replaceProps(val);
        }

        public boolean isOptional() {
            Element e = PomReader.getFirstChildElement(this.depElement, "optional");
            return e != null && "true".equalsIgnoreCase(PomReader.getTextContent(e));
        }
    }

    public class PomPluginElement
    implements PomDependencyMgt {
        private Element pluginElement;

        PomPluginElement(Element pluginElement) {
            this.pluginElement = pluginElement;
        }

        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.pluginElement, "groupId");
            return PomReader.this.replaceProps(val);
        }

        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.pluginElement, "artifactId");
            return PomReader.this.replaceProps(val);
        }

        public String getVersion() {
            String val = PomReader.getFirstChildText(this.pluginElement, "version");
            return PomReader.this.replaceProps(val);
        }

        public String getScope() {
            return null;
        }

        public List getExcludedModules() {
            return Collections.EMPTY_LIST;
        }
    }

    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        PomDependencyMgtElement(Element depElement) {
            this.depElement = depElement;
        }

        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.depElement, "groupId");
            return PomReader.this.replaceProps(val);
        }

        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.depElement, "artifactId");
            return PomReader.this.replaceProps(val);
        }

        public String getVersion() {
            String val = PomReader.getFirstChildText(this.depElement, "version");
            return PomReader.this.replaceProps(val);
        }

        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, "scope");
            return PomReader.this.replaceProps(val);
        }

        public List getExcludedModules() {
            Element exclusionsElement = PomReader.getFirstChildElement(this.depElement, "exclusions");
            LinkedList<ModuleId> exclusions = new LinkedList<ModuleId>();
            if (exclusionsElement != null) {
                NodeList childs = exclusionsElement.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    if (!(node instanceof Element) || !"exclusion".equals(node.getNodeName())) continue;
                    String groupId = PomReader.getFirstChildText((Element)node, "groupId");
                    String artifactId = PomReader.getFirstChildText((Element)node, "artifactId");
                    if (groupId == null || artifactId == null) continue;
                    exclusions.add(ModuleId.newInstance(groupId, artifactId));
                }
            }
            return exclusions;
        }
    }
}

