/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.RelativeUrlResolver;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.AbstractSeq;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range$;
import scala.collection.immutable.Range$Inclusive;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public class Range
extends AbstractSeq
implements Serializable,
IndexedSeq {
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    private final int numRangeElements;
    private final int lastElement;
    private final int terminalElement;

    @Override
    public final GenericCompanion companion() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public final IndexedSeq toIndexedSeq$60308d43() {
        return this;
    }

    @Override
    public int hashCode() {
        return RelativeUrlResolver.hashCode(this);
    }

    @Override
    public final Iterator iterator() {
        return RelativeUrlResolver.iterator(this);
    }

    @Override
    public final Seq toBuffer$4f3739ab() {
        return RelativeUrlResolver.toBuffer$1e811be1(this);
    }

    private long gap() {
        return (long)this.end - (long)this.start;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    private int last() {
        if (this.isEmpty) {
            return LogOptions.unboxToInt(Nil$.MODULE$.last());
        }
        return this.lastElement;
    }

    public Range copy(int n, int n2, int n3) {
        return new Range(n, n2, n3);
    }

    public boolean isInclusive() {
        return false;
    }

    @Override
    public final int size() {
        return this.length();
    }

    @Override
    public int length() {
        if (this.numRangeElements < 0) {
            throw this.fail();
        }
        return this.numRangeElements;
    }

    private Nothing$ fail() {
        Range range = this;
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringOps("%d %s %d by %s").format$6adc1fb3(Predef$.genericWrapArray(new Object[]{range.start, range.isInclusive() ? "to" : "until", range.end, range.step}))).append((Object)": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    private void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.numRangeElements < 0) {
            throw this.fail();
        }
    }

    @Override
    public final void foreach(Function1 function1) {
        boolean bl;
        Function1 function12 = function1;
        Range range = this;
        range.scala$collection$immutable$Range$$validateMaxLength();
        if (range.start != Integer.MIN_VALUE || range.end != Integer.MIN_VALUE) {
            bl = true;
        } else {
            int n = 0;
            int n2 = range.start;
            while (n < range.numRangeElements) {
                function12.apply(n2);
                ++n;
                n2 += range.step;
            }
            bl = false;
        }
        if (bl) {
            int n = this.terminalElement;
            int n3 = this.step;
            for (int i = this.start; i != n; i += n3) {
                function1.apply(i);
            }
        }
    }

    @Override
    private Range take(int n) {
        if (n <= 0 || this.isEmpty) {
            return this.newEmptyRange(this.start);
        }
        if (n >= this.numRangeElements) {
            return this;
        }
        return new Range$Inclusive(this.start, this.locationAfterN(n - 1), this.step);
    }

    private Range drop(int n) {
        if (this.isEmpty) {
            return this;
        }
        if (1 >= this.numRangeElements) {
            return this.newEmptyRange(this.end);
        }
        return this.copy(this.locationAfterN(1), this.end, this.step);
    }

    private int locationAfterN(int n) {
        return this.start + this.step * n;
    }

    private Range newEmptyRange(int n) {
        return new Range(n, n, this.step);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof Range) {
            Range range = (Range)object;
            Range range2 = this;
            Range range3 = range;
            bl = this.length() == range.length() && (this.isEmpty || this.start == range.start && this.last() == range.last());
        } else {
            bl = RelativeUrlResolver.equals(this, object);
        }
        return bl;
    }

    @Override
    public String toString() {
        String string = this.numRangeElements > Range$.MODULE$.MAX_PRINT() ? ", ... )" : ")";
        return this.take(Range$.MODULE$.MAX_PRINT()).mkString("Range(", ", ", string);
    }

    @Override
    public final int apply$mcII$sp(int n) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        if (n < 0 || n >= this.numRangeElements) {
            throw new IndexOutOfBoundsException(((Object)n).toString());
        }
        return this.start + this.step * n;
    }

    @Override
    public final /* synthetic */ Object reverse() {
        Range range = this;
        if (range.isEmpty) {
            return range;
        }
        return new Range$Inclusive(range.last(), range.start, -range.step);
    }

    @Override
    public final /* synthetic */ Object tail() {
        Range range;
        block0: {
            range = this;
            if (!range.isEmpty) break block0;
            Nil$.MODULE$.tail();
        }
        return range.drop(1);
    }

    @Override
    public final /* synthetic */ Object drop$54cf32c4() {
        return this.drop(1);
    }

    @Override
    public final /* synthetic */ Object apply(Object object) {
        int n = LogOptions.unboxToInt(object);
        return this.apply$mcII$sp(n);
    }

    @Override
    public final /* synthetic */ Object apply(int n) {
        return this.apply$mcII$sp(n);
    }

    @Override
    public final /* synthetic */ Object last() {
        return this.last();
    }

    public Range(int n, int n2, int n3) {
        int n4;
        this.start = n;
        this.end = n2;
        this.step = n3;
        boolean bl = this.isEmpty = n > n2 && n3 > 0 || n < n2 && n3 < 0 || n == n2 && !this.isInclusive();
        if (n3 == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (this.isEmpty) {
            n4 = 0;
        } else {
            Range range;
            Range range2;
            Range range3 = this;
            long l = range3.gap() / (long)range3.step + (long)((range2 = range3).isInclusive() || !((range = range2).gap() % (long)range.step == 0L) ? 1 : 0);
            n4 = l > Integer.MAX_VALUE ? -1 : (int)l;
        }
        this.numRangeElements = n4;
        this.lastElement = n + (this.numRangeElements - 1) * n3;
        this.terminalElement = n + this.numRangeElements * n3;
    }
}

