/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

class IRFactory {
    private Parser parser;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(118);
    }

    void initScript(ScriptOrFnNode scriptNode, Object body) {
        Node children = ((Node)body).getFirstChild();
        if (children != null) {
            scriptNode.addChildrenToBack(children);
        }
    }

    Object createLeaf(int nodeType) {
        return new Node(nodeType);
    }

    Object createLeaf(int nodeType, int nodeOp) {
        return new Node(nodeType, nodeOp);
    }

    Object createSwitch(int lineno) {
        return new Node.Jump(92, lineno);
    }

    Object createVariables(int lineno) {
        return new Node(100, lineno);
    }

    Object createExprStatement(Object expr, int lineno) {
        return new Node(113, (Node)expr, lineno);
    }

    Object createExprStatementNoReturn(Object expr, int lineno) {
        return new Node(51, (Node)expr, lineno);
    }

    Object createName(String name) {
        return Node.newString(39, name);
    }

    Object createString(String string) {
        return Node.newString(string);
    }

    Object createNumber(double number) {
        return Node.newNumber(number);
    }

    Object createCatch(String varName, Object catchCond, Object stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new Node(106);
        }
        return new Node(102, (Node)this.createName(varName), (Node)catchCond, (Node)stmts, lineno);
    }

    Object createThrow(Object expr, int lineno) {
        return new Node(53, (Node)expr, lineno);
    }

    Object createReturn(Object expr, int lineno) {
        return expr == null ? new Node(5, lineno) : new Node(5, (Node)expr, lineno);
    }

    Object createLabel(String label, int lineno) {
        Node.Jump n = new Node.Jump(110, lineno);
        n.setLabel(label);
        return n;
    }

    Object createBreak(String label, int lineno) {
        Node.Jump n = new Node.Jump(98, lineno);
        if (label != null) {
            n.setLabel(label);
        }
        return n;
    }

    Object createContinue(String label, int lineno) {
        Node.Jump n = new Node.Jump(99, lineno);
        if (label != null) {
            n.setLabel(label);
        }
        return n;
    }

    Object createBlock(int lineno) {
        return new Node(107, lineno);
    }

    FunctionNode createFunction(String name) {
        return new FunctionNode(name);
    }

    Object initFunction(FunctionNode fnNode, int functionIndex, Object statements, int functionType) {
        Node lastStmt;
        String name;
        Node stmts = (Node)statements;
        fnNode.setFunctionType(functionType);
        fnNode.addChildToBack(stmts);
        int functionCount = fnNode.getFunctionCount();
        if (functionCount != 0) {
            fnNode.setRequiresActivation(true);
            int i = 0;
            while (i != functionCount) {
                String name2;
                FunctionNode fn = fnNode.getFunctionNode(i);
                if (fn.getFunctionType() == 3 && (name2 = fn.getFunctionName()) != null && name2.length() != 0) {
                    fnNode.removeParamOrVar(name2);
                }
                ++i;
            }
        }
        if (functionType == 2 && (name = fnNode.getFunctionName()) != null && name.length() != 0 && !fnNode.hasParamOrVar(name)) {
            fnNode.addVar(name);
            Node setFn = new Node(51, new Node(60, Node.newString(name), new Node(66)));
            stmts.addChildrenToFront(setFn);
        }
        if ((lastStmt = stmts.getLastChild()) == null || lastStmt.getType() != 5) {
            stmts.addChildToBack(new Node(5));
        }
        Node result = Node.newString(87, fnNode.getFunctionName());
        result.putIntProp(1, functionIndex);
        return result;
    }

    void addChildToBack(Object parent, Object child) {
        ((Node)parent).addChildToBack((Node)child);
    }

    Object createWhile(Object cond, Object body, int lineno) {
        return this.createLoop(1, (Node)body, (Node)cond, null, null, lineno);
    }

    Object createDoWhile(Object body, Object cond, int lineno) {
        return this.createLoop(0, (Node)body, (Node)cond, null, null, lineno);
    }

    Object createFor(Object init, Object test, Object incr, Object body, int lineno) {
        return this.createLoop(2, (Node)body, (Node)test, (Node)init, (Node)incr, lineno);
    }

    private Node createLoop(int loopType, Node body, Node cond, Node init, Node incr, int lineno) {
        Node.Target bodyTarget = new Node.Target();
        Node.Target condTarget = new Node.Target();
        if (loopType == 2 && cond.getType() == 106) {
            cond = new Node(47);
        }
        Node.Jump IFEQ = new Node.Jump(7, cond);
        IFEQ.target = bodyTarget;
        Node.Target breakTarget = new Node.Target();
        Node.Jump result = new Node.Jump(112, lineno);
        result.addChildToBack(bodyTarget);
        result.addChildrenToBack(body);
        if (loopType == 1 || loopType == 2) {
            result.addChildrenToBack(new Node(106, lineno));
        }
        result.addChildToBack(condTarget);
        result.addChildToBack(IFEQ);
        result.addChildToBack(breakTarget);
        result.target = breakTarget;
        Node.Target continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            Node.Jump GOTO = new Node.Jump(6);
            GOTO.target = condTarget;
            result.addChildToFront(GOTO);
            if (loopType == 2) {
                if (init.getType() != 106) {
                    if (init.getType() != 100) {
                        init = new Node(51, init);
                    }
                    result.addChildToFront(init);
                }
                Node.Target incrTarget = new Node.Target();
                result.addChildAfter(incrTarget, body);
                if (incr.getType() != 106) {
                    incr = (Node)this.createUnary(51, incr);
                    result.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        result.setContinue(continueTarget);
        return result;
    }

    Object createForIn(Object lhs, Object obj, Object body, int lineno) {
        Node lhsNode = (Node)lhs;
        Node objNode = (Node)obj;
        int type = lhsNode.getType();
        Node lvalue = lhsNode;
        switch (type) {
            case 34: 
            case 36: 
            case 39: {
                break;
            }
            case 100: {
                Node lastChild = lhsNode.getLastChild();
                if (lhsNode.getFirstChild() != lastChild) {
                    this.parser.reportError("msg.mult.index");
                }
                lvalue = Node.newString(39, lastChild.getString());
                break;
            }
            default: {
                this.parser.reportError("msg.bad.for.in.lhs");
                return objNode;
            }
        }
        Node localBlock = new Node(124);
        Node init = new Node(63, objNode);
        init.putProp(4, localBlock);
        Node cond = new Node(64);
        cond.putProp(4, localBlock);
        Node id = new Node(65);
        id.putProp(4, localBlock);
        Node newBody = new Node(107);
        Node assign = (Node)this.createAssignment(lvalue, id);
        newBody.addChildToBack(new Node(51, assign));
        newBody.addChildToBack((Node)body);
        Node loop = (Node)this.createWhile(cond, newBody, lineno);
        loop.addChildToFront(init);
        if (type == 100) {
            loop.addChildToFront(lhsNode);
        }
        localBlock.addChildToBack(loop);
        return localBlock;
    }

    Object createTryCatchFinally(Object tryblock, Object catchblocks, Object finallyblock, int lineno) {
        Node trynode = (Node)tryblock;
        boolean hasFinally = false;
        Node finallyNode = null;
        if (finallyblock != null) {
            finallyNode = (Node)finallyblock;
            boolean bl = hasFinally = finallyNode.getType() != 107 || finallyNode.hasChildren();
        }
        if (trynode.getType() == 107 && !trynode.hasChildren() && !hasFinally) {
            return trynode;
        }
        Node catchNodes = (Node)catchblocks;
        boolean hasCatch = catchNodes.hasChildren();
        if (!hasFinally && !hasCatch) {
            return trynode;
        }
        Node localBlock = new Node(124);
        Node.Jump pn = new Node.Jump(69, trynode, lineno);
        pn.putProp(4, localBlock);
        Node.Target finallyTarget = null;
        if (hasFinally) {
            finallyTarget = new Node.Target();
            pn.setFinally(finallyTarget);
            Node.Jump jsrFinally = new Node.Jump(115);
            jsrFinally.target = finallyTarget;
            pn.addChildToBack(jsrFinally);
        }
        Node.Target endTarget = new Node.Target();
        Node.Jump GOTOToEnd = new Node.Jump(6);
        GOTOToEnd.target = endTarget;
        pn.addChildToBack(GOTOToEnd);
        if (hasCatch) {
            Node.Target catchTarget;
            pn.target = catchTarget = new Node.Target();
            pn.addChildToBack(catchTarget);
            Node.Target endCatch = new Node.Target();
            Node cb = catchNodes.getFirstChild();
            boolean hasDefault = false;
            while (cb != null) {
                Node condStmt;
                int catchLineNo = cb.getLineno();
                Node name = cb.getFirstChild();
                Node cond = name.getNext();
                Node catchBlock = cond.getNext();
                cb.removeChild(name);
                cb.removeChild(cond);
                cb.removeChild(catchBlock);
                catchBlock.addChildToBack(new Node(4));
                Node.Jump GOTOToEndCatch = new Node.Jump(6);
                GOTOToEndCatch.target = endCatch;
                catchBlock.addChildToBack(GOTOToEndCatch);
                if (cond.getType() == 106) {
                    condStmt = catchBlock;
                    hasDefault = true;
                } else {
                    condStmt = (Node)this.createIf(cond, catchBlock, null, catchLineNo);
                }
                Node catchScope = Node.newString(62, name.getString());
                catchScope.addChildToBack(this.createUseLocal(localBlock));
                Node withStmt = (Node)this.createWith(catchScope, condStmt, catchLineNo);
                pn.addChildToBack(withStmt);
                cb = cb.getNext();
            }
            if (!hasDefault) {
                Node rethrow = new Node(53, this.createUseLocal(localBlock));
                pn.addChildToBack(rethrow);
            }
            pn.addChildToBack(endCatch);
            if (hasFinally) {
                Node.Jump jsrFinally = new Node.Jump(115);
                jsrFinally.target = finallyTarget;
                pn.addChildToBack(jsrFinally);
                Node.Jump GOTO = new Node.Jump(6);
                GOTO.target = endTarget;
                pn.addChildToBack(GOTO);
            }
        }
        if (hasFinally) {
            pn.addChildToBack(finallyTarget);
            Node fBlock = new Node(103, finallyNode);
            fBlock.putProp(4, localBlock);
            pn.addChildToBack(fBlock);
        }
        pn.addChildToBack(endTarget);
        localBlock.addChildToBack(pn);
        return localBlock;
    }

    Object createWith(Object obj, Object body, int lineno) {
        Node result = new Node(107, lineno);
        result.addChildToBack(new Node(3, (Node)obj));
        Node bodyNode = new Node(101, (Node)body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(4));
        return result;
    }

    Object createArrayLiteral(Object obj) {
        Node array = new Node(31, Node.newString(39, "Array"));
        Node list = new Node(123, array);
        Node elem = null;
        int i = 0;
        Node cursor = ((Node)obj).getFirstChild();
        while (cursor != null) {
            elem = cursor;
            cursor = cursor.getNext();
            if (elem.getType() == 61) {
                ++i;
                continue;
            }
            Node addelem = new Node(37, new Node(120), Node.newNumber(i), elem);
            ++i;
            list.addChildToBack(addelem);
        }
        if (this.parser.compilerEnv.languageVersion == 120) {
            if (elem != null && elem.getType() == 61) {
                Node setlength = new Node(35, new Node(120), Node.newString("length"), Node.newNumber(i));
                list.addChildToBack(setlength);
            }
        } else {
            array.addChildToBack(Node.newNumber(i));
        }
        return list;
    }

    Object createObjectLiteral(Object obj) {
        Node result = new Node(31, Node.newString(39, "Object"));
        Node list = new Node(123, result);
        Node cursor = ((Node)obj).getFirstChild();
        while (cursor != null) {
            Node n = cursor;
            cursor = cursor.getNext();
            int op = n.getType() == 39 ? 35 : 37;
            Node next = cursor;
            cursor = cursor.getNext();
            Node addelem = new Node(op, new Node(120), n, next);
            list.addChildToBack(addelem);
        }
        return list;
    }

    Object createRegExp(int regexpIndex) {
        Node n = new Node(50);
        n.putIntProp(7, regexpIndex);
        return n;
    }

    Object createIf(Object condObj, Object ifTrue, Object ifFalse, int lineno) {
        Node cond = (Node)condObj;
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            if (ifFalse != null) {
                return ifFalse;
            }
            return new Node(107, lineno);
        }
        Node result = new Node(107, lineno);
        Node.Target ifNotTarget = new Node.Target();
        Node.Jump IFNE = new Node.Jump(8, cond);
        IFNE.target = ifNotTarget;
        result.addChildToBack(IFNE);
        result.addChildrenToBack((Node)ifTrue);
        if (ifFalse != null) {
            Node.Target endTarget;
            Node.Jump GOTOToEnd = new Node.Jump(6);
            GOTOToEnd.target = endTarget = new Node.Target();
            result.addChildToBack(GOTOToEnd);
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack((Node)ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    Object createCondExpr(Object condObj, Object ifTrue, Object ifFalse) {
        Node cond = (Node)condObj;
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            return ifFalse;
        }
        return new Node(80, cond, (Node)ifTrue, (Node)ifFalse);
    }

    Object createUnary(int nodeType, Object child) {
        Node childNode = (Node)child;
        int childType = childNode.getType();
        switch (nodeType) {
            case 32: {
                Node right;
                Node left;
                if (childType == 39) {
                    childNode.setType(52);
                    left = childNode;
                    right = Node.newString(childNode.getString());
                } else if (childType == 34 || childType == 36) {
                    left = childNode.getFirstChild();
                    right = childNode.getLastChild();
                    childNode.removeChild(left);
                    childNode.removeChild(right);
                } else {
                    return new Node(47);
                }
                return new Node(nodeType, left, right);
            }
            case 33: {
                if (childType != 39) break;
                childNode.setType(119);
                return childNode;
            }
            case 28: {
                if (childType != 40) break;
                int value = ScriptRuntime.toInt32(childNode.getDouble());
                childNode.setDouble(~value);
                return childNode;
            }
            case 30: {
                if (childType != 40) break;
                childNode.setDouble(-childNode.getDouble());
                return childNode;
            }
            case 27: {
                int status = IRFactory.isAlwaysDefinedBoolean(childNode);
                if (status == 0) break;
                int type = status == 1 ? 46 : 47;
                if (childType == 47 || childType == 46) {
                    childNode.setType(type);
                    return childNode;
                }
                return new Node(type);
            }
        }
        return new Node(nodeType, childNode);
    }

    Object createIncDec(int nodeType, boolean post, Object child) {
        Node childNode = (Node)child;
        int childType = childNode.getType();
        if (childType == 39) {
            if (post) {
                return new Node(nodeType, childNode);
            }
            Node rhs = (Node)this.createNumber(1.0);
            String s = childNode.getString();
            Node opLeft = Node.newString(39, s);
            opLeft = new Node(29, opLeft);
            int opType = nodeType == 84 ? 22 : 23;
            Node op = new Node(opType, opLeft, rhs);
            Node lvalueLeft = Node.newString(52, s);
            return new Node(9, lvalueLeft, op);
        }
        if (childType == 34 || childType == 36) {
            if (post) {
                return new Node(nodeType, childNode);
            }
            Node rhs = (Node)this.createNumber(1.0);
            return this.createAssignmentOp(nodeType == 84 ? 22 : 23, childNode, rhs, true);
        }
        this.parser.reportError("msg.bad.lhs.assign");
        return child;
    }

    Object createBinary(int nodeType, Object leftObj, Object rightObj) {
        Node left = (Node)leftObj;
        Node right = (Node)rightObj;
        switch (nodeType) {
            case 86: {
                nodeType = 34;
                right.setType(41);
                String id = right.getString();
                int idlength = id.length();
                int special = 0;
                if (idlength == 9) {
                    if (id.equals("__proto__")) {
                        special = 1;
                    }
                } else if (idlength == 10 && id.equals("__parent__")) {
                    special = 2;
                }
                if (special == 0) break;
                Node result = new Node(nodeType, left);
                result.putIntProp(11, special);
                return result;
            }
            case 71: {
                nodeType = 36;
                break;
            }
            case 22: {
                if (left.type == 41) {
                    String s2;
                    if (right.type == 41) {
                        s2 = right.getString();
                    } else {
                        if (right.type != 40) break;
                        s2 = ScriptRuntime.numberToString(right.getDouble(), 10);
                    }
                    String s1 = left.getString();
                    left.setString(s1.concat(s2));
                    return left;
                }
                if (left.type != 40) break;
                if (right.type == 40) {
                    left.setDouble(left.getDouble() + right.getDouble());
                    return left;
                }
                if (right.type != 41) break;
                String s1 = ScriptRuntime.numberToString(left.getDouble(), 10);
                String s2 = right.getString();
                right.setString(s1.concat(s2));
                return right;
            }
            case 23: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld - right.getDouble());
                        return left;
                    }
                    if (ld != 0.0) break;
                    return new Node(30, right);
                }
                if (right.type != 40 || right.getDouble() != 0.0) break;
                return new Node(29, left);
            }
            case 24: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld * right.getDouble());
                        return left;
                    }
                    if (ld != 1.0) break;
                    return new Node(29, right);
                }
                if (right.type != 40 || right.getDouble() != 1.0) break;
                return new Node(29, left);
            }
            case 25: {
                if (right.type != 40) break;
                double rd = right.getDouble();
                if (left.type == 40) {
                    left.setDouble(left.getDouble() / rd);
                    return left;
                }
                if (rd != 1.0) break;
                return new Node(29, left);
            }
            case 83: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == -1) {
                    return new Node(46);
                }
                if (leftStatus == 1) {
                    return right;
                }
                int rightStatus = IRFactory.isAlwaysDefinedBoolean(right);
                if (rightStatus == -1) {
                    if (IRFactory.hasSideEffects(left)) break;
                    return new Node(46);
                }
                if (rightStatus != 1) break;
                return left;
            }
            case 82: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == 1) {
                    return new Node(47);
                }
                if (leftStatus == -1) {
                    return right;
                }
                int rightStatus = IRFactory.isAlwaysDefinedBoolean(right);
                if (rightStatus == 1) {
                    if (IRFactory.hasSideEffects(left)) break;
                    return new Node(47);
                }
                if (rightStatus != -1) break;
                return left;
            }
        }
        return new Node(nodeType, left, right);
    }

    Object createAssignment(Object leftObj, Object rightObj) {
        Node left = (Node)leftObj;
        Node right = (Node)rightObj;
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                left.setType(52);
                return new Node(9, left, right);
            }
            case 34: 
            case 36: {
                int type;
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                if (nodeType == 34) {
                    type = 35;
                    int special = left.getIntProp(11, 0);
                    if (special != 0) {
                        Node result = new Node(35, obj, right);
                        result.putIntProp(11, special);
                        return result;
                    }
                } else {
                    type = 37;
                }
                return new Node(type, obj, id, right);
            }
        }
        this.parser.reportError("msg.bad.lhs.assign");
        return left;
    }

    Object createAssignmentOp(int assignOp, Object left, Object right) {
        return this.createAssignmentOp(assignOp, (Node)left, (Node)right, false);
    }

    private Node createAssignmentOp(int assignOp, Node left, Node right, boolean tonumber) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                String s = left.getString();
                Node opLeft = Node.newString(39, s);
                if (tonumber) {
                    opLeft = new Node(29, opLeft);
                }
                Node op = new Node(assignOp, opLeft, right);
                Node lvalueLeft = Node.newString(52, s);
                return new Node(9, lvalueLeft, op);
            }
            case 34: 
            case 36: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 34 ? 121 : 122;
                Node opLeft = new Node(120);
                if (tonumber) {
                    opLeft = new Node(29, opLeft);
                }
                Node op = new Node(assignOp, opLeft, right);
                return new Node(type, obj, id, op);
            }
        }
        this.parser.reportError("msg.bad.lhs.assign");
        return left;
    }

    Node createUseLocal(Node localBlock) {
        if (124 != localBlock.getType()) {
            Kit.codeBug();
        }
        Node result = new Node(57);
        result.putProp(4, localBlock);
        return result;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 44: 
            case 46: 
            case 61: {
                return -1;
            }
            case 47: {
                return 1;
            }
            case 40: {
                double num = node.getDouble();
                if (num == num && num != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private static boolean hasSideEffects(Node exprTree) {
        switch (exprTree.getType()) {
            case 9: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 84: 
            case 85: {
                return true;
            }
        }
        Node child = exprTree.getFirstChild();
        while (child != null) {
            if (IRFactory.hasSideEffects(child)) {
                return true;
            }
            child = child.getNext();
        }
        return false;
    }
}

