/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterFunctions;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ImporterTopLevel
extends ScriptableObject {
    private ObjArray importedPackages = new ObjArray();

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context cx) {
        this(cx, false);
    }

    public ImporterTopLevel(Context cx, boolean sealed) {
        this.initStandardObjects(cx, sealed);
    }

    public String getClassName() {
        return "global";
    }

    public void initStandardObjects(Context cx, boolean sealed) {
        cx.initStandardObjects(this, sealed);
        ImporterFunctions.setup(this);
    }

    public boolean has(String name, Scriptable start) {
        return super.has(name, start) || this.getPackageProperty(name, start) != Scriptable.NOT_FOUND;
    }

    public Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (result != Scriptable.NOT_FOUND) {
            return result;
        }
        result = this.getPackageProperty(name, start);
        return result;
    }

    private Object getPackageProperty(String name, Scriptable start) {
        Object[] elements;
        Object result = Scriptable.NOT_FOUND;
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            elements = this.importedPackages.toArray();
        }
        int i = 0;
        while (i < elements.length) {
            NativeJavaPackage p = (NativeJavaPackage)elements[i];
            Object v = p.getPkgProperty(name, start, false);
            if (v != null && !(v instanceof NativeJavaPackage)) {
                if (result == Scriptable.NOT_FOUND) {
                    result = v;
                } else {
                    throw Context.reportRuntimeError2("msg.ambig.import", result.toString(), v.toString());
                }
            }
            ++i;
        }
        return result;
    }

    void importClass(Context cx, Scriptable thisObj, Object[] args) {
        int i = 0;
        while (i < args.length) {
            Object cl = args[i];
            if (!(cl instanceof NativeJavaClass)) {
                throw Context.reportRuntimeError1("msg.not.class", Context.toString(cl));
            }
            String s = ((NativeJavaClass)cl).getClassObject().getName();
            String n = s.substring(s.lastIndexOf(46) + 1);
            Object val = thisObj.get(n, thisObj);
            if (val != Scriptable.NOT_FOUND && val != cl) {
                throw Context.reportRuntimeError1("msg.prop.defined", n);
            }
            thisObj.put(n, thisObj, cl);
            ++i;
        }
    }

    public void importPackage(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        this.importPackage(cx, thisObj, args);
    }

    void importPackage(Context cx, Scriptable thisObj, Object[] args) {
        int i = 0;
        while (i != args.length) {
            Object pkg = args[i];
            if (!(pkg instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeError1("msg.not.pkg", Context.toString(pkg));
            }
            ObjArray objArray = this.importedPackages;
            synchronized (objArray) {
                int j = 0;
                while (j != this.importedPackages.size()) {
                    if (pkg == this.importedPackages.get(j)) {
                        pkg = null;
                        break;
                    }
                    ++j;
                }
                if (pkg != null) {
                    this.importedPackages.add(pkg);
                }
            }
            ++i;
        }
    }
}

