/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

final class OptFunctionNode {
    FunctionNode fnode;
    private OptLocalVariable[] optVars;
    private int directTargetIndex = -1;
    private boolean itsParameterNumberContext;
    boolean itsContainsCalls0;
    boolean itsContainsCalls1;

    OptFunctionNode(FunctionNode fnode) {
        this.fnode = fnode;
        int N = fnode.getParamAndVarCount();
        int parameterCount = fnode.getParamCount();
        this.optVars = new OptLocalVariable[N];
        int i = 0;
        while (i != N) {
            String name = fnode.getParamOrVarName(i);
            this.optVars[i] = new OptLocalVariable(name, i < parameterCount);
            ++i;
        }
        fnode.setCompilerData(this);
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFn, int i) {
        FunctionNode fnode = scriptOrFn.getFunctionNode(i);
        return (OptFunctionNode)fnode.getCompilerData();
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFn) {
        return (OptFunctionNode)scriptOrFn.getCompilerData();
    }

    boolean isTargetOfDirectCall() {
        return this.directTargetIndex >= 0;
    }

    int getDirectTargetIndex() {
        return this.directTargetIndex;
    }

    void setDirectTargetIndex(int directTargetIndex) {
        if (directTargetIndex < 0 || this.directTargetIndex >= 0) {
            Kit.codeBug();
        }
        this.directTargetIndex = directTargetIndex;
    }

    void setParameterNumberContext(boolean b) {
        this.itsParameterNumberContext = b;
    }

    boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    int getVarCount() {
        return this.optVars.length;
    }

    OptLocalVariable getVar(int index) {
        return this.optVars[index];
    }

    OptLocalVariable getVar(String name) {
        int index = this.fnode.getParamOrVarIndex(name);
        if (index < 0) {
            return null;
        }
        return this.optVars[index];
    }

    void establishVarsIndices() {
        int N = this.optVars.length;
        int i = 0;
        while (i != N) {
            this.optVars[i].setIndex(i);
            ++i;
        }
    }

    OptLocalVariable[] getVarsArray() {
        return this.optVars;
    }
}

