/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.interceptor.DefaultMBeanServerInterceptor;
import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.ClassLoaderRepositorySupport;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MBeanInstantiatorImpl;
import com.sun.jmx.mbeanserver.MBeanServerDelegateImpl;
import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.mbeanserver.MetaDataImpl;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.RepositorySupport;
import com.sun.jmx.mbeanserver.SecureClassLoaderRepository;
import com.sun.jmx.mbeanserver.SunJmxMBeanServer;
import com.sun.jmx.trace.Trace;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;

public final class JmxMBeanServer
implements SunJmxMBeanServer {
    private final String dbgTag = "MBeanServer";
    private final MBeanInstantiator instantiator;
    private final SecureClassLoaderRepository secureClr;
    private final MetaData meta;
    private final boolean interceptorsEnabled;
    private final transient MBeanServer outerShell;
    private transient MBeanServerInterceptor mbsInterceptor = null;
    private final transient MBeanServerDelegate mBeanServerDelegateObject;
    private transient ObjectName mBeanServerDelegateObjectName = null;
    static /* synthetic */ Class class$javax$management$Attribute;
    static /* synthetic */ Class class$javax$management$AttributeList;

    JmxMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate) {
        this(string, mBeanServer, mBeanServerDelegate, null, null, false);
    }

    JmxMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, boolean bl) {
        this(string, mBeanServer, mBeanServerDelegate, null, null, false);
    }

    JmxMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator, MetaData metaData, boolean bl) {
        Object object;
        if (mBeanInstantiator == null) {
            object = new ClassLoaderRepositorySupport();
            mBeanInstantiator = new MBeanInstantiatorImpl((ModifiableClassLoaderRepository)object);
        }
        this.secureClr = new SecureClassLoaderRepository(mBeanInstantiator.getClassLoaderRepository());
        if (metaData == null) {
            metaData = new MetaDataImpl(mBeanInstantiator);
        }
        if (mBeanServerDelegate == null) {
            mBeanServerDelegate = new MBeanServerDelegateImpl();
        }
        if (mBeanServer == null) {
            mBeanServer = this;
        }
        this.instantiator = mBeanInstantiator;
        this.meta = metaData;
        this.mBeanServerDelegateObject = mBeanServerDelegate;
        this.outerShell = mBeanServer;
        object = new RepositorySupport(string);
        this.mbsInterceptor = new DefaultMBeanServerInterceptor(mBeanServer, mBeanServerDelegate, mBeanInstantiator, metaData, (Repository)object);
        this.interceptorsEnabled = bl;
        this.initialize();
    }

    public boolean interceptorsEnabled() {
        return this.interceptorsEnabled;
    }

    public MBeanInstantiator getMBeanInstantiator() {
        if (this.interceptorsEnabled) {
            return this.instantiator;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    public MetaData getMetaData() {
        return this.meta;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), objectName2, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), objectArray, stringArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), objectName2, objectArray, stringArray);
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbsInterceptor.registerMBean(object, this.cloneObjectName(objectName));
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbsInterceptor.unregisterMBean(this.cloneObjectName(objectName));
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getObjectInstance(this.cloneObjectName(objectName));
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        return this.mbsInterceptor.queryMBeans(this.cloneObjectName(objectName), queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        return this.mbsInterceptor.queryNames(this.cloneObjectName(objectName), queryExp);
    }

    public boolean isRegistered(ObjectName objectName) {
        return this.mbsInterceptor.isRegistered(objectName);
    }

    public Integer getMBeanCount() {
        return this.mbsInterceptor.getMBeanCount();
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttribute(this.cloneObjectName(objectName), string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttributes(this.cloneObjectName(objectName), stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbsInterceptor.setAttribute(this.cloneObjectName(objectName), this.cloneAttribute(attribute));
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.setAttributes(this.cloneObjectName(objectName), this.cloneAttributeList(attributeList));
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbsInterceptor.invoke(this.cloneObjectName(objectName), string, objectArray, stringArray);
    }

    public String getDefaultDomain() {
        return this.mbsInterceptor.getDefaultDomain();
    }

    public String[] getDomains() {
        return this.mbsInterceptor.getDomains();
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(objectName), notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(objectName), objectName2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), notificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), objectName2);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), objectName2, notificationFilter, object);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbsInterceptor.getMBeanInfo(this.cloneObjectName(objectName));
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        return this.instantiator.instantiate(string);
    }

    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(string, objectName, classLoader);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(string, objectArray, stringArray, classLoader);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(string, objectName, objectArray, stringArray, classLoader);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        return this.mbsInterceptor.isInstanceOf(this.cloneObjectName(objectName), string);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        ClassLoader classLoader = this.getClassLoaderFor(objectName);
        return this.instantiator.deserialize(classLoader, byArray);
    }

    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        Class clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        ClassLoaderRepository classLoaderRepository = this.getClassLoaderRepository();
        try {
            if (classLoaderRepository == null) {
                throw new ClassNotFoundException(string);
            }
            clazz = classLoaderRepository.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The given class could not be loaded by the default loader repository");
        }
        return this.instantiator.deserialize(clazz.getClassLoader(), byArray);
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        objectName = this.cloneObjectName(objectName);
        try {
            this.getClassLoader(objectName);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.deserialize(string, objectName, byArray, classLoader);
    }

    private void initialize() {
        if (this.instantiator == null) {
            throw new IllegalStateException("instantiator must not be null.");
        }
        try {
            this.mBeanServerDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JmxMBeanServer.this.mbsInterceptor.registerMBean(JmxMBeanServer.this.mBeanServerDelegateObject, JmxMBeanServer.this.mBeanServerDelegateObjectName);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            if (this.isDebugOn()) {
                this.debug("new", "Unexpected security exception occured: " + securityException);
            }
            this.mBeanServerDelegateObjectName = null;
            throw securityException;
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("new", "Unexpected exception occured: " + exception.getClass().getName());
            }
            this.mBeanServerDelegateObjectName = null;
            throw new IllegalStateException("Can't register delegate.");
        }
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        ModifiableClassLoaderRepository modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository();
        if (modifiableClassLoaderRepository != null) {
            modifiableClassLoaderRepository.addClassLoader(classLoader);
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            if (classLoader2 != classLoader) {
                modifiableClassLoaderRepository.addClassLoader(classLoader2);
            }
        }
    }

    public synchronized MBeanServerInterceptor getMBeanServerInterceptor() {
        if (this.interceptorsEnabled) {
            return this.mbsInterceptor;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    public synchronized void setMBeanServerInterceptor(MBeanServerInterceptor mBeanServerInterceptor) {
        if (!this.interceptorsEnabled) {
            throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
        }
        if (mBeanServerInterceptor == null) {
            throw new IllegalArgumentException("MBeanServerInterceptor is null");
        }
        this.mbsInterceptor = mBeanServerInterceptor;
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoaderFor(this.cloneObjectName(objectName));
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoader(this.cloneObjectName(objectName));
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        JmxMBeanServer.checkMBeanPermission(null, null, null, "getClassLoaderRepository");
        return this.secureClr;
    }

    public MBeanServerDelegate getMBeanServerDelegate() {
        return this.mBeanServerDelegateObject;
    }

    public static MBeanServerDelegate newMBeanServerDelegate() {
        return new MBeanServerDelegateImpl();
    }

    public static MBeanServer newMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, boolean bl) {
        return new JmxMBeanServer(string, mBeanServer, mBeanServerDelegate, bl);
    }

    private ObjectName cloneObjectName(ObjectName objectName) {
        if (objectName != null) {
            return ObjectName.getInstance(objectName);
        }
        return objectName;
    }

    private Attribute cloneAttribute(Attribute attribute) {
        if (attribute != null && !attribute.getClass().equals(class$javax$management$Attribute == null ? (class$javax$management$Attribute = JmxMBeanServer.class$("javax.management.Attribute")) : class$javax$management$Attribute)) {
            return new Attribute(attribute.getName(), attribute.getValue());
        }
        return attribute;
    }

    private AttributeList cloneAttributeList(AttributeList attributeList) {
        if (attributeList != null) {
            if (!attributeList.getClass().equals(class$javax$management$AttributeList == null ? (class$javax$management$AttributeList = JmxMBeanServer.class$("javax.management.AttributeList")) : class$javax$management$AttributeList)) {
                AttributeList attributeList2 = new AttributeList(attributeList.size());
                Iterator iterator = attributeList.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    attributeList2.add(this.cloneAttribute(attribute));
                }
                return attributeList2;
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                if (attribute.getClass().equals(class$javax$management$Attribute == null ? JmxMBeanServer.class$("javax.management.Attribute") : class$javax$management$Attribute)) continue;
                attributeList.set(i, this.cloneAttribute(attribute));
            }
            return attributeList;
        }
        return attributeList;
    }

    private static void checkMBeanPermission(String string, String string2, ObjectName objectName, String string3) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanPermission mBeanPermission = new MBeanPermission(string, string2, objectName, string3);
            securityManager.checkPermission(mBeanPermission);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.trace("MBeanServer", string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private void debug(String string, String string2) {
        this.debug("MBeanServer", string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

