/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.util.Collection;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.MetaDataException;
import serp.util.Numbers;

public class ValueStrategies {
    public static final int NONE = 0;
    public static final int NATIVE = 1;
    public static final int SEQUENCE = 2;
    public static final int AUTOASSIGN = 3;
    public static final int INCREMENT = 4;
    public static final int UUID_STRING = 5;
    public static final int UUID_HEX = 6;
    private static final Localizer _loc = Localizer.forPackage(ValueStrategies.class);
    private static final TreeBidiMap _map = new TreeBidiMap();

    public static String getName(int strategy) {
        Integer code = Numbers.valueOf((int)strategy);
        String name = (String)_map.getKey((Object)code);
        if (name != null) {
            return name;
        }
        throw new IllegalArgumentException(((Object)code).toString());
    }

    public static int getCode(String val, Object context) {
        if (val == null) {
            return 0;
        }
        Object code = _map.get((Object)val);
        if (code != null) {
            return ((Number)code).intValue();
        }
        String closest = StringDistance.getClosestLevenshteinDistance(val, (Collection)_map.keySet(), 0.5f);
        String msg = closest != null ? _loc.get("bad-value-strategy-hint", new Object[]{context, val, closest, _map.keySet()}).getMessage() : _loc.get("bad-value-strategy", context, val, _map.keySet()).getMessage();
        throw new IllegalArgumentException(msg);
    }

    public static void assertSupported(int strategy, MetaDataContext context, String attributeName) {
        OpenJPAConfiguration conf = context.getRepository().getConfiguration();
        boolean supported = true;
        switch (strategy) {
            case 3: {
                supported = conf.supportedOptions().contains("openjpa.option.AutoassignValue");
                break;
            }
            case 4: {
                supported = conf.supportedOptions().contains("openjpa.option.IncrementValue");
                break;
            }
            case 1: {
                supported = context instanceof ClassMetaData;
            }
        }
        if (!supported) {
            throw new MetaDataException(_loc.get("unsupported-value-strategy", context, ValueStrategies.getName(strategy), attributeName));
        }
    }

    static {
        _map.put((Object)"none", (Object)Numbers.valueOf((int)0));
        _map.put((Object)"native", (Object)Numbers.valueOf((int)1));
        _map.put((Object)"sequence", (Object)Numbers.valueOf((int)2));
        _map.put((Object)"autoassign", (Object)Numbers.valueOf((int)3));
        _map.put((Object)"increment", (Object)Numbers.valueOf((int)4));
        _map.put((Object)"uuid-string", (Object)Numbers.valueOf((int)5));
        _map.put((Object)"uuid-hex", (Object)Numbers.valueOf((int)6));
    }
}

