/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletWebRequest;

public class WebRequestHandlerInterceptorAdapter
implements HandlerInterceptor {
    private final WebRequestInterceptor requestInterceptor;
    private final boolean renderPhaseOnly;

    public WebRequestHandlerInterceptorAdapter(WebRequestInterceptor requestInterceptor) {
        this(requestInterceptor, true);
    }

    public WebRequestHandlerInterceptorAdapter(WebRequestInterceptor requestInterceptor, boolean renderPhaseOnly) {
        Assert.notNull((Object)requestInterceptor, (String)"WebRequestInterceptor must not be null");
        this.requestInterceptor = requestInterceptor;
        this.renderPhaseOnly = renderPhaseOnly;
    }

    public boolean preHandleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        if (!this.renderPhaseOnly) {
            this.requestInterceptor.preHandle((WebRequest)new PortletWebRequest((PortletRequest)request));
        }
        return true;
    }

    public void afterActionCompletion(ActionRequest request, ActionResponse response, Object handler, Exception ex) throws Exception {
        if (!this.renderPhaseOnly) {
            this.requestInterceptor.afterCompletion((WebRequest)new PortletWebRequest((PortletRequest)request), ex);
        }
    }

    public boolean preHandleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        this.requestInterceptor.preHandle((WebRequest)new PortletWebRequest((PortletRequest)request));
        return true;
    }

    public void postHandleRender(RenderRequest request, RenderResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.requestInterceptor.postHandle((WebRequest)new PortletWebRequest((PortletRequest)request), modelAndView != null ? modelAndView.getModelMap() : null);
    }

    public void afterRenderCompletion(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
        this.requestInterceptor.afterCompletion((WebRequest)new PortletWebRequest((PortletRequest)request), ex);
    }
}

