/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoInterceptor
extends JdoAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object;
        block10: {
            PersistenceManager pm;
            block9: {
                boolean existingTransaction = false;
                pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true);
                if (TransactionSynchronizationManager.hasResource((Object)this.getPersistenceManagerFactory())) {
                    this.logger.debug((Object)"Found thread-bound PersistenceManager for JDO interceptor");
                    existingTransaction = true;
                } else {
                    this.logger.debug((Object)"Using new PersistenceManager for JDO interceptor");
                    TransactionSynchronizationManager.bindResource((Object)this.getPersistenceManagerFactory(), (Object)((Object)new PersistenceManagerHolder(pm)));
                }
                try {
                    Object retVal = methodInvocation.proceed();
                    this.flushIfNecessary(pm, existingTransaction);
                    object = retVal;
                    Object var7_7 = null;
                    if (!existingTransaction) break block9;
                }
                catch (JDOException ex) {
                    try {
                        if (this.exceptionConversionEnabled) {
                            throw this.convertJdoAccessException(ex);
                        }
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (existingTransaction) {
                            this.logger.debug((Object)"Not closing pre-bound JDO PersistenceManager after interceptor");
                        } else {
                            TransactionSynchronizationManager.unbindResource((Object)this.getPersistenceManagerFactory());
                            PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
                        }
                        throw throwable;
                    }
                }
                this.logger.debug((Object)"Not closing pre-bound JDO PersistenceManager after interceptor");
                break block10;
            }
            TransactionSynchronizationManager.unbindResource((Object)this.getPersistenceManagerFactory());
            PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
        }
        return object;
    }
}

