/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private IRubyObject io;

    public IOOutputStream(IRubyObject io) {
        if (!io.respondsTo("write")) {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = io;
    }

    public void write(int bite) throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), "write", RubyString.newString(this.io.getRuntime(), new ByteList(new byte[]{(byte)bite}, false)));
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), "write", RubyString.newString(this.io.getRuntime(), new ByteList(b, off, len, false)));
    }

    public void close() throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), "close");
    }
}

