/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.sql.Timestamp;
import java.util.Vector;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ModifyQuery;

public class TimestampLockingPolicy
extends VersionLockingPolicy {
    protected int retrieveTimeFrom;
    public static final int SERVER_TIME = 1;
    public static final int LOCAL_TIME = 2;

    public TimestampLockingPolicy() {
        this.useServerTime();
    }

    public TimestampLockingPolicy(String fieldName) {
        super(fieldName);
        this.useServerTime();
    }

    public TimestampLockingPolicy(DatabaseField field) {
        super(field);
        this.useServerTime();
    }

    public int compareWriteLockValues(Object value1, Object value2) {
        Timestamp timestampValue1 = (Timestamp)value1;
        Timestamp timestampValue2 = (Timestamp)value2;
        return timestampValue1.compareTo(timestampValue2);
    }

    protected Class getDefaultLockingFieldType() {
        return ClassConstants.TIMESTAMP;
    }

    public Object getBaseValue() {
        return new Timestamp(0L);
    }

    protected Object getInitialWriteValue(AbstractSession session) {
        if (this.usesLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.usesServerTime()) {
            AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (readSession.isUnitOfWork()) {
                readSession = ((UnitOfWorkImpl)readSession).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return readSession.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, readSession.getName());
        }
        return null;
    }

    public Object getNewLockValue(ModifyQuery query) {
        return this.getInitialWriteValue(query.getSession());
    }

    public Object getValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        }
        return null;
    }

    public int getVersionDifference(Object currentValue, Object domainObject, Vector primaryKeys, AbstractSession session) {
        Timestamp newWriteLockFieldValue = (Timestamp)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        Timestamp writeLockFieldValue = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(domainObject);
        if (writeLockFieldValue != null && !newWriteLockFieldValue.after(writeLockFieldValue)) {
            return 0;
        }
        return 2;
    }

    public Object getWriteLockValue(Object domainObject, Vector primaryKey, AbstractSession session) {
        Timestamp writeLockFieldValue = null;
        if (this.isStoredInCache()) {
            writeLockFieldValue = (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor());
        } else {
            Object lockValue = this.lockValueFromObject(domainObject);
            if (lockValue != null) {
                if (lockValue instanceof Timestamp) {
                    writeLockFieldValue = (Timestamp)this.lockValueFromObject(domainObject);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return writeLockFieldValue;
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder builder) {
        return builder.value(this.getInitialWriteValue(builder.getSession()));
    }

    protected Number incrementWriteLockValue(Number numberValue) {
        return null;
    }

    public boolean isChildWriteLockValueGreater(AbstractSession session, Vector primaryKey, Class original, ObjectChangeSet changeSet) {
        if (this.isStoredInCache()) {
            Timestamp writeLockValue = (Timestamp)changeSet.getWriteLockValue();
            Timestamp parentValue = (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, original, this.getDescriptor());
            if (writeLockValue != null && (parentValue == null || parentValue.before(writeLockValue))) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewerVersion(Object currentValue, Object domainObject, Vector primaryKey, AbstractSession session) {
        Timestamp newWriteLockFieldValue = (Timestamp)currentValue;
        Timestamp writeLockFieldValue = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(domainObject);
        if (writeLockFieldValue == null) {
            return false;
        }
        if (newWriteLockFieldValue == null) {
            return true;
        }
        return newWriteLockFieldValue.after(writeLockFieldValue);
    }

    public boolean isNewerVersion(AbstractRecord databaseRow, Object domainObject, Vector primaryKey, AbstractSession session) {
        Timestamp newWriteLockFieldValue = (Timestamp)session.getDatasourcePlatform().convertObject(databaseRow.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        Timestamp writeLockFieldValue = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(domainObject);
        if (writeLockFieldValue == null) {
            return false;
        }
        if (newWriteLockFieldValue == null) {
            return true;
        }
        return newWriteLockFieldValue.after(writeLockFieldValue);
    }

    public void setUsesServerTime(boolean usesServerTime) {
        if (usesServerTime) {
            this.useServerTime();
        } else {
            this.useLocalTime();
        }
    }

    public void useLocalTime() {
        this.retrieveTimeFrom = 2;
    }

    public void useServerTime() {
        this.retrieveTimeFrom = 1;
    }

    public boolean usesLocalTime() {
        return this.retrieveTimeFrom == 2;
    }

    public boolean usesServerTime() {
        return this.retrieveTimeFrom == 1;
    }
}

