/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.transaction.AbstractTransactionController;

public class JTATransactionWrapper
extends TransactionWrapperImpl
implements TransactionWrapper {
    protected AbstractTransactionController txnController;

    public JTATransactionWrapper(EntityManagerImpl entityManager) {
        super(entityManager);
        this.txnController = (AbstractTransactionController)entityManager.getServerSession().getExternalTransactionController();
    }

    public Object checkForTransaction(boolean validateExistence) {
        Object transaction = this.txnController.getTransaction();
        if (validateExistence && transaction == null) {
            this.throwCheckTransactionFailedException();
        }
        return transaction;
    }

    public void clear() {
        if (this.txnKey != null && this.entityManager.shouldPropagatePersistenceContext()) {
            this.txnController.getUnitsOfWork().remove(this.txnKey);
        }
        this.localUOW.release();
        this.localUOW = null;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException(TransactionException.entityTransactionWithJTANotAllowed().getMessage());
    }

    public void setRollbackOnlyInternal() {
        if (this.txnController.getTransaction() != null) {
            this.txnController.markTransactionForRollback();
        }
    }

    protected void throwUserTransactionException() {
        throw TransactionException.entityTransactionWithJTANotAllowed();
    }

    protected void throwCheckTransactionFailedException() {
        throw new TransactionRequiredException(TransactionException.externalTransactionNotActive().getMessage());
    }

    public void registerUnitOfWorkWithTxn(UnitOfWorkImpl uow) {
        uow.registerWithTransactionIfRequired();
    }

    public boolean shouldFlushBeforeQuery(UnitOfWorkImpl uow) {
        return uow.isSynchronized();
    }
}

