/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDODataObject;

public class SDOCSUnmarshalListener
implements XMLUnmarshalListener {
    private boolean isCSUnmarshalListener;
    protected HelperContext aHelperContext;

    public SDOCSUnmarshalListener(HelperContext aContext, boolean bIsCSUnmarshalListener) {
        this.aHelperContext = aContext;
        this.isCSUnmarshalListener = bIsCSUnmarshalListener;
    }

    public SDOCSUnmarshalListener(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public void beforeUnmarshal(Object target, Object parent) {
        try {
            if (target instanceof SDODataObject) {
                String className = target.getClass().getName();
                String interfaceName = className.substring(0, className.length() - 4);
                Class<?> interfaceClass = target.getClass().getClassLoader().loadClass(interfaceName);
                Type type = this.aHelperContext.getTypeHelper().getType(interfaceClass);
                SDODataObject aDataObject = (SDODataObject)target;
                aDataObject._setHelperContext(this.aHelperContext);
                aDataObject._setType(type);
            } else if (target instanceof SDOChangeSummary && !this.isCSUnmarshalListener) {
                ((SDOChangeSummary)target).setHelperContext(this.aHelperContext);
            }
        }
        catch (ClassNotFoundException e) {
            throw SDOException.classNotFound(e, null, null);
        }
    }

    public void afterUnmarshal(Object target, Object parent) {
    }
}

