/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.queryframework.ReportItem;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedGetConstructorFor;
import oracle.toplink.essentials.internal.security.PrivilegedInvokeConstructor;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.essentials.queryframework.ConstructorReportItem;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;
import oracle.toplink.essentials.sessions.Session;

public class ReportQueryResult
implements Serializable,
Map {
    protected Vector names;
    protected Vector results;
    protected Vector primaryKeyValues;
    protected StringBuffer key;

    public ReportQueryResult(Vector results, Vector primaryKeyValues) {
        this.results = results;
        this.primaryKeyValues = primaryKeyValues;
    }

    public ReportQueryResult(ReportQuery query, AbstractRecord row, Vector toManyResults) {
        this.names = query.getNames();
        this.buildResult(query, row, toManyResults);
    }

    protected void buildResult(ReportQuery query, AbstractRecord row, Vector toManyData) {
        if (query.shouldDistinctBeUsed()) {
            this.key = new StringBuffer();
        }
        int numberOfPrimaryKeyFields = 0;
        Vector<Object> results = new Vector<Object>(query.getItems().size());
        if (query.shouldRetrievePrimaryKeys()) {
            numberOfPrimaryKeyFields = query.getDescriptor().getPrimaryKeyFields().size();
            this.setPrimaryKeyValues(query.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(row, query.getSession()));
        } else if (query.shouldRetrieveFirstPrimaryKey()) {
            numberOfPrimaryKeyFields = 1;
        }
        for (int index = 0; index < query.getItems().size(); ++index) {
            ReportItem item = (ReportItem)query.getItems().elementAt(index);
            if (item.isContructorItem()) {
                ConstructorReportItem citem = (ConstructorReportItem)item;
                Class[] constructorArgTypes = citem.getConstructorArgTypes();
                List constructorMappings = citem.getConstructorMappings();
                int numberOfItems = citem.getReportItems().size();
                Object[] constructorArgs = new Object[numberOfItems];
                if (constructorArgTypes == null) {
                    constructorArgTypes = new Class[numberOfItems];
                }
                for (int i = 0; i < numberOfItems; ++i) {
                    ReportItem ritem = (ReportItem)citem.getReportItems().get(i);
                    if (constructorArgTypes[i] == null) {
                        if (constructorMappings != null && constructorMappings.get(i) != null) {
                            constructorArgTypes[i] = ((DatabaseMapping)constructorMappings.get(i)).getAttributeClassification();
                        } else if (ritem.getResultType() != null) {
                            constructorArgTypes[i] = ritem.getResultType();
                        } else if (ritem.getDescriptor() != null) {
                            constructorArgTypes[i] = ritem.getDescriptor().getJavaClass();
                        }
                    }
                    Object result = this.processItem(query, row, toManyData, (ReportItem)citem.getReportItems().get(i));
                    constructorArgs[i] = ConversionManager.getDefaultManager().convertObject(result, constructorArgTypes[i]);
                    if (constructorArgTypes[i] != null) continue;
                    constructorArgTypes[i] = constructorArgs[i].getClass();
                }
                try {
                    Constructor constructor = null;
                    Object returnValue = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(citem.getResultType(), constructorArgTypes, true));
                            returnValue = AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, constructorArgs));
                        }
                        catch (PrivilegedActionException exception) {
                            throw QueryException.exceptionWhileUsingConstructorExpression(exception.getException(), query);
                        }
                    } else {
                        constructor = PrivilegedAccessHelper.getConstructorFor(citem.getResultType(), constructorArgTypes, true);
                        returnValue = PrivilegedAccessHelper.invokeConstructor(constructor, constructorArgs);
                    }
                    results.addElement(returnValue);
                    continue;
                }
                catch (NoSuchMethodException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
                catch (IllegalAccessException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
                catch (InvocationTargetException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
                catch (InstantiationException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
            }
            Object value = this.processItem(query, row, toManyData, item);
            results.addElement(value);
        }
        this.setResults(results);
    }

    protected Object processItem(ReportQuery query, AbstractRecord row, Vector toManyData, ReportItem item) {
        JoinedAttributeManager joinManager = item.getJoinedAttributeManager();
        if (joinManager.isToManyJoin()) {
            joinManager.setDataResults(toManyData, query.getSession());
        }
        DatabaseMapping mapping = item.getMapping();
        Object value = null;
        if (!item.isPlaceHolder()) {
            if (mapping != null) {
                value = row.getValues().get(item.getResultIndex());
                value = ((AbstractDirectMapping)mapping).getAttributeValue(value, query.getSession());
                if (this.key != null) {
                    this.key.append(value);
                    this.key.append("_");
                }
            } else if (item.getDescriptor() != null) {
                if (item.getDescriptor().getAllFields().size() + item.getResultIndex() > row.size()) {
                    throw QueryException.reportQueryResultSizeMismatch(item.getDescriptor().getAllFields().size() + item.getResultIndex(), row.size());
                }
                Vector trimedFields = Helper.copyVector(row.getFields(), item.getResultIndex(), row.size());
                Vector trimedValues = Helper.copyVector(row.getValues(), item.getResultIndex(), row.size());
                DatabaseRecord subRow = new DatabaseRecord(trimedFields, trimedValues);
                value = item.getDescriptor().getObjectBuilder().buildObject(query, subRow, joinManager);
                if (this.key != null) {
                    Vector list = item.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(subRow, query.getSession());
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.key.append(iterator.next());
                        this.key.append("-");
                    }
                    this.key.append("_");
                }
            } else {
                value = row.getValues().get(item.getResultIndex());
                if (this.key != null) {
                    this.key.append(value);
                }
            }
        }
        return value;
    }

    public void clear() {
        this.names = new Vector();
        this.results = new Vector();
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return this.getNames().contains(key);
    }

    public boolean containsValue(Object value) {
        return this.getResults().contains(value);
    }

    public Enumeration elements() {
        return this.getResults().elements();
    }

    public Set entrySet() {
        int size = this.size();
        HashMap tempMap = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            tempMap.put(this.getNames().elementAt(i), this.getResults().elementAt(i));
        }
        return tempMap.entrySet();
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof ReportQueryResult) {
            return this.equals((ReportQueryResult)anObject);
        }
        return false;
    }

    public boolean equals(ReportQueryResult result) {
        if (this == result) {
            return true;
        }
        if (!Helper.compareOrderedVectors(this.getResults(), result.getResults())) {
            return false;
        }
        if (this.getPrimaryKeyValues() != null) {
            if (result.getPrimaryKeyValues() == null) {
                return false;
            }
            return Helper.compareOrderedVectors(this.getPrimaryKeyValues(), result.getPrimaryKeyValues());
        }
        return true;
    }

    public Object get(Object name) {
        if (name instanceof String) {
            return this.get((String)name);
        }
        return null;
    }

    public Object get(String name) {
        int index = this.getNames().indexOf(name);
        if (index == -1) {
            return null;
        }
        return this.getResults().elementAt(index);
    }

    public Object getByIndex(int index) {
        return this.getResults().elementAt(index);
    }

    public String getResultKey() {
        if (this.key != null) {
            return this.key.toString();
        }
        return null;
    }

    public Vector getNames() {
        return this.names;
    }

    public Vector getPrimaryKeyValues() {
        return this.primaryKeyValues;
    }

    public Vector getResults() {
        return this.results;
    }

    public boolean isEmpty() {
        return this.getNames().isEmpty();
    }

    public Enumeration keys() {
        return this.getNames().elements();
    }

    public Set keySet() {
        return new HashSet(this.getNames());
    }

    public Object put(Object name, Object value) {
        int index = this.getNames().indexOf(name);
        if (index == -1) {
            this.getNames().addElement(name);
            this.getResults().addElement(value);
            return null;
        }
        Object oldValue = this.getResults().elementAt(index);
        this.getResults().setElementAt(value, index);
        return oldValue;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object readObject(Class javaClass, Session session) {
        if (this.getPrimaryKeyValues() == null) {
            throw QueryException.reportQueryResultWithoutPKs(this);
        }
        ReadObjectQuery query = new ReadObjectQuery(javaClass);
        query.setSelectionKey(this.getPrimaryKeyValues());
        return session.executeQuery(query);
    }

    public Object remove(Object name) {
        int index = this.getNames().indexOf(name);
        if (index >= 0) {
            this.getNames().removeElementAt(index);
            Object value = this.getResults().elementAt(index);
            this.getResults().removeElementAt(index);
            return value;
        }
        return null;
    }

    protected void setNames(Vector names) {
        this.names = names;
    }

    protected void setPrimaryKeyValues(Vector primaryKeyValues) {
        this.primaryKeyValues = primaryKeyValues;
    }

    public void setResults(Vector results) {
        this.results = results;
    }

    public int size() {
        return this.getNames().size();
    }

    public Object[] toArray() {
        Vector list = this.getResults();
        return list == null ? null : list.toArray();
    }

    public List toList() {
        return this.getResults();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("ReportQueryResult(");
        for (int index = 0; index < this.getResults().size(); ++index) {
            writer.write(String.valueOf(this.getResults().elementAt(index)));
            if (index >= this.getResults().size() - 1) continue;
            writer.write(", ");
        }
        writer.write(")");
        return writer.toString();
    }

    public Collection values() {
        return this.getResults();
    }
}

