/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.annotation.valuesource;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.annotation.valuesource.AbstractValueSourceHandler;
import org.springframework.config.java.annotation.valuesource.PropertiesValueSource;
import org.springframework.config.java.valuesource.PropertiesValueResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesValueSourceHandler
extends AbstractValueSourceHandler<PropertiesValueSource> {
    PropertiesValueSourceHandler() {
    }

    @Override
    public BeanDefinition doHandle(PropertiesValueSource anno, BeanDefinitionRegistry registry) {
        String[] locations = anno.locations();
        Object defaultRelativeTo = AnnotationUtils.getDefaultValue((Annotation)anno, (String)"relativeTo");
        Class<?> relativeTo = anno.relativeTo();
        if (relativeTo != defaultRelativeTo) {
            int i = 0;
            while (i < locations.length) {
                locations[i] = String.format("%s/%s", ClassUtils.getPackageName(relativeTo).replace('.', '/'), locations[i]);
                ++i;
            }
        }
        DefaultResourceLoader rl = new DefaultResourceLoader();
        Properties props = new Properties();
        try {
            String[] stringArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                PropertiesLoaderUtils.fillProperties((Properties)props, (Resource)rl.getResource(location));
                ++n2;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(PropertiesValueResolver.class).addConstructorArgValue((Object)props).getBeanDefinition();
    }
}

