/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.util.ArrayList;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.config.java.internal.model.ConfigurationModel;
import org.springframework.config.java.internal.parsing.asm.AnnotationAdapter;
import org.springframework.config.java.internal.parsing.asm.AsmUtils;
import org.springframework.config.java.internal.parsing.asm.ConfigurationClassVisitor;
import org.springframework.config.java.internal.parsing.asm.ImportStackHolder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class ImportAnnotationVisitor
extends AnnotationAdapter {
    private final ArrayList<String> classesToImport = new ArrayList();
    private final ConfigurationClass importingClass;
    private final ConfigurationModel model;

    public ImportAnnotationVisitor(ConfigurationClass importingClass, ConfigurationModel model) {
        super((AnnotationVisitor)AsmUtils.EMPTY_VISITOR);
        this.importingClass = importingClass;
        this.model = model;
    }

    public AnnotationVisitor visitArray(String attribName) {
        Assert.isTrue((boolean)"value".equals(attribName), (String)String.format("expected 'value' attribute, got unknown '%s' attribute", attribName));
        return new AnnotationAdapter((AnnotationVisitor)AsmUtils.EMPTY_VISITOR){

            public void visit(String na, Object type) {
                Assert.isInstanceOf(Type.class, (Object)type);
                ImportAnnotationVisitor.this.classesToImport.add(((Type)type).getClassName());
            }
        };
    }

    public void visitEnd() {
        for (String classToImport : this.classesToImport) {
            this.processClassToImport(classToImport);
        }
        ImportStackHolder.getImportStack().pop();
    }

    private void processClassToImport(String classToImport) {
        ConfigurationClass configClass = new ConfigurationClass();
        ConfigurationClassVisitor configClassVisitor = new ConfigurationClassVisitor(configClass, this.model);
        ClassReader reader = AsmUtils.newClassReader(ClassUtils.convertClassNameToResourcePath((String)classToImport));
        reader.accept((ClassVisitor)configClassVisitor, false);
        this.importingClass.addImportedClass(configClass);
    }
}

