/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.naming;

import java.util.Arrays;
import org.springframework.config.java.model.ModelMethod;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.util.Assert;

public class ChainedStrategy
implements BeanNamingStrategy {
    private BeanNamingStrategy[] strategies;

    public ChainedStrategy(BeanNamingStrategy[] strategies) {
        Assert.notEmpty((Object[])strategies, (String)"at least one strategy required");
        this.strategies = strategies;
    }

    public String getBeanName(ModelMethod beanCreationMethod) {
        BeanNamingStrategy[] beanNamingStrategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            BeanNamingStrategy strategy = beanNamingStrategyArray[n2];
            if (strategy != null && (name = strategy.getBeanName(beanCreationMethod)) != null) {
                return name;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no strategy returned a name; consider using different naming strategies " + Arrays.toString(this.strategies));
    }
}

