/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.config.java.internal.parsing.asm.AnnotationAdapter;
import org.springframework.config.java.internal.parsing.asm.AsmParsingException;
import org.springframework.config.java.internal.parsing.asm.AsmUtils;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotation;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationUtils;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationVisitor;
import org.springframework.util.ClassUtils;

class MutableAnnotationArrayVisitor
extends AnnotationAdapter {
    private final ArrayList<Object> values = new ArrayList();
    private final MutableAnnotation mutableAnno;
    private final String attribName;

    public MutableAnnotationArrayVisitor(MutableAnnotation mutableAnno, String attribName) {
        super((AnnotationVisitor)AsmUtils.EMPTY_VISITOR);
        this.mutableAnno = mutableAnno;
        this.attribName = attribName;
    }

    public void visit(String na, Object value) {
        this.values.add(value);
    }

    public AnnotationVisitor visitAnnotation(String na, String annoTypeDescriptor) {
        String annoTypeName = AsmUtils.convertTypeDescriptorToClassName(annoTypeDescriptor);
        try {
            Class<?> annoType = ClassUtils.getDefaultClassLoader().loadClass(annoTypeName);
            Object anno = MutableAnnotationUtils.createMutableAnnotation(annoType);
            this.values.add(anno);
            return new MutableAnnotationVisitor((MutableAnnotation)anno);
        }
        catch (Exception e) {
            throw new AsmParsingException(e);
        }
    }

    public void visitEnd() {
        Class<?> arrayType = this.mutableAnno.getAttributeType(this.attribName);
        Object[] array = (Object[])Array.newInstance(arrayType.getComponentType(), 0);
        this.mutableAnno.setAttributeValue(this.attribName, this.values.toArray(array));
    }
}

