/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.sort.WarningNonMatchingVersionReporter;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class IvyBuildList
extends IvyTask {
    private List buildFileSets = new ArrayList();
    private String reference;
    private boolean haltOnError = true;
    private boolean skipBuildWithoutIvy = false;
    private boolean reverse = false;
    private String ivyFilePath;
    private String root = "*";
    private boolean excludeRoot = false;
    private String leaf = "*";
    private String delimiter = ",";
    private boolean excludeLeaf = false;
    private boolean onlydirectdep = false;
    private String restartFrom = "*";

    public void addFileset(FileSet buildFiles) {
        this.buildFileSets.add(buildFiles);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public boolean isExcludeRoot() {
        return this.excludeRoot;
    }

    public void setExcludeRoot(boolean root) {
        this.excludeRoot = root;
    }

    public String getLeaf() {
        return this.leaf;
    }

    public void setLeaf(String leaf) {
        this.leaf = leaf;
    }

    public boolean isExcludeLeaf() {
        return this.excludeLeaf;
    }

    public void setExcludeLeaf(boolean excludeLeaf) {
        this.excludeLeaf = excludeLeaf;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean getOnlydirectdep() {
        return this.onlydirectdep;
    }

    public void setOnlydirectdep(boolean onlydirectdep) {
        this.onlydirectdep = onlydirectdep;
    }

    public void doExecute() throws BuildException {
        if (this.reference == null) {
            throw new BuildException("reference should be provided in ivy build list");
        }
        if (this.buildFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided in ivy build list");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        this.ivyFilePath = this.getProperty(this.ivyFilePath, settings, "ivy.buildlist.ivyfilepath");
        Path path = new Path(this.getProject());
        HashMap<ModuleDescriptor, File> buildFiles = new HashMap<ModuleDescriptor, File>();
        LinkedHashMap<String, ModuleDescriptor> mdsMap = new LinkedHashMap<String, ModuleDescriptor>();
        ArrayList<File> independent = new ArrayList<File>();
        LinkedHashSet<String> rootModuleNames = new LinkedHashSet<String>();
        if (!"*".equals(this.root)) {
            StringTokenizer st = new StringTokenizer(this.root, this.delimiter);
            while (st.hasMoreTokens()) {
                rootModuleNames.add(st.nextToken());
            }
        }
        LinkedHashSet<String> leafModuleNames = new LinkedHashSet<String>();
        if (!"*".equals(this.leaf)) {
            StringTokenizer st = new StringTokenizer(this.leaf, this.delimiter);
            while (st.hasMoreTokens()) {
                leafModuleNames.add(st.nextToken());
            }
        }
        LinkedHashSet<String> restartFromModuleNames = new LinkedHashSet<String>();
        if (!"*".equals(this.restartFrom)) {
            StringTokenizer st = new StringTokenizer(this.restartFrom, this.delimiter);
            restartFromModuleNames.add(st.nextToken());
        }
        ListIterator iter = this.buildFileSets.listIterator();
        while (iter.hasNext()) {
            FileSet fs = (FileSet)iter.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] builds = ds.getIncludedFiles();
            for (int i = 0; i < builds.length; ++i) {
                File buildFile = new File(ds.getBasedir(), builds[i]);
                File ivyFile = this.getIvyFileFor(buildFile);
                if (!ivyFile.exists()) {
                    if (this.skipBuildWithoutIvy) {
                        Message.debug("skipping " + buildFile + ": ivy file " + ivyFile + " doesn't exist");
                        continue;
                    }
                    Message.verbose("no ivy file for " + buildFile + ": ivyfile=" + ivyFile + ": adding it at the beginning of the path");
                    Message.verbose("\t(set skipbuildwithoutivy to true if you don't want this file to be added to the path)");
                    independent.add(buildFile);
                    continue;
                }
                try {
                    ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(settings, ivyFile.toURL(), this.doValidate(settings));
                    buildFiles.put(md, buildFile);
                    mdsMap.put(md.getModuleRevisionId().getModuleId().getName(), md);
                    Message.debug("Add " + md.getModuleRevisionId().getModuleId());
                    continue;
                }
                catch (Exception ex) {
                    if (this.haltOnError) {
                        throw new BuildException("impossible to parse ivy file for " + buildFile + ": ivyfile=" + ivyFile + " exception=" + ex, (Throwable)ex);
                    }
                    Message.warn("impossible to parse ivy file for " + buildFile + ": ivyfile=" + ivyFile + " exception=" + ex.getMessage());
                    Message.info("\t=> adding it at the beginning of the path");
                    independent.add(buildFile);
                }
            }
        }
        List leafModuleDescriptors = this.convertModuleNamesToModuleDescriptors(mdsMap, leafModuleNames, "leaf");
        List rootModuleDescriptors = this.convertModuleNamesToModuleDescriptors(mdsMap, rootModuleNames, "root");
        List restartFromModuleDescriptors = this.convertModuleNamesToModuleDescriptors(mdsMap, restartFromModuleNames, "restartFrom");
        Collection<Object> mds = new ArrayList(mdsMap.values());
        if (!rootModuleDescriptors.isEmpty()) {
            Message.info("Filtering modules based on roots " + rootModuleNames);
            mds = this.filterModulesFromRoot(mds, rootModuleDescriptors);
        }
        if (!leafModuleDescriptors.isEmpty()) {
            Message.info("Filtering modules based on leafs " + leafModuleNames);
            mds = this.filterModulesFromLeaf(mds, leafModuleDescriptors);
        }
        WarningNonMatchingVersionReporter nonMatchingVersionReporter = new WarningNonMatchingVersionReporter();
        ArrayList<ModuleDescriptor> sortedModules = ivy.sortModuleDescriptors(mds, nonMatchingVersionReporter);
        ListIterator iter2 = independent.listIterator();
        while (iter2.hasNext()) {
            File buildFile = (File)iter2.next();
            this.addBuildFile(path, buildFile);
        }
        if (this.isReverse()) {
            Collections.reverse(sortedModules);
        }
        if (!restartFromModuleDescriptors.isEmpty()) {
            boolean foundRestartFrom = false;
            ArrayList<ModuleDescriptor> keptModules = new ArrayList<ModuleDescriptor>();
            ModuleDescriptor restartFromModuleDescriptor = (ModuleDescriptor)restartFromModuleDescriptors.get(0);
            ListIterator iter3 = sortedModules.listIterator();
            while (iter3.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)iter3.next();
                if (md.equals(restartFromModuleDescriptor)) {
                    foundRestartFrom = true;
                }
                if (!foundRestartFrom) continue;
                keptModules.add(md);
            }
            sortedModules = keptModules;
        }
        StringBuffer order = new StringBuffer();
        ListIterator iter4 = sortedModules.listIterator();
        while (iter4.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter4.next();
            order.append(md.getModuleRevisionId().getModuleId());
            if (iter4.hasNext()) {
                order.append(", ");
            }
            File buildFile = (File)buildFiles.get(md);
            this.addBuildFile(path, buildFile);
        }
        this.getProject().addReference(this.getReference(), (Object)path);
        this.getProject().setProperty("ivy.sorted.modules", order.toString());
    }

    private List convertModuleNamesToModuleDescriptors(Map mdsMap, Set moduleNames, String kind) {
        ArrayList<ModuleDescriptor> mds = new ArrayList<ModuleDescriptor>();
        Iterator iter = moduleNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ModuleDescriptor md = (ModuleDescriptor)mdsMap.get(name);
            if (md == null) {
                throw new BuildException("unable to find " + kind + " module " + name + " in build fileset");
            }
            mds.add(md);
        }
        return mds;
    }

    private Collection filterModulesFromRoot(Collection mds, List rootmds) {
        HashMap<ModuleId, ModuleDescriptor> moduleIdMap = new HashMap<ModuleId, ModuleDescriptor>();
        Iterator iter = mds.iterator();
        while (iter.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter.next();
            moduleIdMap.put(md.getModuleRevisionId().getModuleId(), md);
        }
        LinkedHashSet<ModuleDescriptor> toKeep = new LinkedHashSet<ModuleDescriptor>();
        Iterator it = rootmds.iterator();
        while (it.hasNext()) {
            ModuleDescriptor rootmd = (ModuleDescriptor)it.next();
            this.processFilterNodeFromRoot(rootmd, toKeep, moduleIdMap);
            if (this.excludeRoot) {
                Message.verbose("Excluded module " + rootmd.getModuleRevisionId().getModuleId().getName());
                continue;
            }
            toKeep.add(rootmd);
        }
        Iterator iter2 = toKeep.iterator();
        while (iter2.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter2.next();
            Message.verbose("Kept module " + md.getModuleRevisionId().getModuleId().getName());
        }
        return toKeep;
    }

    private void processFilterNodeFromRoot(ModuleDescriptor node, Set toKeep, Map moduleIdMap) {
        DependencyDescriptor[] deps = node.getDependencies();
        for (int i = 0; i < deps.length; ++i) {
            ModuleId id = deps[i].getDependencyId();
            if (moduleIdMap.get(id) == null) continue;
            toKeep.add(moduleIdMap.get(id));
            if (this.getOnlydirectdep()) continue;
            this.processFilterNodeFromRoot((ModuleDescriptor)moduleIdMap.get(id), toKeep, moduleIdMap);
        }
    }

    private Collection filterModulesFromLeaf(Collection mds, List leafmds) {
        HashMap<ModuleId, ModuleDescriptor> moduleIdMap = new HashMap<ModuleId, ModuleDescriptor>();
        Iterator iter = mds.iterator();
        while (iter.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter.next();
            moduleIdMap.put(md.getModuleRevisionId().getModuleId(), md);
        }
        LinkedHashSet<ModuleDescriptor> toKeep = new LinkedHashSet<ModuleDescriptor>();
        Iterator it = leafmds.iterator();
        while (it.hasNext()) {
            ModuleDescriptor leafmd = (ModuleDescriptor)it.next();
            if (this.excludeLeaf) {
                Message.verbose("Excluded module " + leafmd.getModuleRevisionId().getModuleId().getName());
            } else {
                toKeep.add(leafmd);
            }
            this.processFilterNodeFromLeaf(leafmd, toKeep, moduleIdMap);
        }
        Iterator iter2 = toKeep.iterator();
        while (iter2.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter2.next();
            Message.verbose("Kept module " + md.getModuleRevisionId().getModuleId().getName());
        }
        return toKeep;
    }

    private void processFilterNodeFromLeaf(ModuleDescriptor node, Set toKeep, Map moduleIdMap) {
        Iterator iter = moduleIdMap.values().iterator();
        while (iter.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter.next();
            DependencyDescriptor[] deps = md.getDependencies();
            for (int i = 0; i < deps.length; ++i) {
                ModuleId id = deps[i].getDependencyId();
                if (!node.getModuleRevisionId().getModuleId().equals(id) || toKeep.contains(md)) continue;
                toKeep.add(md);
                if (this.getOnlydirectdep()) continue;
                this.processFilterNodeFromLeaf(md, toKeep, moduleIdMap);
            }
        }
    }

    private void addBuildFile(Path path, File buildFile) {
        FileSet fs = new FileSet();
        fs.setFile(buildFile);
        path.addFileset(fs);
    }

    private File getIvyFileFor(File buildFile) {
        return new File(buildFile.getParentFile(), this.ivyFilePath);
    }

    public boolean isHaltonerror() {
        return this.haltOnError;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public String getIvyfilepath() {
        return this.ivyFilePath;
    }

    public void setIvyfilepath(String ivyFilePath) {
        this.ivyFilePath = ivyFilePath;
    }

    public boolean isSkipbuildwithoutivy() {
        return this.skipBuildWithoutIvy;
    }

    public void setSkipbuildwithoutivy(boolean skipBuildFilesWithoutIvy) {
        this.skipBuildWithoutIvy = skipBuildFilesWithoutIvy;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public String getRestartFrom() {
        return this.restartFrom;
    }

    public void setRestartFrom(String restartFrom) {
        this.restartFrom = restartFrom;
    }
}

