/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.publish;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.publish.EndArtifactPublishEvent;
import org.apache.ivy.core.event.publish.StartArtifactPublishEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class PublishEngine {
    private PublishEngineSettings settings;
    private EventManager eventManager;

    public PublishEngine(PublishEngineSettings settings, EventManager eventManager) {
        this.settings = settings;
        this.eventManager = eventManager;
    }

    public Collection publish(ModuleRevisionId mrid, Collection srcArtifactPattern, String resolverName, PublishOptions options) throws IOException {
        ModuleDescriptor md;
        long start;
        block14: {
            File ivyFile;
            Message.info(":: publishing :: " + mrid.getModuleId());
            Message.verbose("\tvalidate = " + options.isValidate());
            start = System.currentTimeMillis();
            options.setSrcIvyPattern(this.settings.substitute(options.getSrcIvyPattern()));
            if (options.getPubrevision() == null) {
                options.setPubrevision(mrid.getRevision());
            }
            ModuleRevisionId pubmrid = ModuleRevisionId.newInstance(mrid, options.getPubrevision());
            if (options.getSrcIvyPattern() != null) {
                ivyFile = new File(IvyPatternHelper.substitute(options.getSrcIvyPattern(), DefaultArtifact.newIvyArtifact(pubmrid, new Date())));
                if (!ivyFile.exists()) {
                    throw new IllegalArgumentException("ivy file to publish not found for " + mrid + ": call deliver before (" + ivyFile + ")");
                }
            } else {
                ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
                ivyFile = cacheManager.getResolvedIvyFileInCache(mrid);
                if (!ivyFile.exists()) {
                    throw new IllegalStateException("ivy file not found in cache for " + mrid + ": please resolve dependencies before publishing (" + ivyFile + ")");
                }
            }
            md = null;
            URL ivyFileURL = null;
            try {
                ivyFileURL = ivyFile.toURL();
                md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ivyFileURL, false);
                if (options.getSrcIvyPattern() != null) {
                    if (options.isUpdate()) {
                        File tmp = File.createTempFile("ivy", ".xml");
                        tmp.deleteOnExit();
                        String[] confs = ConfigurationUtils.replaceWildcards(options.getConfs(), md);
                        HashSet<String> confsToRemove = new HashSet<String>(Arrays.asList(md.getConfigurationsNames()));
                        confsToRemove.removeAll(Arrays.asList(confs));
                        try {
                            XmlModuleDescriptorUpdater.update((ParserSettings)this.settings, ivyFileURL, tmp, new HashMap(), options.getStatus() == null ? md.getStatus() : options.getStatus(), options.getPubrevision(), options.getPubdate() == null ? new Date() : options.getPubdate(), null, true, confsToRemove.toArray(new String[confsToRemove.size()]));
                            ivyFile = tmp;
                            md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ivyFile.toURL(), false);
                            options.setSrcIvyPattern(ivyFile.getAbsolutePath());
                            break block14;
                        }
                        catch (SAXException e) {
                            throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e);
                        }
                    }
                    if (!options.getPubrevision().equals(md.getModuleRevisionId().getRevision())) {
                        throw new IllegalArgumentException("cannot publish " + ivyFile + " as " + options.getPubrevision() + ": bad revision found in ivy file (Revision: " + md.getModuleRevisionId().getRevision() + "). Use forcedeliver or update.");
                    }
                    break block14;
                }
                md.setResolvedModuleRevisionId(pubmrid);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("malformed url obtained for file " + ivyFile);
            }
            catch (ParseException e) {
                throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e);
            }
        }
        DependencyResolver resolver = this.settings.getResolver(resolverName);
        if (resolver == null) {
            throw new IllegalArgumentException("unknown resolver " + resolverName);
        }
        Collection missing = this.publish(md, srcArtifactPattern, resolver, options);
        Message.verbose("\tpublish done (" + (System.currentTimeMillis() - start) + "ms)");
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection publish(ModuleDescriptor md, Collection srcArtifactPattern, DependencyResolver resolver, PublishOptions options) throws IOException {
        ArrayList<Artifact> missing = new ArrayList<Artifact>();
        HashSet<Artifact> artifactsSet = new HashSet<Artifact>();
        String[] confs = options.getConfs();
        if (confs == null || confs.length == 1 && "*".equals(confs[0])) {
            confs = md.getConfigurationsNames();
        }
        for (int i = 0; i < confs.length; ++i) {
            Artifact[] artifacts = md.getArtifacts(confs[i]);
            for (int j = 0; j < artifacts.length; ++j) {
                artifactsSet.add(artifacts[j]);
            }
        }
        Artifact[] extraArtifacts = options.getExtraArtifacts();
        if (extraArtifacts != null) {
            for (int i = 0; i < extraArtifacts.length; ++i) {
                artifactsSet.add(new MDArtifact(md, extraArtifacts[i].getName(), extraArtifacts[i].getType(), extraArtifacts[i].getExt(), extraArtifacts[i].getUrl(), extraArtifacts[i].getExtraAttributes()));
            }
        }
        boolean successfullyPublished = false;
        try {
            Artifact artifact;
            resolver.beginPublishTransaction(md.getModuleRevisionId(), options.isOverwrite());
            Iterator iter = artifactsSet.iterator();
            while (iter.hasNext()) {
                String pattern;
                Artifact artifact2 = (Artifact)iter.next();
                boolean published = false;
                Iterator iterator = srcArtifactPattern.iterator();
                while (iterator.hasNext() && !published) {
                    pattern = (String)iterator.next();
                    published = this.publish(artifact2, this.settings.substitute(pattern), resolver, options.isOverwrite());
                }
                if (published) continue;
                Message.info("missing artifact " + artifact2 + ":");
                iterator = srcArtifactPattern.iterator();
                while (iterator.hasNext()) {
                    pattern = (String)iterator.next();
                    Message.info("\t" + new File(IvyPatternHelper.substitute(pattern, artifact2)) + " file does not exist");
                }
                missing.add(artifact2);
            }
            if (options.getSrcIvyPattern() != null && !this.publish(artifact = MDArtifact.newIvyArtifact(md), options.getSrcIvyPattern(), resolver, options.isOverwrite())) {
                Message.info("missing ivy file for " + md.getModuleRevisionId() + ": " + new File(IvyPatternHelper.substitute(options.getSrcIvyPattern(), artifact)) + " file does not exist");
                missing.add(artifact);
            }
            resolver.commitPublishTransaction();
            successfullyPublished = true;
        }
        finally {
            if (!successfullyPublished) {
                resolver.abortPublishTransaction();
            }
        }
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publish(Artifact artifact, String srcArtifactPattern, DependencyResolver resolver, boolean overwrite) throws IOException {
        File src = new File(IvyPatternHelper.substitute(srcArtifactPattern, artifact));
        IvyContext.getContext().checkInterrupted();
        this.eventManager.fireIvyEvent(new StartArtifactPublishEvent(resolver, artifact, src, overwrite));
        boolean successful = false;
        try {
            if (src.exists()) {
                resolver.publish(artifact, src, overwrite);
                successful = true;
            }
            boolean bl = successful;
            return bl;
        }
        finally {
            this.eventManager.fireIvyEvent(new EndArtifactPublishEvent(resolver, artifact, src, overwrite, successful));
        }
    }
}

