/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.tx;

import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.config.java.plugin.ProxyTargetClass;


/** TODO: JAVADOC */
class AnnotationDrivenTxHandler implements ConfigurationPlugin<AnnotationDrivenTx> {

    public void handle(AnnotationDrivenTx txAnno, BeanDefinitionRegistry registry) {
        TxAnnotationDrivenDeclaration txDec = new TxAnnotationDrivenDeclaration();
        txDec.setProxyTargetClass(txAnno.proxyTargetClass() ? ProxyTargetClass.TRUE : ProxyTargetClass.FALSE);
        txDec.setExplicitlyOrdered(txAnno.order() == 0 ? false : true);
        txDec.setOrder(txAnno.order());
        txDec.setMode(txAnno.mode());
        txDec.setTransactionManagerName(txAnno.transactionManager());

        // workaround related to hidden beans, see also AbstractValueSourceHandler
        if(registry instanceof HierarchicalBeanFactory)
            if(((HierarchicalBeanFactory)registry).getParentBeanFactory() instanceof BeanDefinitionRegistry)
                registry = (BeanDefinitionRegistry)((HierarchicalBeanFactory)registry).getParentBeanFactory();

        new GeneralizedAnnotationDrivenBeanDefinitionParser().parseDeclaration(txDec, registry);
    }

}
