/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.parsing.asm;

import static org.junit.Assert.*;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

import org.junit.Before;
import org.junit.Test;
import org.springframework.config.java.internal.model.ConfigurationClass;


/** TODO: JAVADOC */
public class ImportStackTests {

    private ImportStack importStack;

    public @Before void setUp() {
        importStack = new ImportStack();

        ConfigurationClass foo = new ConfigurationClass();
        foo.setName("org.acme.Foo");
        importStack.push(foo);

        ConfigurationClass bar = new ConfigurationClass();
        bar.setName("org.acme.Bar");
        importStack.push(bar);

        ConfigurationClass baz = new ConfigurationClass();
        baz.setName("org.acme.Baz");
        importStack.push(baz);
    }

    public @Test void testToString() {
        assertEquals("Foo->Bar->Baz", importStack.toString());
    }

    public @Test void testContainsExactMatch() {
        ConfigurationClass foo = new ConfigurationClass();
        foo.setName("org.acme.Foo");
        assertTrue(importStack.contains(foo));
    }

    public @Test void testContainsInexactMatch() {
        ConfigurationClass foo = new ConfigurationClass();
        foo.setName("org.acme.Foo");
        foo.setModifiers(Modifier.PUBLIC + Modifier.ABSTRACT);
        assertTrue(importStack.contains(foo));
    }

    public @Test void testContainsEmpty() {
        ConfigurationClass foo = new ConfigurationClass();
        assertFalse(importStack.contains(foo));
    }

    public @Test void testContainsUnrelated() {
        ConfigurationClass bogus = new ConfigurationClass();
        bogus.setName("org.acme.Bogus");
        assertFalse(importStack.contains(bogus));
    }

    public @Test void testContainsAll() {
        ConfigurationClass foo = new ConfigurationClass();
        foo.setName("org.acme.Foo");

        ConfigurationClass bar = new ConfigurationClass();
        bar.setName("org.acme.Bar");

        ArrayList<ConfigurationClass> list = new ArrayList<ConfigurationClass>();
        list.add(foo);
        list.add(bar);

        assertTrue(importStack.containsAll(list));
    }

}
