/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.context;

import org.springframework.context.annotation.FilterType;


/** 
 * Used to narrow the set of candidate classes during component scanning.
 * <p/>
 * Not yet functional, will become public in 1.0.0.m5
 * TODO: SJC-223
 * 
 * @see ComponentScan
 */
@interface Filter {
    FilterType type();

    /**
     * Currently limited to String as a lowest common denominator.  This means
     * that even if {@value #type()} is specified as {@value FilterType#ASSIGNABLE_TYPE}
     * the class will need to be a fully qualified classname string.
     */
    String expression();
}
