/*
** 2023-07-21
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** This file is part of the JNI bindings for the sqlite3 C API.
*/
package org.sqlite.jni;

/**
   This enum contains all of the core and "extended" result codes used
   by the sqlite3 library. It is provided not for use with the C-style
   API (with which it won't work) but for higher-level code which may
   find it useful to map SQLite result codes to human-readable names.
*/
public enum ResultCode {
  SQLITE_OK(SQLite3Jni.SQLITE_OK),
  SQLITE_ERROR(SQLite3Jni.SQLITE_ERROR),
  SQLITE_INTERNAL(SQLite3Jni.SQLITE_INTERNAL),
  SQLITE_PERM(SQLite3Jni.SQLITE_PERM),
  SQLITE_ABORT(SQLite3Jni.SQLITE_ABORT),
  SQLITE_BUSY(SQLite3Jni.SQLITE_BUSY),
  SQLITE_LOCKED(SQLite3Jni.SQLITE_LOCKED),
  SQLITE_NOMEM(SQLite3Jni.SQLITE_NOMEM),
  SQLITE_READONLY(SQLite3Jni.SQLITE_READONLY),
  SQLITE_INTERRUPT(SQLite3Jni.SQLITE_INTERRUPT),
  SQLITE_IOERR(SQLite3Jni.SQLITE_IOERR),
  SQLITE_CORRUPT(SQLite3Jni.SQLITE_CORRUPT),
  SQLITE_NOTFOUND(SQLite3Jni.SQLITE_NOTFOUND),
  SQLITE_FULL(SQLite3Jni.SQLITE_FULL),
  SQLITE_CANTOPEN(SQLite3Jni.SQLITE_CANTOPEN),
  SQLITE_PROTOCOL(SQLite3Jni.SQLITE_PROTOCOL),
  SQLITE_EMPTY(SQLite3Jni.SQLITE_EMPTY),
  SQLITE_SCHEMA(SQLite3Jni.SQLITE_SCHEMA),
  SQLITE_TOOBIG(SQLite3Jni.SQLITE_TOOBIG),
  SQLITE_CONSTRAINT(SQLite3Jni.SQLITE_CONSTRAINT),
  SQLITE_MISMATCH(SQLite3Jni.SQLITE_MISMATCH),
  SQLITE_MISUSE(SQLite3Jni.SQLITE_MISUSE),
  SQLITE_NOLFS(SQLite3Jni.SQLITE_NOLFS),
  SQLITE_AUTH(SQLite3Jni.SQLITE_AUTH),
  SQLITE_FORMAT(SQLite3Jni.SQLITE_FORMAT),
  SQLITE_RANGE(SQLite3Jni.SQLITE_RANGE),
  SQLITE_NOTADB(SQLite3Jni.SQLITE_NOTADB),
  SQLITE_NOTICE(SQLite3Jni.SQLITE_NOTICE),
  SQLITE_WARNING(SQLite3Jni.SQLITE_WARNING),
  SQLITE_ROW(SQLite3Jni.SQLITE_ROW),
  SQLITE_DONE(SQLite3Jni.SQLITE_DONE),
  SQLITE_ERROR_MISSING_COLLSEQ(SQLite3Jni.SQLITE_ERROR_MISSING_COLLSEQ),
  SQLITE_ERROR_RETRY(SQLite3Jni.SQLITE_ERROR_RETRY),
  SQLITE_ERROR_SNAPSHOT(SQLite3Jni.SQLITE_ERROR_SNAPSHOT),
  SQLITE_IOERR_READ(SQLite3Jni.SQLITE_IOERR_READ),
  SQLITE_IOERR_SHORT_READ(SQLite3Jni.SQLITE_IOERR_SHORT_READ),
  SQLITE_IOERR_WRITE(SQLite3Jni.SQLITE_IOERR_WRITE),
  SQLITE_IOERR_FSYNC(SQLite3Jni.SQLITE_IOERR_FSYNC),
  SQLITE_IOERR_DIR_FSYNC(SQLite3Jni.SQLITE_IOERR_DIR_FSYNC),
  SQLITE_IOERR_TRUNCATE(SQLite3Jni.SQLITE_IOERR_TRUNCATE),
  SQLITE_IOERR_FSTAT(SQLite3Jni.SQLITE_IOERR_FSTAT),
  SQLITE_IOERR_UNLOCK(SQLite3Jni.SQLITE_IOERR_UNLOCK),
  SQLITE_IOERR_RDLOCK(SQLite3Jni.SQLITE_IOERR_RDLOCK),
  SQLITE_IOERR_DELETE(SQLite3Jni.SQLITE_IOERR_DELETE),
  SQLITE_IOERR_BLOCKED(SQLite3Jni.SQLITE_IOERR_BLOCKED),
  SQLITE_IOERR_NOMEM(SQLite3Jni.SQLITE_IOERR_NOMEM),
  SQLITE_IOERR_ACCESS(SQLite3Jni.SQLITE_IOERR_ACCESS),
  SQLITE_IOERR_CHECKRESERVEDLOCK(SQLite3Jni.SQLITE_IOERR_CHECKRESERVEDLOCK),
  SQLITE_IOERR_LOCK(SQLite3Jni.SQLITE_IOERR_LOCK),
  SQLITE_IOERR_CLOSE(SQLite3Jni.SQLITE_IOERR_CLOSE),
  SQLITE_IOERR_DIR_CLOSE(SQLite3Jni.SQLITE_IOERR_DIR_CLOSE),
  SQLITE_IOERR_SHMOPEN(SQLite3Jni.SQLITE_IOERR_SHMOPEN),
  SQLITE_IOERR_SHMSIZE(SQLite3Jni.SQLITE_IOERR_SHMSIZE),
  SQLITE_IOERR_SHMLOCK(SQLite3Jni.SQLITE_IOERR_SHMLOCK),
  SQLITE_IOERR_SHMMAP(SQLite3Jni.SQLITE_IOERR_SHMMAP),
  SQLITE_IOERR_SEEK(SQLite3Jni.SQLITE_IOERR_SEEK),
  SQLITE_IOERR_DELETE_NOENT(SQLite3Jni.SQLITE_IOERR_DELETE_NOENT),
  SQLITE_IOERR_MMAP(SQLite3Jni.SQLITE_IOERR_MMAP),
  SQLITE_IOERR_GETTEMPPATH(SQLite3Jni.SQLITE_IOERR_GETTEMPPATH),
  SQLITE_IOERR_CONVPATH(SQLite3Jni.SQLITE_IOERR_CONVPATH),
  SQLITE_IOERR_VNODE(SQLite3Jni.SQLITE_IOERR_VNODE),
  SQLITE_IOERR_AUTH(SQLite3Jni.SQLITE_IOERR_AUTH),
  SQLITE_IOERR_BEGIN_ATOMIC(SQLite3Jni.SQLITE_IOERR_BEGIN_ATOMIC),
  SQLITE_IOERR_COMMIT_ATOMIC(SQLite3Jni.SQLITE_IOERR_COMMIT_ATOMIC),
  SQLITE_IOERR_ROLLBACK_ATOMIC(SQLite3Jni.SQLITE_IOERR_ROLLBACK_ATOMIC),
  SQLITE_IOERR_DATA(SQLite3Jni.SQLITE_IOERR_DATA),
  SQLITE_IOERR_CORRUPTFS(SQLite3Jni.SQLITE_IOERR_CORRUPTFS),
  SQLITE_LOCKED_SHAREDCACHE(SQLite3Jni.SQLITE_LOCKED_SHAREDCACHE),
  SQLITE_LOCKED_VTAB(SQLite3Jni.SQLITE_LOCKED_VTAB),
  SQLITE_BUSY_RECOVERY(SQLite3Jni.SQLITE_BUSY_RECOVERY),
  SQLITE_BUSY_SNAPSHOT(SQLite3Jni.SQLITE_BUSY_SNAPSHOT),
  SQLITE_BUSY_TIMEOUT(SQLite3Jni.SQLITE_BUSY_TIMEOUT),
  SQLITE_CANTOPEN_NOTEMPDIR(SQLite3Jni.SQLITE_CANTOPEN_NOTEMPDIR),
  SQLITE_CANTOPEN_ISDIR(SQLite3Jni.SQLITE_CANTOPEN_ISDIR),
  SQLITE_CANTOPEN_FULLPATH(SQLite3Jni.SQLITE_CANTOPEN_FULLPATH),
  SQLITE_CANTOPEN_CONVPATH(SQLite3Jni.SQLITE_CANTOPEN_CONVPATH),
  SQLITE_CANTOPEN_SYMLINK(SQLite3Jni.SQLITE_CANTOPEN_SYMLINK),
  SQLITE_CORRUPT_VTAB(SQLite3Jni.SQLITE_CORRUPT_VTAB),
  SQLITE_CORRUPT_SEQUENCE(SQLite3Jni.SQLITE_CORRUPT_SEQUENCE),
  SQLITE_CORRUPT_INDEX(SQLite3Jni.SQLITE_CORRUPT_INDEX),
  SQLITE_READONLY_RECOVERY(SQLite3Jni.SQLITE_READONLY_RECOVERY),
  SQLITE_READONLY_CANTLOCK(SQLite3Jni.SQLITE_READONLY_CANTLOCK),
  SQLITE_READONLY_ROLLBACK(SQLite3Jni.SQLITE_READONLY_ROLLBACK),
  SQLITE_READONLY_DBMOVED(SQLite3Jni.SQLITE_READONLY_DBMOVED),
  SQLITE_READONLY_CANTINIT(SQLite3Jni.SQLITE_READONLY_CANTINIT),
  SQLITE_READONLY_DIRECTORY(SQLite3Jni.SQLITE_READONLY_DIRECTORY),
  SQLITE_ABORT_ROLLBACK(SQLite3Jni.SQLITE_ABORT_ROLLBACK),
  SQLITE_CONSTRAINT_CHECK(SQLite3Jni.SQLITE_CONSTRAINT_CHECK),
  SQLITE_CONSTRAINT_COMMITHOOK(SQLite3Jni.SQLITE_CONSTRAINT_COMMITHOOK),
  SQLITE_CONSTRAINT_FOREIGNKEY(SQLite3Jni.SQLITE_CONSTRAINT_FOREIGNKEY),
  SQLITE_CONSTRAINT_FUNCTION(SQLite3Jni.SQLITE_CONSTRAINT_FUNCTION),
  SQLITE_CONSTRAINT_NOTNULL(SQLite3Jni.SQLITE_CONSTRAINT_NOTNULL),
  SQLITE_CONSTRAINT_PRIMARYKEY(SQLite3Jni.SQLITE_CONSTRAINT_PRIMARYKEY),
  SQLITE_CONSTRAINT_TRIGGER(SQLite3Jni.SQLITE_CONSTRAINT_TRIGGER),
  SQLITE_CONSTRAINT_UNIQUE(SQLite3Jni.SQLITE_CONSTRAINT_UNIQUE),
  SQLITE_CONSTRAINT_VTAB(SQLite3Jni.SQLITE_CONSTRAINT_VTAB),
  SQLITE_CONSTRAINT_ROWID(SQLite3Jni.SQLITE_CONSTRAINT_ROWID),
  SQLITE_CONSTRAINT_PINNED(SQLite3Jni.SQLITE_CONSTRAINT_PINNED),
  SQLITE_CONSTRAINT_DATATYPE(SQLite3Jni.SQLITE_CONSTRAINT_DATATYPE),
  SQLITE_NOTICE_RECOVER_WAL(SQLite3Jni.SQLITE_NOTICE_RECOVER_WAL),
  SQLITE_NOTICE_RECOVER_ROLLBACK(SQLite3Jni.SQLITE_NOTICE_RECOVER_ROLLBACK),
  SQLITE_WARNING_AUTOINDEX(SQLite3Jni.SQLITE_WARNING_AUTOINDEX),
  SQLITE_AUTH_USER(SQLite3Jni.SQLITE_AUTH_USER),
  SQLITE_OK_LOAD_PERMANENTLY(SQLite3Jni.SQLITE_OK_LOAD_PERMANENTLY);

  public final int value;

  ResultCode(int rc){
    value = rc;
    ResultCodeMap.set(rc, this);
  }

  /**
     Returns the entry from this enum for the given result code, or
     null if no match is found.
  */
  public static ResultCode getEntryForInt(int rc){
    return ResultCodeMap.get(rc);
  }

  /**
     Internal level of indirection required because we cannot initialize
     static enum members in an enum before the enum constructor is
     invoked.
  */
  private static final class ResultCodeMap {
    private static final java.util.Map<Integer,ResultCode> i2e
      = new java.util.HashMap<>();
    private static void set(int rc, ResultCode e){ i2e.put(rc, e); }
    private static ResultCode get(int rc){ return i2e.get(rc); }
  }

}
