/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.typedef;

import org.javaruntype.typedef.InnerTypeDefVariable;
import org.javaruntype.typedef.TypeDefVariable;
import org.javaruntype.util.Utils;

public final class BoundedTypeDefVariable
implements TypeDefVariable {
    private static final long serialVersionUID = -7857569027190529682L;
    private final String variableName;
    private final InnerTypeDefVariable[] bounds;
    private final String stringRepresentation;
    private final int hashCode;

    private static String createStringRepresentation(String variableName, InnerTypeDefVariable[] bounds) {
        StringBuilder str = new StringBuilder();
        str.append(variableName);
        str.append(" extends ");
        str.append(Utils.join(bounds, "&"));
        return str.toString();
    }

    BoundedTypeDefVariable(String variableName, InnerTypeDefVariable[] bounds) {
        this.variableName = variableName;
        this.bounds = bounds;
        this.stringRepresentation = BoundedTypeDefVariable.createStringRepresentation(variableName, bounds);
        this.hashCode = this.stringRepresentation.hashCode();
    }

    public String getVariableName() {
        return this.variableName;
    }

    public InnerTypeDefVariable[] getBounds() {
        return (InnerTypeDefVariable[])this.bounds.clone();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundedTypeDefVariable other = (BoundedTypeDefVariable)obj;
        return this.stringRepresentation.equals(other.stringRepresentation);
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

