/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.trees.EnglishPatterns;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EnglishGrammaticalRelations {
    private static final TregexPatternCompiler tregexCompiler = new TregexPatternCompiler((HeadFinder)null);
    public static final GrammaticalRelation PREDICATE = new GrammaticalRelation(Language.English, "pred", "predicate", GrammaticalRelation.DEPENDENT, "S|SINV", tregexCompiler, "S|SINV <# VP=target");
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(Language.English, "aux", "auxiliary", GrammaticalRelation.DEPENDENT, "VP|SQ|SINV|CONJP", tregexCompiler, "VP < VP < (/^(?:TO|MD|VB.*|AUXG?|POS)$/=target)", "SQ|SINV < (/^(?:VB|MD|AUX)/=target $++ /^(?:VP|ADJP)/)", "CONJP < TO=target < VB", "SINV < (VP=target < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/) $-- (VP < VBG))");
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation(Language.English, "auxpass", "passive auxiliary", AUX_MODIFIER, "VP|SQ|SINV", tregexCompiler, "VP < (/^(?:VB|AUX|POS)/=target < " + EnglishPatterns.passiveAuxWordRegex + " ) < (VP|ADJP [ < VBN|VBD | < (VP|ADJP < VBN|VBD) < CC ] )", "SQ|SINV < (/^(?:VB|AUX|POS)/=target < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/ $++ (VP < VBD|VBN))", "SINV < (VP=target < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/) $-- (VP < VBD|VBN))", "SINV < (VP=target < (VP < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/)) $-- (VP < VBD|VBN))");
    public static final GrammaticalRelation COPULA = new GrammaticalRelation(Language.English, "cop", "copula", AUX_MODIFIER, "VP|SQ|SINV|SBARQ", tregexCompiler, "VP < (/^(?:VB|AUX)/=target < " + EnglishPatterns.copularWordRegex + " [ $++ (/^(?:ADJP|NP$|WHNP$)/ !< (VBN|VBD !$++ /^N/)) | $++ (S <: (ADJP < JJ)) ] )", "SQ|SINV < (/^(?:VB|AUX)/=target < " + EnglishPatterns.copularWordRegex + " [ $++ (ADJP !< VBN|VBD) | $++ (NP $++ NP) | $++ (S <: (ADJP < JJ)) ] )", "SBARQ < (/^(?:VB|AUX)/=target < " + EnglishPatterns.copularWordRegex + ") < (WHNP < WP)", "SINV <# (NP $++ (NP $++ (VP=target < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + "))))");
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(Language.English, "conj", "conjunct", GrammaticalRelation.DEPENDENT, "VP|(?:WH)?NP(?:-TMP|-ADV)?|ADJP|PP|QP|ADVP|UCP(?:-TMP|-ADV)?|S|NX|SBAR|SBARQ|SINV|SQ|JJP|NML|RRC", tregexCompiler, "VP|S|SBAR|SBARQ|SINV|SQ|RRC < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/ $+ !/^(?:SBAR|PRN|``|''|-[LR]RB-|,|:|\\.)$/=target)", "SBAR < (CC|CONJP $-- @SBAR $+ @SBAR=target)", "VP|S|SBAR|SBARQ|SINV|SQ|RRC < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/ $+ (ADVP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target))", "VP|S|SBAR|SBARQ|SINV|SQ=root < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/) < (/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/ $+ (/^S|SINV$|^(?:A|N|V|PP|PRP|J|W|R)/=target [$-- (CC|CONJP $-- (__ ># =root) !$++ (/^:|,$/ $++ =target)) | $-- (/^:|,$/ $-- (__ ># =root) [!$-- /^CC|CONJP$/ | $++ (=target < (/^,$/ $++ (__ ># =target)))])] ) )", "/^(?:ADJP|JJP|PP|QP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ [ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/ $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target) | < (FW=target < /^(?i:(etc|ect))$/) | < (ADVP|NP=target <1 (FW < /^(?i:(etc|ect))$/))]", "/^(?:ADJP|PP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/ $+ (ADVP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target))", "/^(?:ADJP|PP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ [ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/) | < (FW < /^(?i:(etc|ect))$/) | < (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))] < (/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/ [ $+ /^S|SINV$|^(?:A|N|V|PP|PRP|J|W|R)/=target | $+ (FW=target < /^(?i:(etc|ect))$/) ] )", "NX|NML [ < (CC|CONJP $- __) | < (FW < /^(?i:(etc|ect))$/)] < (/^,$/ $- /^(?:A|N|V|PP|PRP|J|W|R|S)/=target)", "/^(?:VP|S|SBAR|SBARQ|SINV|ADJP|PP|QP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ [ < (CC $++ (CC|CONJP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target)) | <- (FW=target < /^(?i:(etc|ect))$/) | <- (ADVP|NP=target <1 (FW < /^(?i:(etc|ect))$/)) ]");
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(Language.English, "cc", "coordination", GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, "__ [ < (CC=target !< /^(?i:either|neither|both)$/ ) | < (CONJP=target !< (RB < /^(?i:not)$/ $+ (RB|JJ < /^(?i:only|just|merely)$/))) ]");
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(Language.English, "punct", "punctuation", GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, "__ < /^(?:\\.|:|,|''|``|\\*|-LRB-|-RRB-|HYPH)$/=target", "__ < (NFP=target !< /^(?:[<>]?[:;=8][\\-o\\*'\u2019]?(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])|(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])[\\-o\\*'\u2019]?[:;=8][<>]?)$/ !< /(?!^--$)^(?:-LRB-|[(])?[\\-\\^x=~<>'\u2019][_.]?[\\-\\^x=~<>'\u2019](?:-RRB-|[)])?$/)");
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation(Language.English, "arg", "argument", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation(Language.English, "subj", "subject", ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(Language.English, "nsubj", "nominal subject", SUBJECT, "S|SQ|SBARQ|SINV|SBAR|PRN", tregexCompiler, "S=subj < ((NP|WHNP=target !< EX !<# (/^NN/ < (/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/))) $++ VP=verb) : (=subj !> VP | !<< (=verb < TO))", "S < ( NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$++ NP $++VP)", "SQ|PRN < (NP=target !< EX $++ VP)", "SQ < (NP=target !< EX $- (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") !$++ VP)", "SQ < (NP=target !< EX $- /^(?:VB|AUX)/ !$++ VP) !$-- NP|WHNP", "SQ < ((NP=target !< EX) $- (RB $- /^(?:VB|AUX)/) ![$++ VP])", "SBARQ < WHNP=target < (SQ < (VP !$-- NP))", "SBARQ < WHNP=target < (SQ < ((/^(?:VB)/ !< " + EnglishPatterns.copularWordRegex + ") !$-- NP !$++ VP))", "SBARQ < (SQ=target < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") !< VP)", "SINV < (NP|WHNP=target [ $- VP|VBZ|VBD|VBP|VB|MD|AUX | $- (@RB|ADVP $- VP|VBZ|VBD|VBP|VB|MD|AUX) | !$- __ !$ @NP] )", "SINV < (NP $++ (NP=target $++ (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + "))))", "S < (NP=target $+ NP|ADJP) > VP", "SBAR < WHNP=target [ < (S < (VP !$-- NP) !< SBAR) | < (VP !$-- NP) !< S ]", "SBAR !< WHNP < (S !< (NP $++ VP)) > (VP > (S $- WHNP=target))", "SQ < ((NP < EX) $++ NP=target)", "S < (NP < EX) <+(VP) (VP < NP=target)", "SBARQ < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") < (WHNP < WP) < NP=target", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $++ ADJP=adj !$++ (NP $++ =adj)))", "SBARQ <1 WHNP=target < (SQ < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") [< (NP < EX) | < PP])");
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.English, "nsubjpass", "nominal passive subject", NOMINAL_SUBJECT, "S|SQ", tregexCompiler, "S|SQ < (WHNP|NP=target !< EX) < (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.passiveAuxWordRegex + ")  < (VP < VBN|VBD))");
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation(Language.English, "csubj", "clausal subject", SUBJECT, "S", tregexCompiler, "S < (SBAR|S=target !$+ /^,$/ $++ (VP !$-- NP))");
    public static final GrammaticalRelation CLAUSAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.English, "csubjpass", "clausal passive subject", CLAUSAL_SUBJECT, "S", tregexCompiler, "S < (SBAR|S=target !$+ /^,$/ $++ (VP < (VP < VBN|VBD) < (/^(?:VB|AUXG?)/ < " + EnglishPatterns.passiveAuxWordRegex + ") !$-- NP))", "S < (SBAR|S=target !$+ /^,$/ $++ (VP <+(VP) (VP < VBN|VBD > (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.passiveAuxWordRegex + "))) !$-- NP))");
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation(Language.English, "comp", "complement", ARGUMENT);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation(Language.English, "obj", "object", COMPLEMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(Language.English, "dobj", "direct object", OBJECT, "VP|SQ|SBARQ?", tregexCompiler, "VP !< (/^(?:VB|AUX)/ [ < " + EnglishPatterns.copularWordRegex + " | < " + "/^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/" + " ]) < (NP|WHNP=target [ [ !<# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ") !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ")) ] )  <# (__ !$++ (NP $++ (/^[:]$/ $++ =target))) ", "VP < (S < (NP|WHNP=target $++ (VP < TO)))", "SQ < (/^(?:VB)/=verb !< " + EnglishPatterns.copularWordRegex + ") $-- WHNP !< VP !< (/^(?:VB)/ ! == =verb) < (NP|WHNP=target [ [ !<# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ") !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ")) ] )", "SBARQ < (WHNP=target !< WRB !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) <+(SQ|SINV|S|VP) (VP !< NP|TO !< (S < (VP < TO)) !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " $++ (VP < VBN|VBD)) !< (PP <: IN|TO) $-- (NP !< /^-NONE-$/))", "SBAR < (WHNP=target !< WRB) < (S < NP < (VP !< SBAR !<+(VP) (PP <- IN|TO) !< (S < (VP < TO))))", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $++ (ADJP=adj !< (PP !< NP)) $++ (NP $++ =adj)))");
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation(Language.English, "iobj", "indirect object", OBJECT, "VP", tregexCompiler, "VP < (NP=target !< /\\$/ !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) $+ (NP !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)))", "VP < (NP=target < (NP !< /\\$/ $++ (NP !<: (PRP < /^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/) !<: DT !< (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot)$/)) !$ CC|CONJP !$ /^,$/ !$++ /^:$/))");
    public static final GrammaticalRelation PREPOSITIONAL_OBJECT = new GrammaticalRelation(Language.English, "pobj", "prepositional object", OBJECT, "SBARQ|PP(?:-TMP)?|WHPP|PRT|ADVP|WHADVP|XS", tregexCompiler, "/^(?:PP(?:-TMP)?|(?:WH)?(?:PP|ADVP))$/ < (SYM|IN|VBG|VBN|TO|FW|RB|RBR $++ (/^(?:WH)?(?:NP|ADJP)(?:-TMP|-ADV)?$/=target !$- @NP) !< /^(?i:not)$/)", "/^PP(?:-TMP)?$/ < (/^(?:IN|VBG|VBN|TO)$/ $+ (ADVP=target [ < (RB < /^(?i:here|there)$/) | < (ADVP < /^NP(?:-TMP)?$/) ] ))", "PRT >- (VP !< (S < (VP < TO)) >+(SQ|SINV|S|VP) (SBARQ <, (WHNP=target !< WRB)) $-- (NP !< /^-NONE-$/))", "(PP <: IN|TO) >- (VP !< (S < (VP < TO)) >+(SQ|SINV|S|VP) (SBARQ <, (WHNP=target !< WRB)) $-- (NP !< /^-NONE-$/))", "(PP <: IN|TO) $- (NP $-- (VBZ|VBD) !$++ VP) >+(SQ) (SBARQ <, (WHNP=target !< WRB)) $-- (NP !< /^-NONE-$/)", "XS|ADVP < (IN < /^(?i:at)$/) < JJS|DT=target", "@PP < CC  < @NP=target !< @IN|TO|VBG|VBN|RB|RP|PP", "@WHPP|PP < (@WHPP|PP $++ (CC|CONJP $++ (@WHPP|PP $+ (NP=target !$+ __))))", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $++ (ADJP=adj < (PP !< NP)) $++ (NP $++ =adj)))");
    public static final GrammaticalRelation PREPOSITIONAL_COMPLEMENT = new GrammaticalRelation(Language.English, "pcomp", "prepositional complement", COMPLEMENT, "(?:WH)?PP(?:-TMP)?", tregexCompiler, "@PP|WHPP < (IN|VBG|VBN|TO $+ @SBAR|S|PP|ADVP=target)", "@PP|WHPP < (RB $+ @SBAR|S=target)", "@PP|WHPP !< IN|TO < (SBAR=target <, (IN $+ S))");
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.English, "ccomp", "clausal complement", COMPLEMENT, "VP|SINV|S|ADJP|ADVP|NP(?:-.*)?", tregexCompiler, "VP < (S=target < (VP !<, TO|VBG|VBN) !$-- NP)", "VP < (SBAR=target < (S <+(S) VP) <, (IN|DT < /^(?i:that|whether)$/))", "VP < (SBAR=target < (SBAR < (S <+(S) VP) <, (IN|DT < /^(?i:that|whether)$/)) < CC|CONJP)", "VP < (SBAR=target < (S < VP) !$-- NP !<, (IN|WHADVP) !<2 (IN|WHADVP $- ADVP|RB))", "VP < (/^V/ < /^(?i:tell|tells|told|telling)$/) < (SBAR=target < (S < VP) $-- NP !<, (IN|WHADVP) !<2 (IN|WHADVP $- ADVP|RB))", "VP < (SBAR=target < (S < VP) !$-- NP <, (WHADVP < (WRB < /^(?i:how)$/)))", "VP < @SBARQ=target", "VP < (/^VB/ < /^(?i:have|had|has|having|'ve|\u2019ve|ve|v|'d|\u2019d|d|hvae|hav|as)$/) < (S=target < @NP < VP)", "VP < (@SBAR=target !$-- @SBAR|S !$-- /^:$/ [ == @SBAR=sbar | <# @SBAR=sbar ] ) < (/^V/ < /^(?i:ask|asks|asked|asking|know|knows|knew|knowing|specify|specifies|specified|specifying|tell|tells|told|telling|understand|understands|understood|understanding|wonder|wonders|wondered|wondering)$/) [ < (/^V/ < /^(?i:tell|tells|told|telling)$/) | < (=target !$-- NP) ] : (=sbar < (WHADVP|WHNP < (WRB !< /^(?i:how)$/) !$-- /^(?!RB|ADVP).*$/) !< (S < (VP < TO)))", "@S|SINV < (@S|SBARQ=target $+ /^(,|\\.|'')$/ !$- /^(?:CC|CONJP|:)$/ !$- (/^(?:,)$/ $- CC|CONJP) !< (VP < TO|VBG|VBN) !< (VP <1 (VP [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]))) !< (@S !== =target $++ =target !$++ @CC|CONJP)", "ADVP < (SBAR=target [ < WHNP | ( < (IN < /^(?i:as|that)/) < (S < (VP !< TO))) ])", "ADJP < (SBAR=target !< (IN < as) < S)", "S <, (SBAR=target <, (IN < /^(?i:that|whether)$/) !$+ VP)", "@NP < JJ|NN|NNS < (SBAR=target [ !<(S < (VP < TO )) | !$-- NP|NN|NNP|NNS ] )", "VP < (/^V/ < /^(?i:say|says|said|saying|(?:add|boast|counsel|explain|inform|interject|recall|remark|respond|proclaim|report|claim|shout|whisper|yell)(?:s|ed|ing)?|(?:advis|announc|acknowledg|conced|conclud|decid|declar|observ|stat|not|inton)(?:e|es|ed|ing)|(?:confess)(?:es|ed|ing)?|(?:agree)(?:s|d|ing)?|reply|replied|replies|replying|admit|admits|admitted|admitting|hold|holds|holding|held|write|writes|writing|wrote|tell|tells|telling|told|quipped|quip|quips|quipping|think|thinks|thinking|thought)$/) < (S|S-CLF|S-TTL|SQ=target <+(S) (VP < /^VB[DZP]$/))", "@S < /^S-TPC/=target < VP");
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.English, "xcomp", "xclausal complement", COMPLEMENT, "VP|ADJP|SINV", tregexCompiler, "VP < (S=target [ !$-- NP | $-- (/^V/ < /^(?i:(?:allow|ask|demand|expect|help|order|prompt)(?:s|ed|ing)?|(?:advis|convinc|declar|defin|desir|encourag|forc|implor|nam|persuad|pressur|requir|urg)(?:e|es|ed|ing)|beg|begs|begged|begging|compel|compels|compelled|compelling|lobby|lobbies|lobbied|lobbying|permit|permits|permitted|permitting|tell|tells|told|telling)$/) ] !$- (NN < order) < (VP < TO))", "ADJP < (S=target <, (VP <, TO))", "VP < (S=target !$- (NN < order) < (NP $+ NP|ADJP))", "VP <# (/^(?:VB|AUX)/ $+ (VP=target < VB|VBG))", "VP < (SBAR=target < (S !$- (NN < order) < (VP < TO))) !> (VP < (VB|AUX < be)) ", "VP < (S=target !$- (NN < order) <: NP) > VP", "VP < (/^VB/ $+ (@S=target < (@ADJP < /^JJ/ ! $-- @NP|S))) $-- (/^VB/ < " + EnglishPatterns.copularWordRegex + " )", "(VP < (S=target < (VP < VBG ) !< NP !$- (/^,$/ [$- @NP|VP | $- (@PP $-- @NP ) |$- (@ADVP $-- @NP)]) !$-- /^:$/ !$-- VBG))", "(VP $-- (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") < (/^VB/ < " + "/^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/" + ") < NP=target)", "VP < (/^(?:VB|AUX)/ < /^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/) < (NP|WHNP=target [ [ !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) ] )  <# (__ !$++ (NP $++ (/^[:]$/ $++ =target))) ", "VP=vp < NP=target <(/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " >># =vp) !$ (NP < EX)", "SINV <# (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $-- (NP $-- NP=target))", "VP < (/^V/ < /^(?i:(?:allow|ask|demand|expect|help|order|prompt)(?:s|ed|ing)?|(?:advis|convinc|declar|defin|desir|encourag|forc|implor|nam|persuad|pressur|requir|urg)(?:e|es|ed|ing)|beg|begs|begged|begging|compel|compels|compelled|compelling|lobby|lobbies|lobbied|lobbying|permit|permits|permitted|permitting|tell|tells|told|telling)$/) < NP < (S=target < (VP < TO))");
    public static final GrammaticalRelation RELATIVE = new GrammaticalRelation(Language.English, "rel", "relative", COMPLEMENT, "SBAR|SBARQ", tregexCompiler, "SBAR < (WHNP=target !< WRB) < (S < NP < (VP [ < SBAR | <+(VP) (PP <- IN|TO) | < (S < (VP < TO)) ] ))", "SBARQ < (WHNP=target !< WRB !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) <+(SQ|SINV) (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$++ VP)");
    public static final GrammaticalRelation REFERENT = new GrammaticalRelation(Language.English, "ref", "referent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation EXPLETIVE = new GrammaticalRelation(Language.English, "expl", "expletive", GrammaticalRelation.DEPENDENT, "S|SQ|SINV", tregexCompiler, "S|SQ|SINV < (NP=target <+(NP) EX)");
    public static final GrammaticalRelation ADJECTIVAL_COMPLEMENT = new GrammaticalRelation(Language.English, "acomp", "adjectival complement", COMPLEMENT, "VP|SQ", tregexCompiler, "VP [ < ADJP=target | ( < (/^VB/ [ ( < /^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/ $++ VP=target ) | $+ (@S=target < (@ADJP < /^JJ/ ! $-- @NP|S)) ] ) !$-- (/^VB/ < " + EnglishPatterns.copularWordRegex + " )) ]", "SQ < (/^VB/ < " + EnglishPatterns.copularWordRegex + " $++ ADJP=target !$++ VP)");
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation(Language.English, "mod", "modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ADV_CLAUSE_MODIFIER = new GrammaticalRelation(Language.English, "advcl", "adverbial clause modifier", MODIFIER, "VP|S|SQ|SINV|SBARQ|NP|ADVP", tregexCompiler, "VP < (@SBAR=target <= (@SBAR [ < (IN !< /^(?i:that|whether)$/) | <: (SINV <1 /^(?:VB|MD|AUX)/) | < (RB|IN < so|now) < (IN < that) | <1 (ADVP < (RB < now)) <2 (IN < that) ] ))", "S|SQ|SINV < (SBAR|SBAR-TMP=target <, (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) !$-- /^(?!CC|CONJP|``|,|INTJ|PP(-.*)?).*$/ !$+ VP)", "S|SQ|SINV < (SBAR|SBAR-TMP=target <2 (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) !$-- /^(?!CC|CONJP|``|,|INTJ|PP(-.*)?$).*$/)", "S|SQ|SINV < (SBAR|SBAR-TMP=target <, (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) !$+ @VP $+ /^,$/ $++ @NP)", "SBARQ < (SBAR|SBAR-TMP|SBAR-ADV=target <, (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) $+ /^,$/ $++ @SQ|S|SBARQ)", "S|SQ < (@SBAR=target [ == @SBAR=sbar | <# @SBAR=sbar ] ): (=sbar < (WHADVP|WHNP < (WRB !< /^(?i:how)$/) !$-- /^(?!RB|ADVP).*$/) !< (S < (VP < TO)) !$-- /^:$/)", "VP < (@SBAR=target !$-- /^:$/ [ == @SBAR=sbar | <# @SBAR=sbar ] ) [ !< (/^V/ < /^(?i:ask|asks|asked|asking|know|knows|knew|knowing|specify|specifies|specified|specifying|tell|tells|told|telling|understand|understands|understood|understanding|wonder|wonders|wondered|wondering)$/) | < (=target $-- @SBAR|S) | ( !< (/^V/ < /^(?i:tell|tells|told|telling)$/) < (=target $-- NP)) ] : (=sbar < (WHADVP|WHNP < (WRB !< /^(?i:how)$/) !$-- /^(?!RB|ADVP).*$/) !< (S < (VP < TO)))", "@S < (@SBAR=target $++ @NP $++ @VP)", "@S < (@S=target < (VP < TO) $+ (/^,$/ $++ @NP))", "NP < (NP $++ (SBAR=target < (IN < /^(?i:than)$/) !< (WHPP|WHNP|WHADVP) < (S < (@NP $++ (VP !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$+ VP)  !<+(VP) (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " $+ (VP < VBN|VBD)) !<+(VP) NP !< SBAR !<+(VP) (PP <- IN|TO)))) !<: (S !< (VP < TO))) !$++ (CC $++ =target))", "ADVP < ADVP < SBAR=target");
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation(Language.English, "rcmod", "relative clause modifier", MODIFIER, "(?:WH)?(?:NP|NML|ADVP)(?:-.*)?", tregexCompiler, "@NP|WHNP|NML=np $++ (SBAR=target [ <+(SBAR) WHPP|WHNP | <: (S !< (VP < TO)) ]) !$-- @NP|WHNP|NML !$++ (FW < /^(?i:(etc|ect))$/) !$++ (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) > @NP|WHNP : (=np !$++ (CC|CONJP $++ =target))", "NP|NML $++ (SBAR=target < (WHADVP < (WRB </^(?i:where|why|when)/))) !$-- NP|NML !$++ (FW < /^(?i:(etc|ect))$/) !$++ (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) > @NP", "@NP|WHNP < RRC=target <# NP|WHNP|NML|DT|S", "@ADVP < (@ADVP < (RB < /where$/)) < @SBAR=target", "NP < (NP $++ (SBAR=target !< (IN < /^(?i:than|that|whether)$/) !< (WHPP|WHNP|WHADVP) < (S < (@NP $++ (VP !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$+ VP)  !<+(VP) (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " $+ (VP < VBN|VBD)) !<+(VP) NP !< SBAR !<+(VP) (PP <- IN|TO)))) !<: (S !< (VP < TO))) !$++ (CC $++ =target))");
    public static final GrammaticalRelation MARKER = new GrammaticalRelation(Language.English, "mark", "marker", MODIFIER, "SBAR(?:-TMP)?", tregexCompiler, "SBAR|SBAR-TMP < (IN|DT=target $++ S|FRAG)", "SBAR < (IN|DT=target < that|whether) [ $-- /^(?:VB|AUX)/ | $- NP|NN|NNS | > ADJP|PP | > (@NP|UCP|SBAR < CC|CONJP $-- /^(?:VB|AUX)/) ]");
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(Language.English, "amod", "adjectival modifier", MODIFIER, "NP(?:-TMP|-ADV)?|NX|NML|NAC|WHNP|ADJP", tregexCompiler, "/^(?:NP(?:-TMP|-ADV)?|NX|NML|NAC|WHNP)$/ < (ADJP|WHADJP|JJ|JJR|JJS|JJP|VBN|VBG|VBD|IN=target !< (QP !< /^[$]$/) !$- CC)", "ADJP !< CC|CONJP < (JJ|NNP $ JJ|NNP=target)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target <: CD $- /^,$/ $-- /^(?:WH)?NP/ !$ CC|CONJP)");
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(Language.English, "num", "numeric modifier", MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NML|NX|ADJP|WHADJP|QP", tregexCompiler, "/^(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?$/ < (CD|QP=target !$- CC)", "/^(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?$/ < (ADJP=target <: (QP !< /^[$]$/))", "QP < QP=target < /^[$]$/");
    public static final GrammaticalRelation NUMBER_MODIFIER = new GrammaticalRelation(Language.English, "number", "compound number modifier", MODIFIER, "QP|ADJP", tregexCompiler, "QP|ADJP < (/^(?:CD|$|#)$/=target !$- CC)");
    public static final GrammaticalRelation QUANTIFIER_MODIFIER = new GrammaticalRelation(Language.English, "quantmod", "quantifier modifier", MODIFIER, "QP", tregexCompiler, "QP < IN|RB|RBR|RBS|PDT|DT|JJ|JJR|JJS|XS=target");
    public static final GrammaticalRelation NOUN_COMPOUND_MODIFIER = new GrammaticalRelation(Language.English, "nn", "nn modifier", MODIFIER, "(?:WH)?(?:NP|NX|NAC|NML|ADVP|ADJP)(?:-TMP|-ADV)?", tregexCompiler, "/^(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?$/ < (NP|NML|NN|NNS|NNP|NNPS|FW|AFX=target $++ NN|NNS|NNP|NNPS|FW|CD=sister !<<- POS !<<- (VBZ < /^['\u2019]s$/) !$- /^,$/ !$++ (POS $++ =sister))", "/^(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?$/ < JJ|JJR|JJS=sister < (NP|NML|NN|NNS|NNP|NNPS|FW=target !<<- POS !<<- (VBZ < /^['\u2019]s$/) $+ =sister) <# NN|NNS|NNP|NNPS !<<- POS !<<- (VBZ < /^['\u2019]s$/) ", "ADJP|ADVP < (FW [ $- (FW=target !< /^(?i:etc)$/) | $- (IN=target < in|In) ] )");
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.English, "appos", "appositional modifier", MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?", tregexCompiler, "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target !<: CD $- /^,$/ $-- /^(?:WH)?NP/) !< CC|CONJP !< (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) !< (FW < /^(?i:(etc|ect))$/)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PRN=target < (NP < /^(?:NN|CD)/ $-- /^-LRB-$/ $+ /^-RRB-$/))", "@WHNP|NP < (NP=target !<: CD <, /^-LRB-$/ <` /^-RRB-$/ $-- /^(?:WH)?NP/ !$ CC|CONJP)", "NP|NP-TMP|NP-ADV < (NNP $+ (/^,$/ $+ NNP=target)) !< CC|CONJP !< (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) !< (FW < /^(?i:(etc|ect))$/)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PRN=target <, /^-LRB-$/ <- /^-RRB-$/ !<< /^(?:POS|(?:WP|PRP)\\$|[,$#]|CC|RB|CD)$/ <+(NP) (NNP|NN < /^(?:[A-Z]\\.?){2,}/) )", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target <: NNP $- (/^(?:WH)?NP/ !< POS)) !< CC|CONJP !< (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) !< (FW < /^(?i:(etc|ect))$/)");
    public static final GrammaticalRelation DISCOURSE_ELEMENT = new GrammaticalRelation(Language.English, "discourse", "discourse element", MODIFIER, ".*", tregexCompiler, "__ < (NFP=target [ < /^(?:[<>]?[:;=8][\\-o\\*'\u2019]?(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])|(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])[\\-o\\*'\u2019]?[:;=8][<>]?)$/ | < /(?!^--$)^(?:-LRB-|[(])?[\\-\\^x=~<>'\u2019][_.]?[\\-\\^x=~<>'\u2019](?:-RRB-|[)])?$/ ] )", "__ [ < INTJ=target | < (PRN=target <1 /^(?:,|-LRB-)$/ <2 INTJ [ !<3 __ | <3 /^(?:,|-RRB-)$/ ] ) ]");
    public static final GrammaticalRelation VERBAL_MODIFIER = new GrammaticalRelation(Language.English, "vmod", "verb modifier", MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NML|NX|VP|S|SINV|SBARQ", tregexCompiler, "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|NML|NX < (VP=target < VBG|VBN|VBD $-- @NP|NML|NX)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|NML|NX < (/^,$/ $+ (VP=target [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]))", "S|SINV < (S=target (< VP=verb | < (VP <1 VP=verb)) [ $- (/^,$/ [ $- @NP | $- (@PP $ @NP) ] ) | $+ (/^,$/ $+ @NP) ] ) : (=verb [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ])", "(VP < (@S=target < (VP [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]) $- (/^,$/ [$- @NP|VP | $- (@PP $-- @NP ) |$- (@ADVP $-- @NP)])))", "(VP < (S=target < (VP < VBG) $-- VBG=ing !$-- (/^[:]$/ $-- =ing)))", "VP < (S=target $-- NP < (VP < TO) !$-- (/^V/ < /^(?i:(?:allow|ask|demand|expect|help|order|prompt)(?:s|ed|ing)?|(?:advis|convinc|declar|defin|desir|encourag|forc|implor|nam|persuad|pressur|requir|urg)(?:e|es|ed|ing)|beg|begs|begged|begging|compel|compels|compelled|compelling|lobby|lobbies|lobbied|lobbying|permit|permits|permitted|permitting|tell|tells|told|telling)$/) )", "/^NP(?:-[A-Z]+)?$/ < (S=target < (VP < TO) $-- NP|NN|NNP|NNS)", "/^NP(?:-[A-Z]+)?$/ < (SBAR=target < (S < (VP < TO)) $-- NP|NN|NNP|NNS)", "SBARQ < WHNP < (S=target < (VP <1 TO))");
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.English, "advmod", "adverbial modifier", MODIFIER, "VP|ADJP|WHADJP|ADVP|WHADVP|S|SBAR|SINV|SQ|SBARQ|XS|(?:WH)?(?:PP|NP)(?:-TMP|-ADV)?|RRC|CONJP|JJP", tregexCompiler, "/^(?:VP|ADJP|JJP|WHADJP|SQ?|SBARQ?|SINV|XS|RRC|(?:WH)?NP(?:-TMP|-ADV)?)$/ < (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< /^(?i:n[o'\u2019]?t|never)$/ !< (FW < /^(?i:(etc|ect))$/))", "ADVP|WHADVP < (RB|RBR|RBS|WRB|ADVP|WHADVP|JJ=target !< /^(?i:n[o'\u2019]?t|never)$/ !< /^(?i:no)$/ !< (FW < /^(?i:(etc|ect))$/)) [ !< /^CC|CONJP$/ | ( <#__=head !< (/^CC|CONJP$/ [ ($++ =head $-- =target) | ($-- =head $++ =target) ])) ]", "SBAR < (WHNP=target < WRB)", "SBARQ <, WHADVP=target", "XS < JJ=target", "/(?:WH)?PP(?:-TMP|-ADV)?$/ <# (__ $-- (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< /^(?i:n[o'\u2019]?t|never)$/ !< (FW < /^(?i:(etc|ect))$/)))", "/(?:WH)?PP(?:-TMP|-ADV)?$/ < @NP|WHNP < (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< /^(?i:n[o'\u2019]?t|never)$/ !< (FW < /^(?i:(etc|ect))$/))", "CONJP < (RB=target !< /^(?i:n[o'\u2019]?t|never)$/ !< (FW < /^(?i:(etc|ect))$/))", "ADJP < (JJ|JJR|JJS=target $. JJ|JJR|JJS !< /^[A-Z]/) <# JJ|JJR|JJS !< (CC|CONJP)");
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation(Language.English, "neg", "negation modifier", ADVERBIAL_MODIFIER, "VP|ADJP|S|SBAR|SINV|SQ|NP(?:-TMP|-ADV)?|FRAG|CONJP|PP|NAC|NML|NX|ADVP|WHADVP", tregexCompiler, "/^(?:VP|NP(?:-TMP|-ADV)?|ADJP|SQ|S|FRAG|CONJP|PP)$/< (RB=target < /^(?i:n[o'\u2019]?t|never)$/)", "VP|ADJP|S|SBAR|SINV|FRAG < (ADVP=target <# (RB < /^(?i:n[o'\u2019]?t|never)$/))", "VP > SQ $-- (RB=target < /^(?i:n[o'\u2019]?t|never)$/)", "/^(?:NP(?:-TMP|-ADV)?|NAC|NML|NX|ADJP|ADVP)$/ < (DT|RB=target < /^(?i:no)$/  $++ /^(?:N[MNXP]|CD|JJ|JJR|FW|ADJP|QP|RB|RBR|PRP(?![$])|PRN)/ )", "ADVP|WHADVP < (RB|RBR|RBS|WRB|ADVP|WHADVP|JJ=target < /^(?i:no)$/) !< CC|CONJP");
    public static final GrammaticalRelation NP_ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.English, "npadvmod", "noun phrase adverbial modifier", MODIFIER, "VP|(?:WH)?(?:NP|ADJP|ADVP|PP)(?:-TMP|-ADV)?", tregexCompiler, "@ADVP|ADJP|WHADJP|WHADVP|PP|WHPP <# (JJ|JJR|IN|RB|RBR !< notwithstanding $- (@NP=target !< NNP|NNPS))", "@ADJP < (NN=target $++ /^JJ/) !< CC|CONJP", "@NP|WHNP < /^NP-ADV/=target", "@NP|WHNP [ < (NP=target <: (PRP < /^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/)) | < (PRP=target < /^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/) ] : (=target $-- NP|NN|NNS|NNP|NNPS|PRP=noun !$-- (/^,|CC|CONJP$/ $-- =noun))", "@NP <1 (@NP <<# /^%$/) <2 (@NP=target <<# days|month|months) !<3 __", "@VP < /^NP-ADV/=target", "@ADJP > @NP < (@NP|NN|NNP|NNS|NNPS=target . (HYPH . VBN|VBG))");
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation(Language.English, "tmod", "temporal modifier", NP_ADVERBIAL_MODIFIER, "VP|S|ADJP|PP|SBAR|SBARQ|NP|RRC", tregexCompiler, "VP|ADJP|RRC [ < NP-TMP=target | < (VP=target <# NP-TMP !$ /^,|CC|CONJP$/) | < (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$+ (/^JJ/ < old)) ]", "@PP < (IN|TO|VBG|FW $++ (@NP [ $+ NP-TMP=target | $+ (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) ]))", "S < (NP-TMP=target $++ VP $ NP )", "S < (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) $++ (NP $++ VP))", "SBAR < (@WHADVP < (WRB < when)) < (S < (NP $+ (VP !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$+ VP) ))) !$-- CC $-- NP > NP=target", "SBARQ < (@WHNP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) < (SQ < @NP)", "NP < NP-TMP=target");
    public static final GrammaticalRelation MULTI_WORD_EXPRESSION = new GrammaticalRelation(Language.English, "mwe", "multi-word expression", MODIFIER, "PP|XS|ADVP|CONJP", tregexCompiler, "PP|XS < (IN|TO < as|of|at|to|in) < (JJ|IN|JJR|JJS|NN=target < such|because|Because|least|instead|due|Due|addition|to)", "ADVP < (RB|IN < well) < (IN|RB|JJS=target < as)", "ADVP < (DT=target < all) < (CC < but)", "CONJP < (RB < rather|well|instead) < (RB|IN=target < as|than|of)", "CONJP < (IN < in) < (NN|TO=target < addition|to)", "XS < JJR|JJS=target");
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(Language.English, "det", "determiner", MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NAC|NML|NX|X|ADVP|ADJP", tregexCompiler, "/^(?:NP(?:-TMP|-ADV)?|NAC|NML|NX|X)$/ < (DT=target !< /^(?i:either|neither|both|no)$/ !$+ DT !$++ CC $++ /^(?:N[MNXP]|CD|JJ|FW|ADJP|QP|RB|PRP(?![$])|PRN)/=det !$++ (/^PRP[$]|POS/ $++ =det !$++ (/''/ $++ =det)))", "NP|NP-TMP|NP-ADV < (DT=target [ (< /^(?i:either|neither|both)$/ !$+ DT !$++ CC $++ /^(?:NN|NX|NML)/ !$++ (NP < CC)) | (!< /^(?i:either|neither|both|no)$/ $++ CC $++ /^(?:NN|NX|NML)/) | (!< /^(?i:no)$/ $++ (/^JJ/ !$+ /^NN/) !$++CC !$+ DT) ] )", "NP|NP-TMP|NP-ADV <<, PRP <- (NP|DT|RB=target <<- all|both|each)", "WHNP < (NP $-- (WHNP=target < WDT))", "@WHNP|ADVP|ADJP < (/^(?:NP|NN|CD|RBS|JJ)/ $-- (DT|WDT|WP=target !< /^(?i:no)$/ [ ==WDT|WP | !$++ CC|CONJP ]))", "@NP < (/^(?:NP|NN|CD|RBS)/ $-- WDT|WP=target)");
    public static final GrammaticalRelation PREDETERMINER = new GrammaticalRelation(Language.English, "predet", "predeterminer", MODIFIER, "(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?", tregexCompiler, "/^(?:(?:WH)?NP(?:-TMP|-ADV)?|NX|NAC|NML)$/ < (PDT|DT=target $+ /^(?:DT|WP\\$|PRP\\$)$/ $++ /^(?:NN|NX|NML)/ !$++ CC)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PDT|DT=target $+ DT $++ (/^JJ/ !$+ /^NN/)) !$++ CC", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < PDT=target <- DT");
    public static final GrammaticalRelation PRECONJUNCT = new GrammaticalRelation(Language.English, "preconj", "preconjunct", MODIFIER, "S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR|NP(?:-TMP|-ADV)?", tregexCompiler, "NP|NP-TMP|NP-ADV|NX|NML < (PDT|CC|DT=target < /^(?i:either|neither|both)$/ $++ CC)", "NP|NP-TMP|NP-ADV|NX|NML < (CONJP=target < (RB < /^(?i:not)$/) < (RB|JJ < /^(?i:only|merely|just)$/) $++ CC|CONJP)", "NP|NP-TMP|NP-ADV|NX|NML < (PDT|CC|DT=target < /^(?i:either|neither|both)$/ ) < (NP < CC)", "/^S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR$/ < (PDT|DT|CC=target < /^(?i:either|neither|both)$/ $++ CC)", "/^S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR$/ < (CONJP=target < (RB < /^(?i:not)$/) < (RB|JJ < /^(?i:only|merely|just)$/) $++ CC|CONJP)");
    public static final GrammaticalRelation POSSESSION_MODIFIER = new GrammaticalRelation(Language.English, "poss", "possession modifier", MODIFIER, "(?:WH)?(NP|ADJP|INTJ|PRN|NAC|NX|NML)(?:-.*)?", tregexCompiler, "/^(?:WH)?(?:NP|INTJ|ADJP|PRN|NAC|NX|NML)(?:-.*)?$/ < /^(?:WP\\$|PRP\\$)$/=target", "/^(?:WH)?(?:NP|NML)(?:-.*)?$/ [ < (WHNP|WHNML|NP|NML=target [ < POS | < (VBZ < /^['\u2019]s$/) ] ) !< (CC|CONJP $++ WHNP|WHNML|NP|NML) |  < (WHNP|WHNML|NP|NML=target < (CC|CONJP $++ WHNP|WHNML|NP|NML) < (WHNP|WHNML|NP|NML [ < POS | < (VBZ < /^['\u2019]s$/) ] )) ]", "/^(?:WH)?(?:NP|NML|NX)(?:-.*)?$/ < (/^NN|NP/=target $++ (POS=pos < /['\u2019]/ $++ /^NN/) !$++ (/^NN|NP/ $++ =pos))");
    public static final GrammaticalRelation POSSESSIVE_MODIFIER = new GrammaticalRelation(Language.English, "possessive", "possessive modifier", MODIFIER, "(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?", tregexCompiler, "/^(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?$/ < POS=target", "/^(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?$/ < (VBZ=target < /^['\u2019]s$/)");
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.English, "prep", "prepositional modifier", MODIFIER, ".*", tregexCompiler, "/^(?:(?:WH)?(?:NP|ADJP|ADVP|NX|NML)(?:-TMP|-ADV)?|VP|NAC|SQ|FRAG|PRN|X|RRC)$/ < (WHPP|WHPP-TMP|PP|PP-TMP=target !$- (@CC|CONJP $- __)) !<- (FW < /^(?i:(etc|ect))$/) !<- (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))", "/^(?:(?:WH)?(?:NP|ADJP|ADVP|NX|NML)(?:-TMP|-ADV)?|VP|NAC|SQ|FRAG|PRN|X|RRC)$/ < (S=target <: WHPP|WHPP-TMP|PP|PP-TMP)", "WHPP|WHPP-TMP|WHPP-ADV|PP|PP-TMP|PP-ADV < (WHPP|WHPP-TMP|WHPP-ADV|PP|PP-TMP|PP-ADV=target !$- IN|VBG|VBN|TO) !< @CC|CONJP", "S|SINV < (PP|PP-TMP=target !< SBAR) < VP|S", "SBAR|SBARQ < /^(?:WH)?PP/=target < S|SQ", "@NP < (@UCP|PRN=target <# @PP)");
    public static final GrammaticalRelation PHRASAL_VERB_PARTICLE = new GrammaticalRelation(Language.English, "prt", "phrasal verb particle", MODIFIER, "VP|ADJP", tregexCompiler, "VP < PRT=target", "ADJP < /^VB/ < RP=target");
    public static final GrammaticalRelation PARATAXIS = new GrammaticalRelation(Language.English, "parataxis", "parataxis", GrammaticalRelation.DEPENDENT, "S|VP", tregexCompiler, "VP < (PRN=target < S|SINV|SBAR)", "VP $ (PRN=target [ < S|SINV|SBAR | < VP < @NP ] )", "S|VP < (/^:$/ $+ /^S/=target) !<, (__ $++ CC|CONJP)", "@S < (@S|SBARQ $++ @S|SBARQ=target !$++ @CC|CONJP)", "@S|VP < (/^:$/ $-- /^V/ $+ @NP=target) !< @CONJP|CC");
    public static final GrammaticalRelation GOES_WITH = new GrammaticalRelation(Language.English, "goeswith", "goes with", MODIFIER, ".*", tregexCompiler, "__ < GW=target");
    public static final GrammaticalRelation SEMANTIC_DEPENDENT = new GrammaticalRelation(Language.English, "sdep", "semantic dependent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation AGENT = new GrammaticalRelation(Language.English, "agent", "agent", GrammaticalRelation.DEPENDENT);
    private static final List<GrammaticalRelation> values = Generics.newArrayList(Arrays.asList(GrammaticalRelation.GOVERNOR, GrammaticalRelation.DEPENDENT, PREDICATE, AUX_MODIFIER, AUX_PASSIVE_MODIFIER, COPULA, CONJUNCT, COORDINATION, PUNCTUATION, ARGUMENT, SUBJECT, NOMINAL_SUBJECT, NOMINAL_PASSIVE_SUBJECT, CLAUSAL_SUBJECT, CLAUSAL_PASSIVE_SUBJECT, COMPLEMENT, OBJECT, DIRECT_OBJECT, INDIRECT_OBJECT, PREPOSITIONAL_OBJECT, PREPOSITIONAL_COMPLEMENT, CLAUSAL_COMPLEMENT, XCLAUSAL_COMPLEMENT, MARKER, RELATIVE, REFERENT, EXPLETIVE, ADJECTIVAL_COMPLEMENT, MODIFIER, ADV_CLAUSE_MODIFIER, TEMPORAL_MODIFIER, RELATIVE_CLAUSE_MODIFIER, NUMERIC_MODIFIER, ADJECTIVAL_MODIFIER, NOUN_COMPOUND_MODIFIER, APPOSITIONAL_MODIFIER, VERBAL_MODIFIER, ADVERBIAL_MODIFIER, NEGATION_MODIFIER, MULTI_WORD_EXPRESSION, DETERMINER, PREDETERMINER, PRECONJUNCT, POSSESSION_MODIFIER, POSSESSIVE_MODIFIER, PREPOSITIONAL_MODIFIER, PHRASAL_VERB_PARTICLE, SEMANTIC_DEPENDENT, AGENT, NUMBER_MODIFIER, QUANTIFIER_MODIFIER, NP_ADVERBIAL_MODIFIER, PARATAXIS, DISCOURSE_ELEMENT, GOES_WITH));
    private static final List<GrammaticalRelation> synchronizedValues = Collections.synchronizedList(values);
    private static final List<GrammaticalRelation> unmodifiableSynchronizedValues = Collections.unmodifiableList(values);
    public static final ReadWriteLock valuesLock = new ReentrantReadWriteLock();
    public static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();
    private static final Map<String, GrammaticalRelation> conjs;
    private static final Map<String, GrammaticalRelation> preps;
    private static final Map<String, GrammaticalRelation> prepsC;

    private EnglishGrammaticalRelations() {
    }

    public static List<GrammaticalRelation> values() {
        return unmodifiableSynchronizedValues;
    }

    public static Lock valuesLock() {
        return valuesLock.readLock();
    }

    private static void threadSafeAddRelation(GrammaticalRelation relation) {
        valuesLock.writeLock().lock();
        try {
            synchronizedValues.add(relation);
            shortNameToGRel.put(relation.toString(), relation);
        }
        finally {
            valuesLock.writeLock().unlock();
        }
    }

    public static Collection<GrammaticalRelation> getConjs() {
        return conjs.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getConj(String conjunctionString) {
        GrammaticalRelation result = conjs.get(conjunctionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = conjs;
            synchronized (map) {
                result = conjs.get(conjunctionString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.English, "conj", "conj_collapsed", CONJUNCT, conjunctionString);
                    conjs.put(conjunctionString, result);
                    EnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    public static Collection<GrammaticalRelation> getPreps() {
        return preps.values();
    }

    public static Collection<GrammaticalRelation> getPrepsC() {
        return prepsC.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getPrep(String prepositionString) {
        GrammaticalRelation result = preps.get(prepositionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = preps;
            synchronized (map) {
                result = preps.get(prepositionString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.English, "prep", "prep_collapsed", PREPOSITIONAL_MODIFIER, prepositionString);
                    preps.put(prepositionString, result);
                    EnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getPrepC(String prepositionString) {
        GrammaticalRelation result = prepsC.get(prepositionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = prepsC;
            synchronized (map) {
                result = prepsC.get(prepositionString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.English, "prepc", "prepc_collapsed", GrammaticalRelation.DEPENDENT, prepositionString);
                    prepsC.put(prepositionString, result);
                    EnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(s, synchronizedValues, EnglishGrammaticalRelations.valuesLock());
    }

    public static GrammaticalRelation valueOf(Object o) {
        if (o instanceof GrammaticalRelation) {
            return (GrammaticalRelation)o;
        }
        if (o instanceof String) {
            return EnglishGrammaticalRelations.valueOf((String)o);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(GrammaticalRelation.DEPENDENT.toPrettyString());
    }

    static {
        EnglishGrammaticalRelations.valuesLock().lock();
        try {
            for (GrammaticalRelation gr : EnglishGrammaticalRelations.values()) {
                shortNameToGRel.put(gr.toString().toLowerCase(), gr);
            }
        }
        finally {
            EnglishGrammaticalRelations.valuesLock().unlock();
        }
        conjs = Generics.newConcurrentHashMap();
        preps = Generics.newConcurrentHashMap();
        prepsC = Generics.newConcurrentHashMap();
    }
}

