/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.ComplexNodePattern;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Pattern;

public class CoreMapNodePattern
extends ComplexNodePattern<CoreMap, Class> {
    public static final AttributesEqualMatchChecker TEXT_ATTR_EQUAL_CHECKER = new AttributesEqualMatchChecker(CoreAnnotations.TextAnnotation.class);

    private static BiFunction<CoreMap, Class, Object> createGetter() {
        return new BiFunction<CoreMap, Class, Object>(){

            @Override
            public Object apply(CoreMap m, Class k) {
                return m.get(k);
            }
        };
    }

    public CoreMapNodePattern(List<Pair<Class, NodePattern>> annotationPatterns) {
        super(CoreMapNodePattern.createGetter(), annotationPatterns);
    }

    public CoreMapNodePattern(Pair<Class, NodePattern> ... annotationPatterns) {
        super(CoreMapNodePattern.createGetter(), annotationPatterns);
    }

    public CoreMapNodePattern(Class key, NodePattern pattern) {
        this(Pair.makePair(key, pattern));
    }

    public static CoreMapNodePattern valueOf(String textAnnotationPattern) {
        return CoreMapNodePattern.valueOf(null, textAnnotationPattern);
    }

    public static CoreMapNodePattern valueOf(String textAnnotationPattern, int flags) {
        CoreMapNodePattern p = new CoreMapNodePattern(new ArrayList<Pair<Class, NodePattern>>(1));
        p.add(CoreAnnotations.TextAnnotation.class, CoreMapNodePattern.newStringRegexPattern(textAnnotationPattern, flags));
        return p;
    }

    public static CoreMapNodePattern valueOf(Env env, String textAnnotationPattern) {
        CoreMapNodePattern p = new CoreMapNodePattern(new ArrayList<Pair<Class, NodePattern>>(1));
        p.add(CoreAnnotations.TextAnnotation.class, CoreMapNodePattern.newStringRegexPattern(textAnnotationPattern, env != null ? env.defaultStringPatternFlags : 0));
        return p;
    }

    public static CoreMapNodePattern valueOf(Pattern textAnnotationPattern) {
        CoreMapNodePattern p = new CoreMapNodePattern(new ArrayList<Pair<Class, NodePattern>>(1));
        p.add(CoreAnnotations.TextAnnotation.class, new ComplexNodePattern.StringAnnotationRegexPattern(textAnnotationPattern));
        return p;
    }

    public static CoreMapNodePattern valueOf(Map<String, String> attributes) {
        return CoreMapNodePattern.valueOf(null, attributes);
    }

    public static CoreMapNodePattern valueOf(Env env, Map<String, String> attributes) {
        CoreMapNodePattern p = new CoreMapNodePattern(new ArrayList<Pair<Class, NodePattern>>(attributes.size()));
        p.populate(env, attributes, envAttrPair -> EnvLookup.lookupAnnotationKeyWithClassname((Env)envAttrPair.first, (String)envAttrPair.second));
        return p;
    }

    public static class AttributesEqualMatchChecker<K>
    implements SequencePattern.NodesMatchChecker<CoreMap> {
        Collection<Class> keys;

        public AttributesEqualMatchChecker(Class ... keys) {
            this.keys = CollectionUtils.asSet(keys);
        }

        @Override
        public boolean matches(CoreMap o1, CoreMap o2) {
            for (Class key : this.keys) {
                Object v1 = o1.get(key);
                Object v2 = o2.get(key);
                if (!(v1 != null ? !v1.equals(v2) : v2 != null)) continue;
                return false;
            }
            return true;
        }
    }
}

