/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.process.SerializableFunction;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexParseException;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public abstract class TregexPoweredTreebankParserParams
extends AbstractTreebankParserParams {
    private static Redwood.RedwoodChannels log = Redwood.channels(TregexPoweredTreebankParserParams.class);
    private static final long serialVersionUID = -1985603901694682420L;
    private final Map<String, Pair<TregexPattern, Function<TregexMatcher, String>>> annotationPatterns = Generics.newHashMap();
    protected final Map<String, Pair<String, Function<TregexMatcher, String>>> annotations = Generics.newHashMap();
    private final Collection<String> features = CollectionUtils.asSet(this.baselineAnnotationFeatures());

    protected abstract String[] baselineAnnotationFeatures();

    public TregexPoweredTreebankParserParams(TreebankLanguagePack tlp) {
        super(tlp);
    }

    protected void compileAnnotations(HeadFinder hf) {
        TregexPatternCompiler compiler = new TregexPatternCompiler(hf);
        this.annotationPatterns.clear();
        for (Map.Entry<String, Pair<String, Function<TregexMatcher, String>>> annotation : this.annotations.entrySet()) {
            TregexPattern compiled;
            try {
                compiled = compiler.compile(annotation.getValue().first());
            }
            catch (TregexParseException e) {
                int nth = this.annotationPatterns.size() + 1;
                log.info("Parse exception on annotation pattern #" + nth + " initialization: " + e);
                continue;
            }
            Pair<TregexPattern, Function<TregexMatcher, String>> behavior = new Pair<TregexPattern, Function<TregexMatcher, String>>(compiled, annotation.getValue().second());
            this.annotationPatterns.put(annotation.getKey(), behavior);
        }
    }

    protected void addFeature(String featureName) {
        if (!this.annotations.containsKey(featureName)) {
            throw new IllegalArgumentException("Invalid feature name '" + featureName + "'");
        }
        if (!this.annotationPatterns.containsKey(featureName)) {
            throw new RuntimeException("Compiled patterns out of sync with annotations data structure;did you call compileAnnotations?");
        }
        this.features.add(featureName);
    }

    protected void removeFeature(String featureName) {
        this.features.remove(featureName);
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        String newCat = t.value() + this.getAnnotationString(t, root);
        t.setValue(newCat);
        if (t.isPreTerminal() && t.label() instanceof HasTag) {
            ((HasTag)((Object)t.label())).setTag(newCat);
        }
        return t;
    }

    protected String getAnnotationString(Tree t, Tree root) {
        StringBuilder annotationStr = new StringBuilder();
        for (String featureName : this.features) {
            Pair<TregexPattern, Function<TregexMatcher, String>> behavior = this.annotationPatterns.get(featureName);
            TregexMatcher m = behavior.first().matcher(root);
            if (!m.matchesAt(t)) continue;
            annotationStr.append(behavior.second().apply(m));
        }
        return annotationStr.toString();
    }

    @Override
    public void display() {
        for (String feature : this.features) {
            System.err.printf("%s ", feature);
        }
        log.info(new Object[0]);
    }

    protected static class AnnotateHeadFunction
    implements SerializableFunction<TregexMatcher, String> {
        private static final long serialVersionUID = -4213299755069618322L;
        private final HeadFinder headFinder;
        private boolean lowerCase;

        public AnnotateHeadFunction(HeadFinder hf) {
            this(hf, true);
        }

        public AnnotateHeadFunction(HeadFinder hf, boolean lowerCase) {
            this.headFinder = hf;
            this.lowerCase = lowerCase;
        }

        @Override
        public String apply(TregexMatcher matcher) {
            Tree matchedTree = matcher.getMatch();
            Tree head = this.headFinder.determineHead(matchedTree);
            if (!head.isPrePreTerminal()) {
                return "";
            }
            Tree lexicalHead = head.firstChild().firstChild();
            String headValue = lexicalHead.value();
            if (headValue != null) {
                if (this.lowerCase) {
                    headValue = headValue.toLowerCase();
                }
                return '[' + headValue + ']';
            }
            return "";
        }

        public String toString() {
            return "AnnotateHeadFunction[" + this.headFinder.getClass().getName() + ']';
        }
    }

    protected static class SimpleStringFunction
    implements SerializableFunction<TregexMatcher, String> {
        private static final long serialVersionUID = 6958776731059724396L;
        private String annotationMark;

        public SimpleStringFunction(String annotationMark) {
            this.annotationMark = annotationMark;
        }

        @Override
        public String apply(TregexMatcher matcher) {
            return this.annotationMark;
        }

        public String toString() {
            return "SimpleStringFunction[" + this.annotationMark + ']';
        }
    }
}

