/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.ud.CoNLLUUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoNLLUDocumentWriter {
    private static final String LRB_PATTERN = "(?i)-LRB-";
    private static final String RRB_PATTERN = "(?i)-RRB-";

    public String printSemanticGraph(SemanticGraph basicSg) {
        return this.printSemanticGraph(basicSg, null, true);
    }

    public String printSemanticGraph(SemanticGraph basicSg, SemanticGraph enhancedSg) {
        return this.printSemanticGraph(basicSg, enhancedSg, true);
    }

    public String printSemanticGraph(SemanticGraph basicSg, SemanticGraph enhancedSg, boolean unescapeParenthesis) {
        StringBuilder sb = new StringBuilder();
        for (String comment : basicSg.getComments()) {
            sb.append(comment).append(System.lineSeparator());
        }
        SemanticGraph tokenSg = enhancedSg != null ? enhancedSg : basicSg;
        for (IndexedWord token : tokenSg.vertexListSorted()) {
            String relnName;
            IntPair tokenSpan;
            if (token.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class) && (tokenSpan = (IntPair)token.get(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)).getSource() == token.index()) {
                String range = String.format("%d-%d", tokenSpan.getSource(), tokenSpan.getTarget());
                sb.append(String.format("%s\t%s\t_\t_\t_\t_\t_\t_\t_\t_%n", range, token.originalText()));
            }
            IndexedWord gov = basicSg.containsVertex(token) ? basicSg.getParent(token) : null;
            String govIdx = gov != null ? gov.toCopyIndex() : null;
            GrammaticalRelation reln = gov != null ? basicSg.getEdge(gov, token).getRelation() : null;
            HashMap<String, String> enhancedDependencies = new HashMap<String, String>();
            if (enhancedSg != null) {
                for (IndexedWord parent : enhancedSg.getParents(token)) {
                    SemanticGraphEdge edge = enhancedSg.getEdge(parent, token);
                    String relationString = edge.getRelation().toString();
                    enhancedDependencies.put(parent.toCopyIndex(), relationString);
                }
            } else {
                HashMap secondaryDeps = (HashMap)token.get(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class);
                if (secondaryDeps != null) {
                    enhancedDependencies.putAll((Map)token.get(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class));
                    if (gov != null) {
                        enhancedDependencies.put(govIdx, reln.toString());
                    }
                }
            }
            String additionalDepsString = CoNLLUUtils.toExtraDepsString(enhancedDependencies);
            String word = token.word();
            String featuresString = CoNLLUUtils.toFeatureString((HashMap)token.get(CoreAnnotations.CoNLLUFeats.class));
            String pos = token.getString(CoreAnnotations.PartOfSpeechAnnotation.class, "_");
            String upos = token.getString(CoreAnnotations.CoarseTagAnnotation.class, "_");
            String misc = token.getString(CoreAnnotations.CoNLLUMisc.class, "_");
            String lemma = token.getString(CoreAnnotations.LemmaAnnotation.class, "_");
            String string = relnName = reln == null ? "_" : reln.toString();
            if (govIdx == null && basicSg.getRoots().contains(token)) {
                govIdx = "0";
                relnName = GrammaticalRelation.ROOT.toString();
            } else if (govIdx == null) {
                govIdx = "_";
                relnName = "_";
            }
            if (enhancedSg != null && enhancedSg.getRoots().contains(token)) {
                additionalDepsString = enhancedDependencies.isEmpty() ? "0:root" : "0:root|" + additionalDepsString;
            }
            if (unescapeParenthesis) {
                word = word.replaceAll(LRB_PATTERN, "(");
                word = word.replaceAll(RRB_PATTERN, ")");
                lemma = lemma.replaceAll(LRB_PATTERN, "(");
                lemma = lemma.replaceAll(RRB_PATTERN, ")");
            }
            sb.append(String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s%n", token.toCopyIndex(), word, lemma, upos, pos, featuresString, govIdx, relnName, additionalDepsString, misc));
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public String printPOSAnnotations(CoreMap sentence) {
        StringBuilder sb = new StringBuilder();
        for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
            String upos = token.getString(CoreAnnotations.CoarseTagAnnotation.class, "_");
            String lemma = token.getString(CoreAnnotations.LemmaAnnotation.class, "_");
            String pos = token.getString(CoreAnnotations.PartOfSpeechAnnotation.class, "_");
            String featuresString = CoNLLUUtils.toFeatureString((HashMap)token.get(CoreAnnotations.CoNLLUFeats.class));
            String misc = token.getString(CoreAnnotations.CoNLLUMisc.class, "_");
            sb.append(String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s%n", token.index(), token.word(), lemma, upos, pos, featuresString, "_", "_", "_", misc));
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }
}

