/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.OutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JHandler
extends OutputHandler {
    private static Pair<Logger, Redwood.Flag> getLoggerAndLevel(Object[] channel) {
        Pair<String, Redwood.Flag> pair = SLF4JHandler.getSourceStringAndLevel(channel);
        Logger impl = LoggerFactory.getLogger((String)pair.first());
        return Pair.makePair(impl, pair.second());
    }

    @Override
    public List<Redwood.Record> handle(Redwood.Record record) {
        Pair<Logger, Redwood.Flag> loggerAndLevel = SLF4JHandler.getLoggerAndLevel(record.channels());
        switch ((Redwood.Flag)((Object)loggerAndLevel.second)) {
            case FORCE: {
                break;
            }
            case ERROR: {
                if (((Logger)loggerAndLevel.first).isErrorEnabled()) break;
                return Collections.emptyList();
            }
            case WARN: {
                if (((Logger)loggerAndLevel.first).isWarnEnabled()) break;
                return Collections.emptyList();
            }
            case DEBUG: {
                if (((Logger)loggerAndLevel.first).isDebugEnabled()) break;
                return Collections.emptyList();
            }
            default: {
                if (((Logger)loggerAndLevel.first).isInfoEnabled()) break;
                return Collections.emptyList();
            }
        }
        return super.handle(record);
    }

    @Override
    public void print(Object[] channel, String line) {
        Pair<Logger, Redwood.Flag> loggerAndLevel = SLF4JHandler.getLoggerAndLevel(channel);
        if (line.length() > 0 && line.charAt(line.length() - 1) == '\n') {
            line = line.substring(0, line.length() - 1);
        }
        switch ((Redwood.Flag)((Object)loggerAndLevel.second)) {
            case ERROR: {
                ((Logger)loggerAndLevel.first).error(line);
                break;
            }
            case WARN: {
                ((Logger)loggerAndLevel.first).warn(line);
                break;
            }
            case DEBUG: {
                ((Logger)loggerAndLevel.first).debug(line);
                break;
            }
            case STDOUT: 
            case STDERR: {
                ((Logger)loggerAndLevel.first).info(line);
                break;
            }
            case FORCE: {
                throw new IllegalStateException("Should not reach this switch case");
            }
            default: {
                throw new IllegalStateException("Unknown Redwood flag for slf4j integration: " + loggerAndLevel.second);
            }
        }
    }
}

