/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.io.InputStream;
import java.util.StringTokenizer;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.Xid;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.omg.CosTransactions.TransactionFactory;
import org.xml.sax.InputSource;
import tyrex.resource.Resources;
import tyrex.resource.castor.ResourceMappingLoader;
import tyrex.tm.DomainConfigurationException;
import tyrex.tm.DomainMetrics;
import tyrex.tm.RecoveryException;
import tyrex.tm.TransactionInterceptor;
import tyrex.tm.impl.DomainConfig;
import tyrex.tm.impl.TransactionDomainImpl;
import tyrex.tm.impl.TransactionImpl;
import tyrex.util.Configuration;
import tyrex.util.Logger;

public abstract class TransactionDomain {
    public static final int READY = 0;
    public static final int RECOVERING = 1;
    public static final int ACTIVE = 2;
    public static final int TERMINATED = 3;
    private static TransactionDomainImpl _firstDomain;
    static /* synthetic */ Class class$tyrex$tm$impl$DomainConfig;

    public static synchronized TransactionDomain getDomain(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Argument name is null or an empty string");
        }
        TransactionDomainImpl transactionDomainImpl = _firstDomain;
        while (transactionDomainImpl != null) {
            if (transactionDomainImpl.getDomainName().equals(string)) {
                return transactionDomainImpl;
            }
            transactionDomainImpl = transactionDomainImpl.getNextDomain();
        }
        return null;
    }

    public static TransactionDomain createDomain(String string) throws DomainConfigurationException {
        if (string == null) {
            throw new IllegalArgumentException("Argument url is null");
        }
        return TransactionDomain.createDomain(new InputSource(string), false);
    }

    public static TransactionDomain createDomain(InputStream inputStream) throws DomainConfigurationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument stream is null");
        }
        return TransactionDomain.createDomain(new InputSource(inputStream), false);
    }

    public static synchronized TransactionDomain createDomain(InputSource inputSource) throws DomainConfigurationException {
        return TransactionDomain.createDomain(inputSource, false);
    }

    public abstract int getState();

    public abstract void recover() throws RecoveryException;

    public static Transaction getTransaction(Xid xid) {
        TransactionDomainImpl transactionDomainImpl = _firstDomain;
        while (transactionDomainImpl != null) {
            TransactionImpl transactionImpl;
            if (transactionDomainImpl.getState() == 2 && (transactionImpl = transactionDomainImpl.findTransaction(xid)) != null) {
                return transactionImpl;
            }
            transactionDomainImpl = transactionDomainImpl.getNextDomain();
        }
        return null;
    }

    public static Transaction getTransaction(String string) {
        TransactionDomainImpl transactionDomainImpl = _firstDomain;
        while (transactionDomainImpl != null) {
            TransactionImpl transactionImpl;
            if (transactionDomainImpl.getState() == 2 && (transactionImpl = transactionDomainImpl.findTransaction(string)) != null) {
                return transactionImpl;
            }
            transactionDomainImpl = transactionDomainImpl.getNextDomain();
        }
        return null;
    }

    public abstract TransactionManager getTransactionManager();

    public abstract UserTransaction getUserTransaction();

    public abstract TransactionFactory getTransactionFactory();

    public abstract void addInterceptor(TransactionInterceptor var1);

    public abstract void removeInterceptor(TransactionInterceptor var1);

    public abstract void terminate();

    public abstract DomainMetrics getDomainMetrics();

    public abstract String getDomainName();

    public abstract Resources getResources();

    private static synchronized TransactionDomain createDomain(InputSource inputSource, boolean bl) throws DomainConfigurationException {
        DomainConfig domainConfig;
        if (inputSource == null) {
            throw new IllegalArgumentException("Argument source is null");
        }
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource((class$tyrex$tm$impl$DomainConfig == null ? (class$tyrex$tm$impl$DomainConfig = TransactionDomain.class$("tyrex.tm.impl.DomainConfig")) : class$tyrex$tm$impl$DomainConfig).getResourceAsStream("mapping.xml")));
            Unmarshaller unmarshaller = new Unmarshaller((Class)null);
            ClassDescriptorResolverImpl classDescriptorResolverImpl = new ClassDescriptorResolverImpl();
            unmarshaller.setResolver((ClassDescriptorResolver)classDescriptorResolverImpl);
            unmarshaller.setMapping(mapping);
            ResourceMappingLoader resourceMappingLoader = new ResourceMappingLoader();
            resourceMappingLoader.loadMapping(mapping.getRoot(), null);
            classDescriptorResolverImpl.setMappingLoader((XMLMappingLoader)resourceMappingLoader);
            domainConfig = (DomainConfig)unmarshaller.unmarshal(inputSource);
        }
        catch (Exception exception) {
            throw new DomainConfigurationException(exception);
        }
        String string = domainConfig.getName();
        if (string == null || string.trim().length() == 0) {
            throw new DomainConfigurationException("Transaction domain configuration file missing domain name");
        }
        string = string.trim();
        TransactionDomainImpl transactionDomainImpl = _firstDomain;
        TransactionDomainImpl transactionDomainImpl2 = null;
        while (transactionDomainImpl != null) {
            if (transactionDomainImpl.getDomainName().equals(string)) {
                if (transactionDomainImpl.getState() != 3) {
                    throw new DomainConfigurationException("Transaction domain " + string + " already exists");
                }
                transactionDomainImpl = transactionDomainImpl.getNextDomain();
                if (transactionDomainImpl2 == null) {
                    _firstDomain = transactionDomainImpl;
                    continue;
                }
                transactionDomainImpl2.setNextDomain(transactionDomainImpl);
                continue;
            }
            transactionDomainImpl2 = transactionDomainImpl;
            transactionDomainImpl = transactionDomainImpl.getNextDomain();
        }
        transactionDomainImpl2 = _firstDomain;
        if (transactionDomainImpl2 == null) {
            _firstDomain = transactionDomainImpl = (TransactionDomainImpl)domainConfig.getDomain();
        } else {
            transactionDomainImpl = transactionDomainImpl2.getNextDomain();
            while (transactionDomainImpl != null) {
                transactionDomainImpl2 = transactionDomainImpl;
                transactionDomainImpl = transactionDomainImpl.getNextDomain();
            }
            transactionDomainImpl = (TransactionDomainImpl)domainConfig.getDomain();
            transactionDomainImpl2.setNextDomain(transactionDomainImpl);
        }
        if (bl) {
            try {
                transactionDomainImpl.recover();
            }
            catch (RecoveryException recoveryException) {
                // empty catch block
            }
        }
        return transactionDomainImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        StringTokenizer stringTokenizer = new StringTokenizer(Configuration.getProperty("tyrex.domain.files", ""), ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                TransactionDomain transactionDomain = TransactionDomain.createDomain(new InputSource(string), true);
            }
            catch (DomainConfigurationException domainConfigurationException) {
                Logger.tyrex.error((Object)("Error loading domain configuration file " + string), (Throwable)domainConfigurationException);
            }
        }
    }
}

