/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class LoggerPrintWriter
extends PrintWriter {
    private final Category _category;
    private final Priority _priority;
    private final StringBuffer _buffer;
    private int _lineNumber = -1;
    private static final int LINE_NO_LENGTH = 3;

    public LoggerPrintWriter(Category category, Priority priority) {
        this(category, priority, false);
    }

    public LoggerPrintWriter(Category category, Priority priority, boolean bl) {
        super(new StringWriter());
        if (category == null) {
            throw new IllegalArgumentException("Argument category is null");
        }
        this._category = category;
        this._priority = priority == null ? Priority.INFO : priority;
        this._buffer = new StringBuffer();
        if (bl) {
            this._lineNumber = 0;
            this.addLineNumber();
        } else {
            this._lineNumber = -1;
        }
    }

    public void println() {
        this.flushLine();
    }

    public void println(boolean bl) {
        this._buffer.append(bl);
        this.flushLine();
    }

    public void print(boolean bl) {
        this._buffer.append(bl);
    }

    public void println(char c) {
        if (c == '\n') {
            this.flushLine();
        } else {
            this._buffer.append(c);
        }
        this.flushLine();
    }

    public void print(char c) {
        if (c == '\n') {
            this.flushLine();
        } else {
            this._buffer.append(c);
        }
    }

    public void println(int n) {
        this._buffer.append(n);
        this.flushLine();
    }

    public void print(int n) {
        this._buffer.append(n);
    }

    public void println(long l) {
        this._buffer.append(l);
        this.flushLine();
    }

    public void print(long l) {
        this._buffer.append(l);
    }

    public void println(float f) {
        this._buffer.append(f);
        this.flushLine();
    }

    public void print(float f) {
        this._buffer.append(f);
    }

    public void println(double d) {
        this._buffer.append(d);
        this.flushLine();
    }

    public void print(double d) {
        this._buffer.append(d);
    }

    public void println(char[] cArray) {
        if (cArray != null) {
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == '\n') {
                    this.flushLine();
                } else {
                    this._buffer.append(c);
                }
                ++n2;
            }
        }
        this.flushLine();
    }

    public void print(char[] cArray) {
        if (cArray != null) {
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == '\n') {
                    this.flushLine();
                } else {
                    this._buffer.append(c);
                }
                ++n2;
            }
        }
    }

    public void println(String string) {
        if (string == null) {
            this._buffer.append("null");
        } else {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == '\n') {
                    this.flushLine();
                } else {
                    this._buffer.append(c);
                }
                ++n2;
            }
        }
        this.flushLine();
    }

    public void print(String string) {
        if (string == null) {
            this._buffer.append("null");
        } else {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == '\n') {
                    this.flushLine();
                } else {
                    this._buffer.append(c);
                }
                ++n2;
            }
        }
    }

    public void println(Object object) {
        if (object == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append(object.toString());
        }
        this.flushLine();
    }

    public void print(Object object) {
        if (object == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append(object.toString());
        }
    }

    private void flushLine() {
        this._category.log(this._priority, (Object)this._buffer.toString());
        this._buffer.setLength(0);
        if (this._lineNumber >= 0) {
            this.addLineNumber();
        }
    }

    private void addLineNumber() {
        int n;
        int n2 = 0;
        ++this._lineNumber;
        String string = String.valueOf(this._lineNumber);
        int n3 = string.length();
        if (n3 >= 3) {
            n3 = 3;
            n2 = string.length() - n3;
        } else {
            n = 0;
            while (n < 3 - n3) {
                this._buffer.append(' ');
                ++n;
            }
        }
        n = 0;
        while (n < n3) {
            this._buffer.append(string.charAt(n + n2));
            ++n;
        }
        this._buffer.append(':').append(' ');
    }
}

